/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzab;
import com.google.android.gms.ads.internal.overlay.zzac;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzas;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zzzm;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzm
public final class zzaa
extends FrameLayout
implements zzx {
    private final zzajz zzJJ;
    private final FrameLayout zzPr;
    private final zznb zzPs;
    private final zzas zzPt;
    private final long zzPu;
    @Nullable
    private zzy zzPv;
    private boolean zzPw;
    private boolean zzPx;
    private boolean zzPy;
    private boolean zzPz;
    private long zzPA;
    private long zzPB;
    private String zzJO;
    private Bitmap zzPC;
    private ImageView zzPD;
    private boolean zzPE;

    public static void zzh(zzajz zzajz2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzajz2.zza("onVideoEvent", hashMap);
    }

    public static void zzc(zzajz zzajz2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzajz2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzajz zzajz2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string);
        zzajz2.zza("onVideoEvent", hashMap);
    }

    public zzaa(Context context, zzajz zzajz2, int n, boolean bl, zznb zznb2, zzaq zzaq2) {
        super(context);
        zzme<Constable> zzme2;
        this.zzJJ = zzajz2;
        this.zzPs = zznb2;
        this.zzPr = new FrameLayout(context);
        this.addView((View)this.zzPr, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzr((Object)zzajz2.zzak());
        this.zzPv = zzajz2.zzak().zztp.zza(context, zzajz2, n, bl, zznb2, zzaq2);
        if (this.zzPv != null) {
            this.zzPr.addView((View)this.zzPv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzme2 = zzmo.zzCy;
            if (((Boolean)((Object)zzbs.zzbL().zzd(zzme2))).booleanValue()) {
                this.zzgb();
            }
        }
        this.zzPD = new ImageView(context);
        zzme2 = zzmo.zzCC;
        this.zzPu = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzCA;
        this.zzPz = (Boolean)((Object)zzbs.zzbL().zzd(zzme2));
        if (this.zzPs != null) {
            this.zzPs.zzh("spinner_used", this.zzPz ? "1" : "0");
        }
        this.zzPt = new zzas(this);
        if (this.zzPv != null) {
            this.zzPv.zza(this);
        }
        if (this.zzPv == null) {
            this.zzj("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzPr.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzaq(String string) {
        this.zzJO = string;
    }

    public final void zza(float f, float f2) {
        if (this.zzPv != null) {
            this.zzPv.zza(f, f2);
        }
    }

    public final void zzfY() {
        if (this.zzPv == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzJO)) {
            this.zzPv.setVideoPath(this.zzJO);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzPv == null) {
            return;
        }
        this.zzPv.pause();
    }

    public final void play() {
        if (this.zzPv == null) {
            return;
        }
        this.zzPv.play();
    }

    public final void seekTo(int n) {
        if (this.zzPv == null) {
            return;
        }
        this.zzPv.seekTo(n);
    }

    public final void zzfZ() {
        if (this.zzPv == null) {
            return;
        }
        zzy zzy2 = this.zzPv;
        zzy2.zzPq.setMuted(true);
        zzy2.zzfH();
    }

    public final void zzga() {
        if (this.zzPv == null) {
            return;
        }
        zzy zzy2 = this.zzPv;
        zzy2.zzPq.setMuted(false);
        zzy2.zzfH();
    }

    public final void zzb(float f) {
        if (this.zzPv == null) {
            return;
        }
        float f2 = f;
        zzy zzy2 = this.zzPv;
        zzy2.zzPq.zzb(f2);
        zzy2.zzfH();
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzPv == null) {
            return;
        }
        this.zzPv.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzgb() {
        if (this.zzPv == null) {
            return;
        }
        Context context = this.zzPv.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzPv.zzfD());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzPr.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzPr.bringChildToFront((View)textView);
    }

    @Override
    public final void zzfS() {
        this.zzPt.resume();
        zzagy.zzZr.post((Runnable)new zzab(this));
    }

    @Override
    public final void zzfT() {
        if (this.zzPv == null) {
            return;
        }
        if (this.zzPB == 0L) {
            float f = (float)this.zzPv.getDuration() / 1000.0f;
            int n = this.zzPv.getVideoWidth();
            int n2 = this.zzPv.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzfU() {
        zzaa zzaa2 = this;
        if (zzaa2.zzJJ.zzis() != null && !zzaa2.zzPx) {
            WindowManager.LayoutParams layoutParams = zzaa2.zzJJ.zzis().getWindow().getAttributes();
            boolean bl = zzaa2.zzPy = (layoutParams.flags & 0x80) != 0;
            if (!zzaa2.zzPy) {
                zzaa2.zzJJ.zzis().getWindow().addFlags(128);
                zzaa2.zzPx = true;
            }
        }
        this.zzPw = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzge();
        this.zzPw = false;
    }

    @Override
    public final void zzfV() {
        this.zza("ended", new String[0]);
        this.zzge();
    }

    @Override
    public final void zzj(String string, @Nullable String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public final void zzfW() {
        zzaa zzaa2 = this;
        if (zzaa2.zzPE && zzaa2.zzPC != null && !zzaa2.zzgd()) {
            zzaa2.zzPD.setImageBitmap(zzaa2.zzPC);
            zzaa2.zzPD.invalidate();
            zzaa2.zzPr.addView((View)zzaa2.zzPD, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaa2.zzPr.bringChildToFront((View)zzaa2.zzPD);
        }
        this.zzPt.pause();
        this.zzPB = this.zzPA;
        zzagy.zzZr.post((Runnable)new zzac(this));
    }

    public final void destroy() {
        this.zzPt.pause();
        if (this.zzPv != null) {
            this.zzPv.stop();
        }
        this.zzge();
    }

    final void zzgc() {
        if (this.zzPv == null) {
            return;
        }
        long l = this.zzPv.getCurrentPosition();
        if (this.zzPA != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzPA = l;
        }
    }

    @Override
    public final void zzfX() {
        zzaa zzaa2;
        if (this.zzPw && (zzaa2 = this).zzgd()) {
            zzaa2.zzPr.removeView((View)zzaa2.zzPD);
        }
        zzaa2 = this;
        if (zzaa2.zzPC != null) {
            long l = zzbs.zzbF().elapsedRealtime();
            if (zzaa2.zzPv.getBitmap(zzaa2.zzPC) != null) {
                zzaa2.zzPE = true;
            }
            long l2 = zzbs.zzbF().elapsedRealtime() - l;
            if (zzafq.zzhM()) {
                zzafq.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaa2.zzPu) {
                zzafq.zzaT((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaa2.zzPz = false;
                zzaa2.zzPC = null;
                if (zzaa2.zzPs != null) {
                    zzaa2.zzPs.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzd(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaa zzaa2 = this;
        if (zzaa2.zzPz) {
            zzme<Integer> zzme2 = zzmo.zzCB;
            n4 = Math.max(n4 / zzbs.zzbL().zzd(zzme2), 1);
            zzme2 = zzmo.zzCB;
            n3 = Math.max(n3 / zzbs.zzbL().zzd(zzme2), 1);
            if (zzaa2.zzPC == null || zzaa2.zzPC.getWidth() != n4 || zzaa2.zzPC.getHeight() != n3) {
                zzaa2.zzPC = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaa2.zzPE = false;
            }
        }
    }

    private final boolean zzgd() {
        return this.zzPD.getParent() != null;
    }

    private final void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzJJ.zza("onVideoEvent", hashMap);
    }

    private final void zzge() {
        if (this.zzJJ.zzis() == null) {
            return;
        }
        if (this.zzPx && !this.zzPy) {
            this.zzJJ.zzis().getWindow().clearFlags(128);
            this.zzPx = false;
        }
    }

    static /* synthetic */ void zza(zzaa zzaa2, String string, String[] stringArray) {
        zzaa2.zza(string, stringArray);
    }
}

