/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzan;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzzm;

@zzzm
final class zzam
implements SensorEventListener {
    private final SensorManager zzPM;
    private final Object zzPN;
    private final Display zzPO;
    private final float[] zzPP;
    private final float[] zzPQ;
    private float[] zzPR;
    private Handler zzPS;
    private zzao zzPT;

    zzam(Context context) {
        this.zzPM = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzPO = windowManager.getDefaultDisplay();
        this.zzPP = new float[9];
        this.zzPQ = new float[9];
        this.zzPN = new Object();
    }

    final void start() {
        if (this.zzPS != null) {
            return;
        }
        Sensor sensor = this.zzPM.getDefaultSensor(11);
        if (sensor == null) {
            zzafq.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzPS = new Handler(handlerThread.getLooper());
        if (!this.zzPM.registerListener((SensorEventListener)this, sensor, 0, this.zzPS)) {
            zzafq.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzPS == null) {
            return;
        }
        this.zzPM.unregisterListener((SensorEventListener)this);
        this.zzPS.post((Runnable)new zzan(this));
        this.zzPS = null;
    }

    final void zza(zzao zzao2) {
        this.zzPT = zzao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzam zzam2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzam2.zzPN;
            synchronized (object) {
                if (zzam2.zzPR == null) {
                    zzam2.zzPR = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzam2.zzPP, (float[])fArray);
            switch (zzam2.zzPO.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPP, (int)2, (int)129, (float[])zzam2.zzPQ);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPP, (int)129, (int)130, (float[])zzam2.zzPQ);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPP, (int)130, (int)1, (float[])zzam2.zzPQ);
                    break;
                }
                default: {
                    System.arraycopy(zzam2.zzPP, 0, zzam2.zzPQ, 0, 9);
                }
            }
            zzam2.zze(1, 3);
            zzam2.zze(2, 6);
            zzam2.zze(5, 7);
            Object object2 = zzam2.zzPN;
            synchronized (object2) {
                System.arraycopy(zzam2.zzPQ, 0, zzam2.zzPR, 0, 9);
            }
            if (zzam2.zzPT != null) {
                zzam2.zzPT.zzfO();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzPN;
        synchronized (object) {
            if (this.zzPR == null) {
                return false;
            }
            System.arraycopy(this.zzPR, 0, fArray, 0, this.zzPR.length);
            return true;
        }
    }

    private final void zze(int n, int n2) {
        float f = this.zzPQ[n];
        this.zzPQ[n] = this.zzPQ[n2];
        this.zzPQ[n2] = f;
    }
}

