/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzap;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzar;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzzm;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzm
@TargetApi(value=14)
public final class zzd
extends zzy
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzOk = new HashMap<Integer, String>();
    private final zzar zzOl;
    private final boolean zzOm;
    private int zzOn = 0;
    private int zzOo = 0;
    private MediaPlayer zzOp;
    private Uri zzOq;
    private int zzOr;
    private int zzOs;
    private int zzOt;
    private int zzOu;
    private int zzOv;
    private zzap zzOw;
    private boolean zzOx;
    private int zzOy;
    private zzx zzOz;

    public zzd(Context context, boolean bl, boolean bl2, zzaq zzaq2, zzar zzar2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzOl = zzar2;
        this.zzOx = bl;
        this.zzOm = bl2;
        this.zzOl.zza(this);
    }

    @Override
    public final String zzfD() {
        String string = String.valueOf(this.zzOx ? " spherical" : "");
        if (string.length() != 0) {
            return "MediaPlayer".concat(string);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzx zzx2) {
        this.zzOz = zzx2;
    }

    @Override
    public final void setVideoPath(String string) {
        Uri uri = Uri.parse((String)string);
        zzd zzd2 = this;
        zzia zzia2 = zzia.zze(uri);
        zzd2.zzOq = zzia2 == null ? uri : Uri.parse((String)zzia2.url);
        zzd2.zzOy = 0;
        zzd2.zzfE();
        zzd2.requestLayout();
        zzd2.invalidate();
    }

    @Override
    public final void stop() {
        zzafq.v("AdMediaPlayerView stop");
        if (this.zzOp != null) {
            this.zzOp.stop();
            this.zzOp.release();
            this.zzOp = null;
            this.zzq(0);
            this.zzOo = 0;
        }
        this.zzOl.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzafq.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzOr = mediaPlayer.getVideoWidth();
        this.zzOs = mediaPlayer.getVideoHeight();
        if (this.zzOr != 0 && this.zzOs != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzafq.v("AdMediaPlayerView prepared");
        this.zzq(2);
        this.zzOl.zzfT();
        zzagy.zzZr.post((Runnable)new zze(this));
        this.zzOr = mediaPlayer.getVideoWidth();
        this.zzOs = mediaPlayer.getVideoHeight();
        if (this.zzOy != 0) {
            this.seekTo(this.zzOy);
        }
        this.zzfF();
        int n = this.zzOr;
        int n2 = this.zzOs;
        zzafq.zzaS((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzOo == 3) {
            this.play();
        }
        this.zzfH();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzafq.v("AdMediaPlayerView completion");
        this.zzq(5);
        this.zzOo = 5;
        zzagy.zzZr.post((Runnable)new zzf(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzOk.get(n);
        String string2 = zzOk.get(n2);
        zzafq.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzOk.get(n);
        String string2 = zzOk.get(n2);
        zzafq.zzaT((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzq(-1);
        this.zzOo = -1;
        zzagy.zzZr.post((Runnable)new zzg(this, string, string2));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzOt = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzafq.v("AdMediaPlayerView surface created");
        this.zzfE();
        zzagy.zzZr.post((Runnable)new zzh(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzafq.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzOo == 3;
        boolean bl3 = bl = this.zzOr == n && this.zzOs == n2;
        if (this.zzOp != null && bl2 && bl) {
            if (this.zzOy != 0) {
                this.seekTo(this.zzOy);
            }
            this.play();
        }
        if (this.zzOw != null) {
            this.zzOw.zzf(n, n2);
        }
        zzagy.zzZr.post((Runnable)new zzi(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzafq.v("AdMediaPlayerView surface destroyed");
        if (this.zzOp != null && this.zzOy == 0) {
            this.zzOy = this.zzOp.getCurrentPosition();
        }
        if (this.zzOw != null) {
            this.zzOw.zzgf();
        }
        zzagy.zzZr.post((Runnable)new zzj(this));
        this.zzq(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzOl.zzb(this);
        this.zzPp.zza(surfaceTexture, this.zzOz);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzOr, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzOs, (int)n2);
        if (this.zzOr > 0 && this.zzOs > 0 && this.zzOw == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzOr * n4 < n3 * this.zzOs) {
                    n3 = n4 * this.zzOr / this.zzOs;
                } else if (this.zzOr * n4 > n3 * this.zzOs) {
                    n4 = n3 * this.zzOs / this.zzOr;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzOs / this.zzOr;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzOr / this.zzOs;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzOr;
                n4 = this.zzOs;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzOr / this.zzOs;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzOs / this.zzOr;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzOw != null) {
            this.zzOw.zzf(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzOu > 0 && this.zzOu != n3 || this.zzOv > 0 && this.zzOv != n4) {
                this.zzfF();
            }
            this.zzOu = n3;
            this.zzOv = n4;
        }
    }

    public final String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(this.hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private final void zzfE() {
        zzafq.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzOq == null || surfaceTexture == null) {
            return;
        }
        this.zzq(false);
        try {
            Surface surface;
            zzbs.zzbQ();
            this.zzOp = new MediaPlayer();
            this.zzOp.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzOp.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzOp.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzOp.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzOp.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzOp.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzOt = 0;
            if (this.zzOx) {
                this.zzOw = new zzap(this.getContext());
                this.zzOw.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzOw.start();
                surface = this.zzOw.zzgg();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzOw.zzgf();
                    this.zzOw = null;
                }
            }
            this.zzOp.setDataSource(this.getContext(), this.zzOq);
            zzbs.zzbR();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzOp.setSurface(surface);
            this.zzOp.setAudioStreamType(3);
            this.zzOp.setScreenOnWhilePlaying(true);
            this.zzOp.prepareAsync();
            this.zzq(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzOq);
            zzafq.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzOp, 1, 0);
            return;
        }
    }

    private final void zzfF() {
        if (!this.zzOm) {
            return;
        }
        if (this.zzfG() && this.zzOp.getCurrentPosition() > 0 && this.zzOo != 3) {
            zzafq.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzOp.start();
            int n = this.zzOp.getCurrentPosition();
            long l = zzbs.zzbF().currentTimeMillis();
            while (this.zzfG() && this.zzOp.getCurrentPosition() == n && zzbs.zzbF().currentTimeMillis() - l <= 250L) {
            }
            this.zzOp.pause();
            this.zzfH();
        }
    }

    private final void zzq(boolean bl) {
        zzafq.v("AdMediaPlayerView release");
        if (this.zzOw != null) {
            this.zzOw.zzgf();
            this.zzOw = null;
        }
        if (this.zzOp != null) {
            this.zzOp.reset();
            this.zzOp.release();
            this.zzOp = null;
            this.zzq(0);
            if (bl) {
                this.zzOo = 0;
                this.zzOo = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzafq.v("AdMediaPlayerView play");
        if (this.zzfG()) {
            this.zzOp.start();
            this.zzq(3);
            this.zzPp.zzfU();
            zzagy.zzZr.post((Runnable)new zzk(this));
        }
        this.zzOo = 3;
    }

    @Override
    public final void pause() {
        zzafq.v("AdMediaPlayerView pause");
        if (this.zzfG() && this.zzOp.isPlaying()) {
            this.zzOp.pause();
            this.zzq(4);
            zzagy.zzZr.post((Runnable)new zzl(this));
        }
        this.zzOo = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzfG()) {
            return this.zzOp.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzfG()) {
            return this.zzOp.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzafq.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzfG()) {
            this.zzOp.seekTo(n);
            this.zzOy = 0;
            return;
        }
        this.zzOy = n;
    }

    private final boolean zzfG() {
        return this.zzOp != null && this.zzOn != -1 && this.zzOn != 0 && this.zzOn != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzOw != null) {
            this.zzOw.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzOp != null) {
            return this.zzOp.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzOp != null) {
            return this.zzOp.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzfH() {
        this.zza(this.zzPq.zzgm());
    }

    private final void zza(float f) {
        if (this.zzOp != null) {
            try {
                this.zzOp.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzafq.zzaT((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzq(int n) {
        if (n == 3) {
            this.zzOl.zzgj();
            this.zzPq.zzgj();
        } else if (this.zzOn == 3) {
            this.zzOl.zzgk();
            this.zzPq.zzgk();
        }
        this.zzOn = n;
    }

    static /* synthetic */ zzx zza(zzd zzd2) {
        return zzd2.zzOz;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzOk.put(-1004, "MEDIA_ERROR_IO");
            zzOk.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzOk.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzOk.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzOk.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzOk.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzOk.put(1, "MEDIA_ERROR_UNKNOWN");
        zzOk.put(1, "MEDIA_INFO_UNKNOWN");
        zzOk.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzOk.put(701, "MEDIA_INFO_BUFFERING_START");
        zzOk.put(702, "MEDIA_INFO_BUFFERING_END");
        zzOk.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzOk.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzOk.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzOk.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzOk.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

