/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzbl;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzakr;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzwt;
import com.google.android.gms.internal.zzzm;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzm
final class zzakn
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzajz {
    private final zzakq zzabS;
    private final Object mLock = new Object();
    @Nullable
    private final zzcu zzIe;
    private final zzajd zztY;
    private final zzbl zzabT;
    private final zzv zzsU;
    private zzaka zzabU;
    private zzm zzabV;
    private zziv zzvb;
    private boolean zzabW;
    private boolean zzabX;
    private boolean zzabY;
    private boolean zzabZ;
    private Boolean zzYA;
    private int zzaca;
    private boolean zzacb = true;
    private boolean zzacc = false;
    private String zzQx = "";
    private zzakr zzacd;
    private boolean zzace;
    private boolean zzacf;
    private zznw zzacg;
    private int zzach;
    private int zzaci;
    private zzmz zzacj;
    private zzmz zzQy;
    private zzmz zzack;
    private zzna zzacl;
    private WeakReference<View.OnClickListener> zzacm;
    private zzm zzacn;
    private boolean zzaco;
    private zzaiw zzwE;
    private int zzNZ = -1;
    private int zzNY = -1;
    private int zzOb = -1;
    private int zzOc = -1;
    private Map<String, zzsb> zzacp;
    private final WindowManager zzwT;
    private final zzig zzacq;

    static zzakn zzb(Context context, zziv zziv2, boolean bl, boolean bl2, @Nullable zzcu zzcu2, zzajd zzajd2, zznb zznb2, zzbl zzbl2, zzv zzv2, zzig zzig2) {
        zzakq zzakq2 = new zzakq(context);
        return new zzakn(zzakq2, zziv2, bl, bl2, zzcu2, zzajd2, zznb2, zzbl2, zzv2, zzig2);
    }

    private zzakn(zzakq zzakq2, zziv zziv2, boolean bl, boolean bl2, @Nullable zzcu zzcu2, zzajd zzajd2, zznb zznb2, zzbl zzbl2, zzv zzv2, zzig zzig2) {
        super((Context)zzakq2);
        this.zzabS = zzakq2;
        this.zzvb = zziv2;
        this.zzabY = bl;
        this.zzaca = -1;
        this.zzIe = zzcu2;
        this.zztY = zzajd2;
        this.zzabT = zzbl2;
        this.zzsU = zzv2;
        this.zzwT = (WindowManager)this.getContext().getSystemService("window");
        this.zzacq = zzig2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzafq.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string2 = zzajd2.zzaR;
        zzakq zzakq3 = zzakq2;
        zzagy zzagy2 = zzbs.zzbz();
        webSettings2.setUserAgentString(zzagy2.zzs((Context)zzakq3, string2));
        zzbs.zzbB().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzjd();
        if (zzq.zzsa()) {
            this.addJavascriptInterface(new zzaku(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzwE = new zzaiw(this.zzabS.zzis(), (View)this, this, null);
        this.zzd(zznb2);
        zzbs.zzbB().zzR((Context)zzakq2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzaka) {
            this.zzabU = (zzaka)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzv zzak() {
        return this.zzsU;
    }

    private final boolean zzjb() {
        int n;
        int n2;
        if (!this.zzabU.zzcn() && !this.zzabU.zziP()) {
            return false;
        }
        zzbs.zzbz();
        DisplayMetrics displayMetrics = zzagy.zza(this.zzwT);
        zzji.zzds();
        int n3 = zzaix.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzji.zzds();
        int n4 = zzaix.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzabS.zzis();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbs.zzbz();
            int[] nArray = zzagy.zzf(activity);
            zzji.zzds();
            n2 = zzaix.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzji.zzds();
            n = zzaix.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzNY == n3 && this.zzNZ == n4 && this.zzOb == n2 && this.zzOc == n) {
            return false;
        }
        boolean bl = this.zzNY != n3 || this.zzNZ != n4;
        this.zzNY = n3;
        this.zzNZ = n4;
        this.zzOb = n2;
        this.zzOc = n;
        new zzwt(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzwT.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbs.zzbz().zzj(map);
        }
        catch (JSONException jSONException) {
            zzafq.zzaT((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaW(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    zzbs.zzbD().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzafq.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaU(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzbs.zzbD().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzafq.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaX(String string2) {
        if (zzq.zzsc()) {
            Object object;
            zzakn zzakn2;
            if (this.zzhw() == null) {
                zzakn2 = this;
                object = zzakn2.mLock;
                synchronized (object) {
                    zzakn2.zzYA = zzbs.zzbD().zzhw();
                    if (zzakn2.zzYA == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzakn2.evaluateJavascript(string3, null);
                            zzakn2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzakn2.zza(false);
                        }
                    }
                }
            }
            if (this.zzhw().booleanValue()) {
                object = string2;
                zzakn2 = this;
                Object object2 = zzakn2.mLock;
                synchronized (object2) {
                    if (!zzakn2.isDestroyed()) {
                        zzakn2.evaluateJavascript((String)object, null);
                    } else {
                        zzafq.zzaT((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzaW(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzaW(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzYA = bl;
        }
        zzbs.zzbD().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzhw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzYA;
        }
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzi(string2, string3);
    }

    @Override
    public final void zzi(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzaX(string4);
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzafq.zzaC((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzaX(stringBuilder.toString());
    }

    @Override
    public final void zziq() {
        this.zzjc();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztY.zzaR);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzA(int n) {
        if (n == 0) {
            zzakn zzakn2 = this;
            zzmu.zza(zzakn2.zzacl.zzdR(), zzakn2.zzQy, "aebb2");
        }
        this.zzjc();
        if (this.zzacl.zzdR() != null) {
            this.zzacl.zzdR().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zztY.zzaR);
        this.zza("onhide", hashMap);
    }

    private final void zzjc() {
        zzmu.zza(this.zzacl.zzdR(), this.zzQy, "aeh2");
    }

    @Override
    public final void zzfP() {
        if (this.zzacj == null) {
            zzmu.zza(this.zzacl.zzdR(), this.zzQy, "aes2");
            this.zzacj = zzmu.zzb(this.zzacl.zzdR());
            this.zzacl.zza("native:view_show", this.zzacj);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztY.zzaR);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzir() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbs.zzbz();
        hashMap.put("app_muted", String.valueOf(zzagy.zzbh()));
        zzbs.zzbz();
        hashMap.put("app_volume", String.valueOf(zzagy.zzbf()));
        zzbs.zzbz();
        hashMap.put("device_volume", String.valueOf(zzagy.zzM(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zziu() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabV;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zziv() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zziv zzam() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzvb;
        }
    }

    @Override
    public final zzaka zziw() {
        return this.zzabU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzix() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabW;
        }
    }

    @Override
    public final zzcu zziy() {
        return this.zzIe;
    }

    @Override
    public final zzajd zziz() {
        return this.zztY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziA() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabY;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbs.zzbz();
            zzagy.zzb(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafq.zzaC((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzabU.zziP()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzacg != null) {
                    this.zzacg.zzc(motionEvent);
                }
            }
        } else if (this.zzIe != null) {
            this.zzIe.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzme<Boolean> zzme2 = zzmo.zzDH;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzabY || this.zzvb.zzAx) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzvb.zzAy) {
                int n3;
                Object object2 = zzmo.zzFF;
                if (zzbs.zzbL().zzd(object2).booleanValue() || !zzq.zzsa()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzako((zzakn)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzaX(string2);
                float f = this.zzabS.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzaci) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzaci * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzvb.zzAv) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzwT.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzvb.widthPixels > n9 || this.zzvb.heightPixels > n10) {
                float f = this.zzabS.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzvb.widthPixels / f);
                int n12 = (int)((float)this.zzvb.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzafq.zzaT((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzvb.widthPixels, this.zzvb.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzjb();
        zzm zzm2 = this.zziu();
        if (zzm2 != null && bl) {
            zzm2.zzfO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(Context context, zziv zziv2, zznb zznb2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwE.zzih();
            this.setContext(context);
            this.zzabV = null;
            this.zzvb = zziv2;
            this.zzabY = false;
            this.zzabW = false;
            this.zzQx = "";
            this.zzaca = -1;
            zzbs.zzbB();
            zzahd.zzl(this);
            this.loadUrl("about:blank");
            this.zzabU.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzacb = true;
            this.zzacc = false;
            this.zzacd = null;
            this.zzd(zznb2);
            this.zzace = false;
            this.zzach = 0;
            zzbs.zzbW();
            zzsa.zze(this);
            this.zzjf();
            return;
        }
    }

    private final void zzd(zznb zznb2) {
        this.zzjg();
        this.zzacl = new zzna(new zznb(true, "make_wv", this.zzvb.zzAu));
        this.zzacl.zzdR().zzc(zznb2);
        this.zzQy = zzmu.zzb(this.zzacl.zzdR());
        this.zzacl.zza("native:view_create", this.zzQy);
        this.zzack = null;
        this.zzacj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzabV = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacn = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zziv zziv2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzvb = zziv2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzA(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzabY;
            this.zzabY = bl;
            this.zzjd();
            if (bl2) {
                new zzwt(this).zzap(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zziJ() {
        this.zzwE.zzig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzwE.onAttachedToWindow();
            }
            boolean bl = this.zzace;
            if (this.zzabU != null && this.zzabU.zziP()) {
                bl = true;
                if (!this.zzacf) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzabU.zziQ();
                    if (onGlobalLayoutListener != null) {
                        zzbs.zzbX();
                        zzaju.zza((View)this, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzabU.zziR()) != null) {
                        zzbs.zzbX();
                        zzaju.zza((View)this, onScrollChangedListener);
                    }
                    this.zzacf = true;
                }
                this.zzjb();
            }
            this.zzF(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzwE.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzacf && this.zzabU != null && this.zzabU.zziP() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzabU.zziQ();
                if (onGlobalLayoutListener != null) {
                    zzbs.zzbB().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzabU.zziR()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzacf = false;
            }
        }
        this.zzF(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzabS.setBaseContext(context);
        this.zzwE.zzi(this.zzabS.zzis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzB(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzabV != null) {
                this.zzabV.zza(this.zzabU.zzcn(), bl);
            } else {
                this.zzabW = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaca;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaca = n;
            if (this.zzabV != null) {
                this.zzabV.setRequestedOrientation(this.zzaca);
            }
            return;
        }
    }

    @Override
    public final Activity zzis() {
        return this.zzabS.zzis();
    }

    @Override
    public final Context zzit() {
        return this.zzabS.zzit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzjd() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzabY || this.zzvb.zzAv) {
                zzafq.zzaC((String)"Enabling hardware acceleration on an overlay.");
                this.zzje();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzafq.zzaC((String)"Disabling hardware acceleration on an AdView.");
                zzakn zzakn2 = this;
                Object object2 = zzakn2.mLock;
                synchronized (object2) {
                    if (!zzakn2.zzabZ) {
                        zzbs.zzbB().zzr((View)zzakn2);
                    }
                    zzakn2.zzabZ = true;
                }
            } else {
                zzafq.zzaC((String)"Enabling hardware acceleration on an AdView.");
                this.zzje();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzje() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzabZ) {
                zzbs.zzbB().zzq((View)this);
            }
            this.zzabZ = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzjg();
            this.zzwE.zzih();
            if (this.zzabV != null) {
                this.zzabV.close();
                this.zzabV.onDestroy();
                this.zzabV = null;
            }
            this.zzabU.reset();
            if (this.zzabX) {
                return;
            }
            zzbs.zzbW();
            zzsa.zze(this);
            this.zzjf();
            this.zzabX = true;
            zzafq.v("Initiating WebView self destruct sequence in 3...");
            this.zzabU.zziT();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzabX) {
                        this.zzabU.reset();
                        zzbs.zzbW();
                        zzsa.zze(this);
                        this.zzjf();
                        this.zzhI();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zziB() {
        Object object = this.mLock;
        synchronized (object) {
            zzafq.v("Destroying WebView!");
            this.zzhI();
            zzagy.zzZr.post((Runnable)new zzakp(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzhI() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzaco) {
                this.zzaco = true;
                zzbs.zzbD().zzhI();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabX;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzabU != null && this.zzabU.zzja() != null) {
            this.zzabU.zzja().zzaS();
        }
    }

    @Override
    public final void zziK() {
        if (this.zzack == null) {
            this.zzack = zzmu.zzb(this.zzacl.zzdR());
            this.zzacl.zza("native:view_load", this.zzack);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzC(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacb = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziC() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziD() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaJ() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacc = true;
            if (this.zzabT != null) {
                this.zzabT.zzaJ();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaK() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacc = false;
            if (this.zzabT != null) {
                this.zzabT.zzaK();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzjf() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacp = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaV(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzQx = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzQx;
        }
    }

    @Override
    public final zzajy zziE() {
        return null;
    }

    @Override
    public final zzmz zziF() {
        return this.zzQy;
    }

    @Override
    public final zzna zziG() {
        return this.zzacl;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzacm = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener zziL() {
        return (View.OnClickListener)this.zzacm.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zznw zznw2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacg = zznw2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zznw zziM() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzakr zziH() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzakr zzakr2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzacd != null) {
                zzafq.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzacd = zzakr2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziI() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzach > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzD(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzach += bl ? 1 : -1;
            if (this.zzach <= 0 && this.zzabV != null) {
                this.zzabV.zzfR();
            }
            return;
        }
    }

    private final void zzjg() {
        if (this.zzacl == null) {
            return;
        }
        zznb zznb2 = this.zzacl.zzdR();
        if (zznb2 != null && zzbs.zzbD().zzhr() != null) {
            zzbs.zzbD().zzhr().zza(zznb2);
        }
    }

    @Override
    public final void zziN() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgh zzgh2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzace = zzgh2.zzxU;
        }
        this.zzF(zzgh2.zzxU);
    }

    private final void zzF(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzrd zzrd2) {
        if (this.zzabU != null) {
            this.zzabU.zza(string2, zzrd2);
        }
    }

    @Override
    public final void zzb(String string2, zzrd zzrd2) {
        if (this.zzabU != null) {
            this.zzabU.zzb(string2, zzrd2);
        }
    }

    static /* synthetic */ Object zza(zzakn zzakn2) {
        return zzakn2.mLock;
    }

    static /* synthetic */ int zzb(zzakn zzakn2) {
        return zzakn2.zzaci;
    }

    static /* synthetic */ int zza(zzakn zzakn2, int n) {
        zzakn2.zzaci = n;
        return zzakn2.zzaci;
    }

    static /* synthetic */ void zzc(zzakn zzakn2) {
        super.destroy();
    }
}

