/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.adg;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzazm;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdb {
    private static final String TAG = zzdb.class.getSimpleName();
    protected Context zzqF;
    private Context zzqG;
    private ExecutorService zzqH;
    private DexClassLoader zzqI;
    private zzcw zzqJ;
    private byte[] zzqK;
    private volatile AdvertisingIdClient zzqL = null;
    private volatile boolean zzqm = false;
    private Future zzqM = null;
    private volatile zzax zzqN = null;
    private Future zzqO = null;
    private zzcn zzqP;
    private GoogleApiClient zzqQ = null;
    protected boolean zzqR = false;
    private static Object zzqS = new Object();
    private boolean zzqT = false;
    private static zze zzqU = null;
    protected boolean zzqV = false;
    private Map<Pair<String, String>, zzea> zzqW;
    private boolean zzqX = false;

    public static zzdb zza(Context context, String string2, String string3, boolean bl) {
        zzdb zzdb2 = new zzdb(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdb zzdb3 = zzdb2;
            zzdb2.zzqH = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzdb3;
            zzdb3.zzqm = bl3;
            if (bl3) {
                ((zzdb)object).zzqM = ((zzdb)object).zzqH.submit(new zzdc((zzdb)object));
            }
            zzdb zzdb4 = zzdb3;
            zzdb4.zzqH.execute(new zzde(zzdb4));
            try {
                zzqU = zze.zzoW();
                zzdb4.zzqR = zze.zzau((Context)zzdb4.zzqF) > 0;
                boolean bl4 = zzdb4.zzqT = zzqU.isGooglePlayServicesAvailable(zzdb4.zzqF) == 0;
                if (zzdb4.zzqF.getApplicationContext() != null) {
                    zzdb4.zzqQ = new GoogleApiClient.Builder(zzdb4.zzqF).addApi(zzazm.API).build();
                }
            }
            catch (Throwable throwable) {}
            zzdb3.zza(0, true);
            if (zzdg.zzS()) {
                object = zzmo.zzFc;
                if (((Boolean)zzbs.zzbL().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzdb4 = zzdb3;
            zzdb3.zzqJ = new zzcw(null);
            try {
                zzdb4.zzqK = zzdb4.zzqJ.zzl(string6);
            }
            catch (zzcx zzcx2) {
                throw new zzcy(zzcx2);
            }
            string6 = string4;
            zzdb4 = zzdb3;
            try {
                String string7;
                File file = zzdb4.zzqF.getCacheDir();
                if (file == null && (file = zzdb4.zzqF.getDir("dex", 0)) == null) {
                    throw new zzcy();
                }
                String string8 = string7 = "1489418796403";
                File file2 = file;
                String string9 = string6;
                zzdb zzdb5 = zzdb4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzdb5.zzqJ.zza(zzdb5.zzqK, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdb4.zzb(file, string7);
                try {
                    zzdb4.zzqI = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdb4.zzqF.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdb.zza(file4);
                    zzdb4.zza(file, string7);
                    zzdb.zzm(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzdb.zza(file4);
                zzdb4.zza(file, string7);
                zzdb.zzm(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcy(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcy(iOException);
            }
            catch (zzcx zzcx3) {
                throw new zzcy(zzcx3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcy(nullPointerException);
            }
            zzdb3.zzqP = new zzcn(zzdb3);
            zzdb3.zzqX = true;
        }
        catch (zzcy zzcy2) {}
        return zzdb2;
    }

    public final Context getContext() {
        return this.zzqF;
    }

    public final boolean isInitialized() {
        return this.zzqX;
    }

    public final Context getApplicationContext() {
        return this.zzqG;
    }

    public final ExecutorService zzC() {
        return this.zzqH;
    }

    public final DexClassLoader zzD() {
        return this.zzqI;
    }

    public final zzcw zzE() {
        return this.zzqJ;
    }

    public final byte[] zzF() {
        return this.zzqK;
    }

    public final GoogleApiClient zzG() {
        return this.zzqQ;
    }

    public final boolean zzH() {
        return this.zzqR;
    }

    public final zzcn zzI() {
        return this.zzqP;
    }

    public final boolean zzJ() {
        return this.zzqT;
    }

    public final zzax zzK() {
        return this.zzqN;
    }

    public final Future zzL() {
        return this.zzqO;
    }

    private zzdb(Context context) {
        this.zzqF = context;
        this.zzqG = context.getApplicationContext();
        this.zzqW = new HashMap<Pair<String, String>, zzea>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        zzbc zzbc2 = new zzbc();
        new zzbc().zzcI = Build.VERSION.SDK.getBytes();
        zzbc2.zzcH = string2.getBytes();
        byte[] byArray2 = this.zzqJ.zzc(this.zzqK, byArray).getBytes();
        zzbc2.data = byArray2;
        zzbc2.zzcG = zzbv.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = adg.zzc((adg)zzbc2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdb.zza(file2);
        return;
        catch (zzcx | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdb.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbc zzbc2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdb.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdb.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbc2 = (zzbc)adg.zza((adg)new zzbc(), (byte[])byArray2);
                if (string2.equals(new String(zzbc2.zzcH)) && Arrays.equals(zzbc2.zzcG, zzbv.zzb(zzbc2.data)) && Arrays.equals(zzbc2.zzcI, Build.VERSION.SDK.getBytes())) break block30;
                zzdb.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzqJ.zza(this.zzqK, new String(zzbc2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcx | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzqW.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzqW.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzea(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzea zzea2 = this.zzqW.get(new Pair((Object)string2, (Object)string3));
        if (zzea2 == null) {
            return null;
        }
        return zzea2.zzY();
    }

    private final void zzM() {
        try {
            if (this.zzqL == null && this.zzqG != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzqG);
                advertisingIdClient.start();
                this.zzqL = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzqL = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzqT) {
            return;
        }
        Future<?> future = this.zzqH.submit(new zzdd(this, n, bl));
        if (n == 0) {
            this.zzqO = future;
        }
    }

    @VisibleForTesting
    final zzax zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzN();
    }

    private static boolean zza(int n, zzax zzax2) {
        if (n < 4) {
            if (zzax2 == null) {
                return true;
            }
            zzme<Boolean> zzme2 = zzmo.zzFf;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && (zzax2.zzaV == null || zzax2.zzaV.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzme2 = zzmo.zzFg;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && (zzax2.zzcb == null || zzax2.zzcb.zzcz == null || zzax2.zzcb.zzcz == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzax zzN() {
        zzax zzax2 = null;
        try {
            PackageInfo packageInfo = this.zzqF.getPackageManager().getPackageInfo(this.zzqF.getPackageName(), 0);
            zzax2 = zzcap.zzn((Context)this.zzqF, (String)this.zzqF.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzax2;
    }

    public final AdvertisingIdClient zzO() {
        if (!this.zzqm) {
            return null;
        }
        if (this.zzqL != null) {
            return this.zzqL;
        }
        if (this.zzqM != null) {
            try {
                this.zzqM.get(2000L, TimeUnit.MILLISECONDS);
                this.zzqM = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzqM.cancel(true);
            }
        }
        return this.zzqL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzP() {
        try {
            Object object = zzqS;
            synchronized (object) {
                if (this.zzqV) {
                    return;
                }
                if (this.zzqT && this.zzqQ != null) {
                    this.zzqQ.connect();
                    this.zzqV = true;
                } else {
                    this.zzqV = false;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzQ() {
        Object object = zzqS;
        synchronized (object) {
            if (this.zzqV && this.zzqQ != null) {
                this.zzqQ.disconnect();
                this.zzqV = false;
            }
            return;
        }
    }

    public final int zzy() {
        int n = Integer.MIN_VALUE;
        if (this.zzqP != null) {
            n = zzcn.zzy();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdb zzdb2) {
        zzdb2.zzM();
    }

    static /* synthetic */ zzax zza(zzdb zzdb2, zzax zzax2) {
        zzdb2.zzqN = zzax2;
        return zzdb2.zzqN;
    }

    static /* synthetic */ boolean zzb(int n, zzax zzax2) {
        return zzdb.zza(n, zzax2);
    }
}

