/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzzm;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzm
public final class zzfi
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzafe> zzwP;
    private WeakReference<ViewTreeObserver> zzwQ;
    private final zzgs zzwR;
    protected final zzfg zzwS;
    private final Context mApplicationContext;
    private final WindowManager zzwT;
    private final PowerManager zzwU;
    private final KeyguardManager zzwV;
    private final DisplayMetrics zzwW;
    @Nullable
    private zzfp zzwX;
    private boolean zzwY;
    private boolean zzuX = false;
    private boolean zzwZ = false;
    private boolean zzxa;
    private boolean zzxb;
    private boolean zzxc;
    @Nullable
    private BroadcastReceiver zzxd;
    private final HashSet<Object> zzxe = new HashSet();
    private zzaiq zzwz;
    private final HashSet<zzgd> zzxf = new HashSet();
    private final Rect zzxg = new Rect();
    private final zzfl zzxh;
    private float zzxi;

    public zzfi(Context context, zziv zziv2, zzafe zzafe2, zzajd zzajd2, zzgs zzgs2) {
        this.zzwP = new WeakReference<zzafe>(zzafe2);
        this.zzwR = zzgs2;
        this.zzwQ = new WeakReference<Object>(null);
        this.zzxa = true;
        this.zzxc = false;
        this.zzwz = new zzaiq(200L);
        this.zzwS = new zzfg(UUID.randomUUID().toString(), zzajd2, zziv2.zzAu, zzafe2.zzXL, zzafe2.zzcn(), zziv2.zzAx);
        this.zzwT = (WindowManager)context.getSystemService("window");
        this.zzwU = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzwV = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzxh = new zzfl(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzxh);
        this.zzwW = context.getResources().getDisplayMetrics();
        Display display = this.zzwT.getDefaultDisplay();
        this.zzxg.right = display.getWidth();
        this.zzxg.bottom = display.getHeight();
        this.zzcp();
    }

    public final void zzcp() {
        zzbs.zzbz();
        this.zzxi = zzagy.zzM(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcq() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzxa) {
                this.zzxb = true;
                try {
                    JSONObject jSONObject = this.zzcu();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafq.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafq.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzwS.zzcm());
                zzafq.zzaC((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzg(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgd> iterator = this.zzxf.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzcy()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzxa) {
                return;
            }
            View view = this.zzwR.zzcv();
            boolean bl3 = view != null && zzbs.zzbz().zza(view, this.zzwU, this.zzwV);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzwR.zzcw()) {
                this.zzcq();
                return;
            }
            if (n == 1 && !this.zzwz.tryAcquire() && bl == this.zzxc) {
                return;
            }
            if (!bl && !this.zzxc && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzxc = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafq.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfi zzfi2 = this;
            View view2 = zzfi2.zzwR.zzcx().zzcv();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfi2.zzwQ.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfi2.zzct();
                    if (!zzfi2.zzwY || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfi2.zzwY = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfi2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfi2);
                    }
                    zzfi2.zzwQ = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzcr();
            return;
        }
    }

    private final void zzcr() {
        if (this.zzwX != null) {
            this.zzwX.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcs() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzxa;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzwS.zzcm());
    }

    final void zzb(zzajz zzajz2, Map<String, String> map) {
        this.zzg(3);
    }

    final void zza(zzgd zzgd2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzwS.zzcm());
        zzafq.zzaC((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgd2);
    }

    final void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzxe.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzct() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwQ.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzcu() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzwS.zzck()).put("activeViewJSON", (Object)this.zzwS.zzcl()).put("timestamp", zzbs.zzbF().elapsedRealtime()).put("adFormat", (Object)this.zzwS.zzcj()).put("hashCode", (Object)this.zzwS.zzcm()).put("isMraid", this.zzwS.zzcn()).put("isStopped", this.zzwZ).put("isPaused", this.zzuX).put("isNative", this.zzwS.zzco()).put("isScreenOn", this.isScreenOn());
        zzbs.zzbz();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzagy.zzbh());
        zzbs.zzbz();
        jSONObject3.put("appVolume", (double)zzagy.zzbf()).put("deviceVolume", (double)this.zzxi);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfi.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfi zzfi2 = this;
            ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi2.zzxf);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgd zzgd2 = arrayList.get(i);
                zzgd2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafq.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgd zzgd2) {
        if (this.zzxf.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                if (zzfi2.zzxd != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfi2.zzxd = new zzfj(zzfi2);
                    zzfi2.mApplicationContext.registerReceiver(zzfi2.zzxd, intentFilter);
                }
            }
            this.zzg(3);
        }
        this.zzxf.add(zzgd2);
        try {
            JSONObject jSONObject = zzfi.zza(this.zza(this.zzwR.zzcv(), null));
            zzgd2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafq.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgd zzgd2) {
        this.zzxf.remove(zzgd2);
        zzgd2.zzcz();
        if (this.zzxf.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                zzfi2.zzct();
                zzfi zzfi3 = zzfi2;
                Object object2 = zzfi3.mLock;
                synchronized (object2) {
                    if (zzfi3.zzxd != null) {
                        try {
                            zzfi3.mApplicationContext.unregisterReceiver(zzfi3.zzxd);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafq.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbs.zzbD().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfi3.zzxd = null;
                    }
                }
                zzfi2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfi2.zzxh);
                zzfi2.zzxa = false;
                zzfi2.zzcr();
                zzfi3 = zzfi2;
                ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi3.zzxf);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgd zzgd3 = arrayList.get(i);
                    zzgd zzgd4 = zzgd3;
                    zzfi3.zzb(zzgd4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfi zzfi2 = this;
            return zzfi2.zzcu().put("isAttachedToWindow", false).put("isScreenOn", zzfi2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbs.zzbB().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzcu();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfi.zza(this.zzxg.top, this.zzwW)).put("bottom", zzfi.zza(this.zzxg.bottom, this.zzwW)).put("left", zzfi.zza(this.zzxg.left, this.zzwW)).put("right", zzfi.zza(this.zzxg.right, this.zzwW))).put("adBox", (Object)new JSONObject().put("top", zzfi.zza(rect.top, this.zzwW)).put("bottom", zzfi.zza(rect.bottom, this.zzwW)).put("left", zzfi.zza(rect.left, this.zzwW)).put("right", zzfi.zza(rect.right, this.zzwW))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect2.top, this.zzwW)).put("bottom", zzfi.zza(rect2.bottom, this.zzwW)).put("left", zzfi.zza(rect2.left, this.zzwW)).put("right", zzfi.zza(rect2.right, this.zzwW))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect3.top, this.zzwW)).put("bottom", zzfi.zza(rect3.bottom, this.zzwW)).put("left", zzfi.zza(rect3.left, this.zzwW)).put("right", zzfi.zza(rect3.right, this.zzwW))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfi.zza(rect4.top, this.zzwW)).put("bottom", zzfi.zza(rect4.bottom, this.zzwW)).put("left", zzfi.zza(rect4.left, this.zzwW)).put("right", zzfi.zza(rect4.right, this.zzwW))).put("screenDensity", (double)this.zzwW.density);
        if (bl == null) {
            bl = zzbs.zzbz().zza(view, this.zzwU, this.zzwV);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzwU.isInteractive();
        }
        return this.zzwU.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzg(1);
    }

    public final void onGlobalLayout() {
        this.zzg(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfp zzfp2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwX = zzfp2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwZ = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuX = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuX = false;
            this.zzg(3);
            return;
        }
    }
}

