/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaeu;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzzm;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzm
public class zzoc
implements zzny {
    private final Object mLock = new Object();
    private final zznz zzHZ;
    private final Context mContext;
    @Nullable
    private final JSONObject zzIc;
    @Nullable
    private zzyg zzuR;
    @Nullable
    private final zzoa zzId;
    private final zzcu zzIe;
    @Nullable
    private final zzajd zztY;
    boolean zzIf;
    @Nullable
    private String zzIg;
    @Nullable
    private zzaeu zzum;
    private WeakReference<View> zzIh = null;

    public zzoc(Context context, zznz zznz2, @Nullable zzyg zzyg2, zzcu zzcu2, @Nullable JSONObject jSONObject, @Nullable zzoa zzoa2, @Nullable zzajd zzajd2, @Nullable String string) {
        this.mContext = context;
        this.zzHZ = zznz2;
        this.zzuR = zzyg2;
        this.zzIe = zzcu2;
        this.zzIc = jSONObject;
        this.zzId = zzoa2;
        this.zztY = zzajd2;
        this.zzIg = string;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zznn zznn2 = this.zzId.zzek();
        if (zznn2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zznn2.zzee()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzno zzno2 = new zzno(this.mContext, zznn2, layoutParams);
        zzno2.setOnClickListener(onClickListener);
        zzme<String> zzme2 = zzmo.zzFC;
        zzno2.setContentDescription(zzbs.zzbL().zzd(zzme2));
        return zzno2;
    }

    @Override
    public boolean zzep() {
        zznn zznn2 = this.zzId.zzek();
        return zznn2 != null && zznn2.zzef();
    }

    @Override
    public final void zza(View view, String string, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzi(view2);
        JSONObject jSONObject3 = zzoc.zzj(view2);
        JSONObject jSONObject4 = null;
        try {
            JSONObject jSONObject5 = zzbs.zzbz().zza(bundle, null);
            jSONObject4 = new JSONObject();
            jSONObject4.put("click_point", (Object)jSONObject5);
            jSONObject4.put("asset_id", (Object)string);
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Error occured while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, string, jSONObject4, null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbo.zzcz((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), bundle, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzId.zzej())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzId.zzej())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void zzc(Bundle bundle) {
        if (bundle == null) {
            zzafq.zzaC((String)"Click data is null. No click is reported.");
            return;
        }
        String string = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbs.zzbz().zza(bundle, null);
        this.zza(null, null, null, null, string, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String string, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbo.zzcz((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzIc);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("click_signal", (Object)jSONObject4);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("asset_id", (Object)string);
            jSONObject7.put("template", (Object)this.zzId.zzej());
            jSONObject7.put("has_custom_click_handler", this.zzHZ.zzs(this.zzId.getCustomTemplateId()) != null);
            jSONObject6.put("has_custom_click_handler", this.zzHZ.zzs(this.zzId.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject8 = this.zzIc.optJSONObject("tracking_urls_and_actions");
                if (jSONObject8 == null) {
                    jSONObject8 = new JSONObject();
                }
                String string2 = jSONObject8.optString("click_string");
                String string3 = this.zzIe.zzB().zza(this.mContext, string2, view);
                jSONObject7.put("click_signals", (Object)string3);
            }
            catch (Exception exception) {
                zzafq.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject6.put("click", (Object)jSONObject7);
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            jSONObject6.put("ads_id", (Object)this.zzIg);
            this.zzuR.zza(new zzod(this, jSONObject6));
            return;
        }
        catch (JSONException jSONException) {
            zzafq.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzIe.zza(motionEvent);
    }

    @Override
    public final void zze(Bundle bundle) {
        if (bundle == null) {
            zzafq.zzaC((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzIe.zzB().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzIf) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zza(view, map);
            return;
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzi(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzoc.zzj(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, null);
    }

    @Override
    public final boolean zzd(Bundle bundle) {
        JSONObject jSONObject = zzbs.zzbz().zza(bundle, null);
        return this.zza(null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4) {
        zzbo.zzcz((String)"recordImpression must be called on the main UI thread.");
        this.zzIf = true;
        try {
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzIc);
            jSONObject5.put("ads_id", (Object)this.zzIg);
            if (jSONObject2 != null) {
                jSONObject5.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject5.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject5.put("provided_signals", (Object)jSONObject4);
            }
            this.zzuR.zza(new zzoe(this, jSONObject5));
            this.zzuR.zza(new zzof(this.zzHZ, this.zzIg));
        }
        catch (JSONException jSONException) {
            zzafq.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzHZ.zza(this);
        this.zzHZ.zzaw();
        return true;
    }

    @Override
    public final View zzeu() {
        if (this.zzIh != null) {
            return (View)this.zzIh.get();
        }
        return null;
    }

    @Override
    public final void zzg(View view) {
        this.zzIh = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        zzme<Boolean> zzme2 = zzmo.zzFA;
        if (!zzbs.zzbL().zzd(zzme2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzme<Boolean> zzme2 = zzmo.zzFz;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzajz zzes() throws zzakl {
        if (this.zzIc == null || this.zzIc.optJSONObject("overlay") == null) {
            return null;
        }
        Object object = this;
        zzajd zzajd2 = ((zzoc)object).zztY;
        zzcu zzcu2 = ((zzoc)object).zzIe;
        zziv zziv2 = zziv.zzg((Context)((zzoc)object).mContext);
        Context context = ((zzoc)object).mContext;
        zzajz zzajz2 = zzbs.zzbA().zza(context, zziv2, false, false, zzcu2, zzajd2, null, null, null, zzig.zzde());
        zzajz2.getView().setVisibility(8);
        object = new zzog(zzajz2);
        this.zzuR.zza(new zzom((zzog)object));
        return zzajz2;
    }

    public final void zzd(Map<String, WeakReference<View>> map) {
        if (this.zzId.zzel() != null) {
            if ("2".equals(this.zzId.zzej())) {
                zzbs.zzbD().zzb(this.mContext, this.zzHZ.getAdUnitId(), this.zzId.zzej(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzId.zzej())) {
                zzbs.zzbD().zzb(this.mContext, this.zzHZ.getAdUnitId(), this.zzId.zzej(), map.containsKey("1009"));
            }
        }
    }

    @Override
    public final void zza(View view, zznw zznw2) {
        Object object;
        zzos zzos2;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzId.zzel();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzHZ.zza(zznw2);
            return;
        }
        if (!(this.zzId instanceof zzob)) {
            return;
        }
        zzob zzob2 = (zzob)this.zzId;
        if (zzob2.getImages() != null && zzob2.getImages().size() > 0 && (zzos2 = (object = zzob2.getImages().get(0)) instanceof IBinder ? zzot.zzi((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzos2.zzeg();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzE((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzoc)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzaT((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public final void zzev() {
        this.zzHZ.zzaO();
    }

    @Override
    public void zzet() {
        this.zzuR.zzfd();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzh(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzm(int n) {
        zzji.zzds();
        return zzaix.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzm(rect.right - rect.left));
        jSONObject.put("height", this.zzm(rect.bottom - rect.top));
        jSONObject.put("x", this.zzm(rect.left));
        jSONObject.put("y", this.zzm(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzi(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzoc.zzh(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzm(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzm(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzm(nArray[0]));
            jSONObject3.put("y", this.zzm(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzm(nArray[0]));
                jSONObject2.put("y", this.zzm(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzafq.zzaT((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzj(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzbz();
            int n = zzagy.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzoc.zzh(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzoc.zzh(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzm(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzm(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzm(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzm(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzm(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzm(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzafq.zzaT((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzaeu zzew() {
        if (zzbs.zzbY().zzr(this.mContext)) {
            if (this.zzum == null) {
                this.zzum = new zzaeu(this.mContext, this.zzHZ.getAdUnitId());
            }
            return this.zzum;
        }
        return null;
    }
}

