/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzwk;
import com.google.android.gms.internal.zzwt;
import com.google.android.gms.internal.zzwu;
import com.google.android.gms.internal.zzzm;
import java.util.Map;
import java.util.Set;

@zzzm
public final class zzwj
extends zzwt {
    private static Set<String> zzNy = zzf.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzNz = "top-right";
    private boolean zzNA = true;
    private int zzNB = 0;
    private int zzNC = 0;
    private int zzrZ = -1;
    private int zzND = 0;
    private int zzNE = 0;
    private int zzrY = -1;
    private final Object mLock = new Object();
    private final zzajz zzJJ;
    private final Activity zzNo;
    private zziv zzvb;
    private ImageView zzNF;
    private LinearLayout zzNG;
    private zzwu zzNH;
    private PopupWindow zzNI;
    private RelativeLayout zzNJ;
    private ViewGroup zzNK;

    public zzwj(zzajz zzajz2, zzwu zzwu2) {
        super(zzajz2, "resize");
        this.zzJJ = zzajz2;
        this.zzNo = zzajz2.zzis();
        this.zzNH = zzwu2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzNo == null) {
                this.zzan("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzJJ.zzam() == null) {
                this.zzan("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzJJ.zzam().zzAv) {
                this.zzan("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzJJ.zziA()) {
                this.zzan("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwj zzwj2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbs.zzbz();
                zzwj2.zzrY = zzagy.zzaJ(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbs.zzbz();
                zzwj2.zzrZ = zzagy.zzaJ(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbs.zzbz();
                zzwj2.zzND = zzagy.zzaJ(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbs.zzbz();
                zzwj2.zzNE = zzagy.zzaJ(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwj2.zzNA = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwj2.zzNz = string2;
            }
            zzwj2 = this;
            if (!(zzwj2.zzrY >= 0 && zzwj2.zzrZ >= 0)) {
                this.zzan("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzNo.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzan("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzfB();
            if (nArray == null) {
                this.zzan("Resize location out of screen or close button is not visible.");
                return;
            }
            zzji.zzds();
            int n = zzaix.zzc((Context)this.zzNo, (int)this.zzrY);
            zzji.zzds();
            int n2 = zzaix.zzc((Context)this.zzNo, (int)this.zzrZ);
            ViewParent viewParent = this.zzJJ.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzJJ.getView());
                if (this.zzNI == null) {
                    this.zzNK = (ViewGroup)viewParent;
                    zzbs.zzbz();
                    bitmap = zzagy.zzl(this.zzJJ.getView());
                    this.zzNF = new ImageView((Context)this.zzNo);
                    this.zzNF.setImageBitmap(bitmap);
                    this.zzvb = this.zzJJ.zzam();
                    this.zzNK.addView((View)this.zzNF);
                } else {
                    this.zzNI.dismiss();
                }
            } else {
                this.zzan("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzNJ = new RelativeLayout((Context)this.zzNo);
            this.zzNJ.setBackgroundColor(0);
            this.zzNJ.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbs.zzbz();
            this.zzNI = zzagy.zza((View)this.zzNJ, n, n2, false);
            this.zzNI.setOutsideTouchable(true);
            this.zzNI.setTouchable(true);
            this.zzNI.setClippingEnabled(!this.zzNA);
            this.zzNJ.addView(this.zzJJ.getView(), -1, -1);
            this.zzNG = new LinearLayout((Context)this.zzNo);
            zzji.zzds();
            int n3 = zzaix.zzc((Context)this.zzNo, (int)50);
            zzji.zzds();
            bitmap = new RelativeLayout.LayoutParams(n3, zzaix.zzc((Context)this.zzNo, (int)50));
            switch (this.zzNz) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzNG.setOnClickListener((View.OnClickListener)new zzwk(this));
            this.zzNG.setContentDescription((CharSequence)"Close button");
            this.zzNJ.addView((View)this.zzNG, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzji.zzds();
                int n4 = zzaix.zzc((Context)this.zzNo, (int)nArray[0]);
                zzji.zzds();
                this.zzNI.showAtLocation(view, 0, n4, zzaix.zzc((Context)this.zzNo, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzan(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzNJ.removeView(this.zzJJ.getView());
                if (this.zzNK != null) {
                    this.zzNK.removeView((View)this.zzNF);
                    this.zzNK.addView(this.zzJJ.getView());
                    this.zzJJ.zza(this.zzvb);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwj2 = this;
            if (zzwj2.zzNH != null) {
                zzwj2.zzNH.zza(n6, n5, zzwj2.zzrY, zzwj2.zzrZ);
            }
            this.zzJJ.zza(new zziv((Context)this.zzNo, new AdSize(this.zzrY, this.zzrZ)));
            this.zza(nArray[0], nArray[1]);
            this.zzap("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzNI != null) {
                this.zzNI.dismiss();
                this.zzNJ.removeView(this.zzJJ.getView());
                if (this.zzNK != null) {
                    this.zzNK.removeView((View)this.zzNF);
                    this.zzNK.addView(this.zzJJ.getView());
                    this.zzJJ.zza(this.zzvb);
                }
                if (bl) {
                    this.zzap("default");
                    if (this.zzNH != null) {
                        this.zzNH.zzaN();
                    }
                }
                this.zzNI = null;
                this.zzNJ = null;
                this.zzNK = null;
                this.zzNG = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzfB() {
        zzwj zzwj2 = this;
        int[] nArray = zzbs.zzbz().zzg(zzwj2.zzNo);
        int[] nArray2 = zzbs.zzbz().zzh(zzwj2.zzNo);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwj2.zzrY < 50 || zzwj2.zzrY > n) {
            zzafq.zzaT((String)"Width is too small or too large.");
            return null;
        }
        if (zzwj2.zzrZ < 50 || zzwj2.zzrZ > n2) {
            zzafq.zzaT((String)"Height is too small or too large.");
            return null;
        }
        if (zzwj2.zzrZ == n2 && zzwj2.zzrY == n) {
            zzafq.zzaT((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwj2.zzNA) {
            int n3;
            int n4;
            switch (zzwj2.zzNz) {
                case "top-left": {
                    n4 = zzwj2.zzNB + zzwj2.zzND;
                    n3 = zzwj2.zzNC + zzwj2.zzNE;
                    break;
                }
                case "top-center": {
                    n4 = zzwj2.zzNB + zzwj2.zzND + zzwj2.zzrY / 2 - 25;
                    n3 = zzwj2.zzNC + zzwj2.zzNE;
                    break;
                }
                case "center": {
                    n4 = zzwj2.zzNB + zzwj2.zzND + zzwj2.zzrY / 2 - 25;
                    n3 = zzwj2.zzNC + zzwj2.zzNE + zzwj2.zzrZ / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwj2.zzNB + zzwj2.zzND;
                    n3 = zzwj2.zzNC + zzwj2.zzNE + zzwj2.zzrZ - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwj2.zzNB + zzwj2.zzND + zzwj2.zzrY / 2 - 25;
                    n3 = zzwj2.zzNC + zzwj2.zzNE + zzwj2.zzrZ - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwj2.zzNB + zzwj2.zzND + zzwj2.zzrY - 50;
                    n3 = zzwj2.zzNC + zzwj2.zzNE + zzwj2.zzrZ - 50;
                    break;
                }
                default: {
                    n4 = zzwj2.zzNB + zzwj2.zzND + zzwj2.zzrY - 50;
                    n3 = zzwj2.zzNC + zzwj2.zzNE;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzNA) {
            return new int[]{this.zzNB + this.zzND, this.zzNC + this.zzNE};
        }
        int[] nArray3 = zzbs.zzbz().zzg(this.zzNo);
        int[] nArray4 = zzbs.zzbz().zzh(this.zzNo);
        int n5 = nArray3[0];
        int n6 = this.zzNB + this.zzND;
        int n7 = this.zzNC + this.zzNE;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzrY > n5) {
            n6 = n5 - this.zzrY;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzrZ <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzrZ;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzNB = n;
            this.zzNC = n2;
            if (this.zzNI != null && bl) {
                int[] nArray = this.zzfB();
                if (nArray != null) {
                    zzji.zzds();
                    int n3 = zzaix.zzc((Context)this.zzNo, (int)nArray[0]);
                    zzji.zzds();
                    this.zzNI.update(n3, zzaix.zzc((Context)this.zzNo, (int)nArray[1]), this.zzNI.getWidth(), this.zzNI.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzk(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbs.zzbz().zzh(this.zzNo)[0];
        this.zzb(n, n2 - n3, this.zzrY, this.zzrZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzfC() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzNI != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzNB = n;
        this.zzNC = n2;
    }
}

