/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzzi;
import com.google.android.gms.internal.zzzj;
import com.google.android.gms.internal.zzzk;
import com.google.android.gms.internal.zzzl;
import com.google.android.gms.internal.zzzm;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.WeakHashMap;

@zzzm
public final class zzzh
implements zzzk {
    private static final Object zzuH = new Object();
    private static zzzk zzSg = null;
    private final Object zzSh = new Object();
    private final String mPackageName;
    private final zzajd zzuM;
    private final WeakHashMap<Thread, Boolean> zzSi = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzzk zzc(Context context, zzajd zzajd2) {
        Object object = zzuH;
        synchronized (object) {
            if (zzSg == null) {
                zzme<Boolean> zzme2 = zzmo.zzCe;
                if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
                    String string = "unknown";
                    try {
                        string = context.getApplicationContext().getPackageName();
                    }
                    catch (Throwable throwable) {
                        zzafq.zzaT((String)"Cannot obtain package name, proceeding.");
                    }
                    zzSg = new zzzh(string, zzajd2);
                } else {
                    zzSg = new zzzl();
                }
            }
        }
        return zzSg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzzh(String string, zzajd zzajd2) {
        this.mPackageName = string;
        this.zzuM = zzajd2;
        Thread thread = Looper.getMainLooper().getThread();
        zzzh zzzh2 = this;
        if (thread != null) {
            Object object = zzzh2.zzSh;
            synchronized (object) {
                zzzh2.zzSi.put(thread, true);
            }
            object = thread.getUncaughtExceptionHandler();
            thread.setUncaughtExceptionHandler(new zzzj(zzzh2, (Thread.UncaughtExceptionHandler)object));
        }
        zzzh zzzh3 = this;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new zzzi(zzzh3, uncaughtExceptionHandler));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzzh zzzh2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzzh.zzat(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzzh2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        this.zza(throwable2, "");
    }

    private static boolean zzat(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzme<String> zzme2 = zzmo.zzCg;
        if (string.startsWith(zzbs.zzbL().zzd(zzme2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzzm.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzafq.zza((String)(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        Throwable throwable2;
        Object object;
        Object object2;
        Serializable serializable;
        Throwable throwable3;
        Serializable serializable2 = throwable;
        Object object3 = zzmo.zzCf;
        if (zzbs.zzbL().zzd(object3).booleanValue()) {
            throwable3 = serializable2;
        } else {
            serializable = new LinkedList<Throwable>();
            for (object2 = serializable2; object2 != null; object2 = ((Throwable)object2).getCause()) {
                ((LinkedList)serializable).push(object2);
            }
            object = null;
            while (!((AbstractCollection)((Object)serializable)).isEmpty()) {
                object2 = (Throwable)((LinkedList)serializable).pop();
                StackTraceElement[] stackTraceElementArray = ((Throwable)object2).getStackTrace();
                ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
                arrayList.add(new StackTraceElement(object2.getClass().getName(), "<filtered>", "<filtered>", 1));
                boolean bl = false;
                StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                    if (zzzh.zzat(stackTraceElement.getClassName())) {
                        bl = true;
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    object3 = stackTraceElement.getClassName();
                    if (!TextUtils.isEmpty((CharSequence)object3) && (((String)object3).startsWith("android.") || ((String)object3).startsWith("java."))) {
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                    arrayList.add(stackTraceElement2);
                }
                if (!bl) continue;
                object = object == null ? new Throwable(((Throwable)object2).getMessage()) : new Throwable(((Throwable)object2).getMessage(), (Throwable)object);
                ((Throwable)object).setStackTrace(arrayList.toArray(new StackTraceElement[0]));
            }
            throwable3 = throwable2 = object;
        }
        if (throwable3 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        object2 = string;
        serializable = throwable2;
        serializable2 = clazz;
        zzzh zzzh2 = this;
        object = new StringWriter();
        ((Throwable)serializable).printStackTrace(new PrintWriter((Writer)object));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT));
        zzbs.zzbz();
        arrayList.add(builder.appendQueryParameter("device", zzagy.zzhQ()).appendQueryParameter("js", zzzh2.zzuM.zzaR).appendQueryParameter("appid", zzzh2.mPackageName).appendQueryParameter("exceptiontype", ((Class)serializable2).getName()).appendQueryParameter("stacktrace", ((StringWriter)object).toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzmo.zzdJ())).appendQueryParameter("exceptionkey", (String)object2).appendQueryParameter("cl", "158551207").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzbs.zzbD().getSessionId()).toString());
        zzbs.zzbz();
        zzagy.zza(arrayList, zzbs.zzbD().zzht());
    }
}

