/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzap;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzar;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzzt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzt
@TargetApi(value=14)
public final class zzd
extends zzy
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzcfd = new HashMap<Integer, String>();
    private final zzar zzcfe;
    private final boolean zzcff;
    private int zzcfg = 0;
    private int zzcfh = 0;
    private MediaPlayer zzcfi;
    private Uri zzcfj;
    private int zzcfk;
    private int zzcfl;
    private int zzcfm;
    private int zzcfn;
    private int zzcfo;
    private zzap zzcfp;
    private boolean zzcfq;
    private int zzcfr;
    private zzx zzcfs;

    public zzd(Context context, boolean bl, boolean bl2, zzaq zzaq2, zzar zzar2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzcfe = zzar2;
        this.zzcfq = bl;
        this.zzcff = bl2;
        this.zzcfe.zza(this);
    }

    @Override
    public final String zzmg() {
        String string = String.valueOf(this.zzcfq ? " spherical" : "");
        if (string.length() != 0) {
            return "MediaPlayer".concat(string);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzx zzx2) {
        this.zzcfs = zzx2;
    }

    @Override
    public final void setVideoPath(String string) {
        Uri uri = Uri.parse((String)string);
        zzd zzd2 = this;
        zzie zzie2 = zzie.zze(uri);
        zzd2.zzcfj = zzie2 == null ? uri : Uri.parse((String)zzie2.url);
        zzd2.zzcfr = 0;
        zzd2.zzmh();
        zzd2.requestLayout();
        zzd2.invalidate();
    }

    @Override
    public final void stop() {
        zzafx.v("AdMediaPlayerView stop");
        if (this.zzcfi != null) {
            this.zzcfi.stop();
            this.zzcfi.release();
            this.zzcfi = null;
            this.zzv(0);
            this.zzcfh = 0;
        }
        this.zzcfe.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzafx.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzcfk = mediaPlayer.getVideoWidth();
        this.zzcfl = mediaPlayer.getVideoHeight();
        if (this.zzcfk != 0 && this.zzcfl != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzafx.v("AdMediaPlayerView prepared");
        this.zzv(2);
        this.zzcfe.zzmw();
        zzahf.zzdbo.post((Runnable)new zze(this));
        this.zzcfk = mediaPlayer.getVideoWidth();
        this.zzcfl = mediaPlayer.getVideoHeight();
        if (this.zzcfr != 0) {
            ((zzy)this).seekTo(this.zzcfr);
        }
        this.zzmi();
        int n = this.zzcfk;
        int n2 = this.zzcfl;
        zzafx.zzcr((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzcfh == 3) {
            ((zzy)this).play();
        }
        ((zzy)this).zzmk();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzafx.v("AdMediaPlayerView completion");
        this.zzv(5);
        this.zzcfh = 5;
        zzahf.zzdbo.post((Runnable)new zzf(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcfd.get(n);
        String string2 = zzcfd.get(n2);
        zzafx.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcfd.get(n);
        String string2 = zzcfd.get(n2);
        zzafx.zzcs((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzv(-1);
        this.zzcfh = -1;
        zzahf.zzdbo.post((Runnable)new zzg(this, string, string2));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzcfm = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzafx.v("AdMediaPlayerView surface created");
        this.zzmh();
        zzahf.zzdbo.post((Runnable)new zzh(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzafx.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzcfh == 3;
        boolean bl3 = bl = this.zzcfk == n && this.zzcfl == n2;
        if (this.zzcfi != null && bl2 && bl) {
            if (this.zzcfr != 0) {
                ((zzy)this).seekTo(this.zzcfr);
            }
            ((zzy)this).play();
        }
        if (this.zzcfp != null) {
            this.zzcfp.zzf(n, n2);
        }
        zzahf.zzdbo.post((Runnable)new zzi(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzafx.v("AdMediaPlayerView surface destroyed");
        if (this.zzcfi != null && this.zzcfr == 0) {
            this.zzcfr = this.zzcfi.getCurrentPosition();
        }
        if (this.zzcfp != null) {
            this.zzcfp.zzni();
        }
        zzahf.zzdbo.post((Runnable)new zzj(this));
        this.zzr(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzcfe.zzb(this);
        this.zzchi.zza(surfaceTexture, this.zzcfs);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzcfk, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzcfl, (int)n2);
        if (this.zzcfk > 0 && this.zzcfl > 0 && this.zzcfp == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzcfk * n4 < n3 * this.zzcfl) {
                    n3 = n4 * this.zzcfk / this.zzcfl;
                } else if (this.zzcfk * n4 > n3 * this.zzcfl) {
                    n4 = n3 * this.zzcfl / this.zzcfk;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzcfl / this.zzcfk;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzcfk / this.zzcfl;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzcfk;
                n4 = this.zzcfl;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzcfk / this.zzcfl;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzcfl / this.zzcfk;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzcfp != null) {
            this.zzcfp.zzf(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzcfn > 0 && this.zzcfn != n3 || this.zzcfo > 0 && this.zzcfo != n4) {
                this.zzmi();
            }
            this.zzcfn = n3;
            this.zzcfo = n4;
        }
    }

    public final String toString() {
        String string = this.getClass().getName();
        String string2 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private final void zzmh() {
        zzafx.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzcfj == null || surfaceTexture == null) {
            return;
        }
        this.zzr(false);
        try {
            Surface surface;
            zzbv.zzes();
            this.zzcfi = new MediaPlayer();
            this.zzcfi.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzcfi.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzcfi.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzcfi.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzcfi.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzcfi.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzcfm = 0;
            if (this.zzcfq) {
                this.zzcfp = new zzap(this.getContext());
                this.zzcfp.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzcfp.start();
                surface = this.zzcfp.zznj();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzcfp.zzni();
                    this.zzcfp = null;
                }
            }
            this.zzcfi.setDataSource(this.getContext(), this.zzcfj);
            zzbv.zzet();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzcfi.setSurface(surface);
            this.zzcfi.setAudioStreamType(3);
            this.zzcfi.setScreenOnWhilePlaying(true);
            this.zzcfi.prepareAsync();
            this.zzv(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzcfj);
            zzafx.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzcfi, 1, 0);
            return;
        }
    }

    private final void zzmi() {
        if (!this.zzcff) {
            return;
        }
        if (this.zzmj() && this.zzcfi.getCurrentPosition() > 0 && this.zzcfh != 3) {
            zzafx.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzcfi.start();
            int n = this.zzcfi.getCurrentPosition();
            long l = zzbv.zzeg().currentTimeMillis();
            while (this.zzmj() && this.zzcfi.getCurrentPosition() == n && zzbv.zzeg().currentTimeMillis() - l <= 250L) {
            }
            this.zzcfi.pause();
            ((zzy)this).zzmk();
        }
    }

    private final void zzr(boolean bl) {
        zzafx.v("AdMediaPlayerView release");
        if (this.zzcfp != null) {
            this.zzcfp.zzni();
            this.zzcfp = null;
        }
        if (this.zzcfi != null) {
            this.zzcfi.reset();
            this.zzcfi.release();
            this.zzcfi = null;
            this.zzv(0);
            if (bl) {
                this.zzcfh = 0;
                this.zzcfh = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzafx.v("AdMediaPlayerView play");
        if (this.zzmj()) {
            this.zzcfi.start();
            this.zzv(3);
            this.zzchi.zzmx();
            zzahf.zzdbo.post((Runnable)new zzk(this));
        }
        this.zzcfh = 3;
    }

    @Override
    public final void pause() {
        zzafx.v("AdMediaPlayerView pause");
        if (this.zzmj() && this.zzcfi.isPlaying()) {
            this.zzcfi.pause();
            this.zzv(4);
            zzahf.zzdbo.post((Runnable)new zzl(this));
        }
        this.zzcfh = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzmj()) {
            return this.zzcfi.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzmj()) {
            return this.zzcfi.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzafx.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzmj()) {
            this.zzcfi.seekTo(n);
            this.zzcfr = 0;
            return;
        }
        this.zzcfr = n;
    }

    private final boolean zzmj() {
        return this.zzcfi != null && this.zzcfg != -1 && this.zzcfg != 0 && this.zzcfg != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzcfp != null) {
            this.zzcfp.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzcfi != null) {
            return this.zzcfi.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzcfi != null) {
            return this.zzcfi.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzmk() {
        this.zza(this.zzchj.zznp());
    }

    private final void zza(float f) {
        if (this.zzcfi != null) {
            try {
                this.zzcfi.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzafx.zzcs((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzv(int n) {
        if (n == 3) {
            this.zzcfe.zznm();
            this.zzchj.zznm();
        } else if (this.zzcfg == 3) {
            this.zzcfe.zznn();
            this.zzchj.zznn();
        }
        this.zzcfg = n;
    }

    static /* synthetic */ zzx zza(zzd zzd2) {
        return zzd2.zzcfs;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzcfd.put(-1004, "MEDIA_ERROR_IO");
            zzcfd.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzcfd.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzcfd.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzcfd.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzcfd.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzcfd.put(1, "MEDIA_ERROR_UNKNOWN");
        zzcfd.put(1, "MEDIA_INFO_UNKNOWN");
        zzcfd.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzcfd.put(701, "MEDIA_INFO_BUFFERING_START");
        zzcfd.put(702, "MEDIA_INFO_BUFFERING_END");
        zzcfd.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzcfd.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzcfd.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzcfd.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzcfd.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

