/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.internal.zzabb;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzzt;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzzt
public final class zzaba
extends zza {
    public static final Parcelable.Creator<zzaba> CREATOR = new zzabc();
    private ParcelFileDescriptor zzcqp;
    private Parcelable zzcqq;
    private boolean zzcqr;

    zzaba(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcqp = parcelFileDescriptor;
        this.zzcqq = null;
        this.zzcqr = true;
    }

    public zzaba(SafeParcelable safeParcelable) {
        this.zzcqp = null;
        this.zzcqq = safeParcelable;
        this.zzcqr = false;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcqr) {
            byte[] byArray;
            if (this.zzcqp == null) {
                zzafx.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcqp));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzm.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcqq = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcqr = false;
        }
        return (T)((SafeParcelable)this.zzcqq);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        if (this.zzcqp == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzcqq.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzcqp = this.zze(byArray);
        }
        Parcel parcel3 = parcel;
        zzaba zzaba2 = this;
        int n2 = zzd.zze((Parcel)parcel3);
        zzd.zza((Parcel)parcel3, (int)2, (Parcelable)zzaba2.zzcqp, (int)n, (boolean)false);
        zzd.zzai((Parcel)parcel3, (int)n2);
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzabb zzabb2 = new zzabb(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzabb2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzafx.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbv.zzee().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzm.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

