/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzzt;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzzt
@TargetApi(value=14)
public final class zzgi
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzawo;
    private final Context mApplicationContext;
    private Application zzawp;
    private final WindowManager zzavh;
    private final PowerManager zzavi;
    private final KeyguardManager zzavj;
    @Nullable
    private BroadcastReceiver zzavr;
    private WeakReference<ViewTreeObserver> zzawq;
    private WeakReference<View> zzawr;
    private zzgn zzaws;
    private zzaix zzaun = new zzaix(zzawo);
    private boolean zzavq = false;
    private int zzawt = -1;
    private HashSet<zzgm> zzawu = new HashSet();
    private DisplayMetrics zzawv;

    public zzgi(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzavh = (WindowManager)context.getSystemService("window");
        this.zzavi = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzavj = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzawp = (Application)this.mApplicationContext;
            this.zzaws = new zzgn((Application)this.mApplicationContext, this);
        }
        this.zzawv = context.getResources().getDisplayMetrics();
        View view2 = view;
        zzgi zzgi2 = this;
        View view3 = zzgi2.zzawr != null ? (View)zzgi2.zzawr.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgi2);
            zzgi2.zze(view3);
        }
        zzgi2.zzawr = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbv.zzec().isAttachedToWindow(view2)) {
                zzgi2.zzd(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgi2);
        }
    }

    public final void zza(zzgm zzgm2) {
        this.zzawu.add(zzgm2);
        this.zzk(3);
    }

    public final void zzb(zzgm zzgm2) {
        this.zzawu.remove(zzgm2);
    }

    private final void zzgb() {
        zzbv.zzea();
        zzahf.zzdbo.post((Runnable)new zzgj(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzawt = -1;
        this.zzd(view);
        this.zzk(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzawt = -1;
        this.zzk(3);
        this.zzgb();
        this.zze(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzawr == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzawr.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzawt = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onGlobalLayout() {
        this.zzk(2);
        this.zzgb();
    }

    public final void onScrollChanged() {
        this.zzk(1);
    }

    public final void zzgc() {
        this.zzk(4);
    }

    private final void zzk(int n) {
        boolean bl;
        if (this.zzawu.size() == 0) {
            return;
        }
        if (this.zzawr == null) {
            return;
        }
        View view = (View)this.zzawr.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        new Rect().right = this.zzavh.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzavh.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzafx.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzawt != -1 ? this.zzawt : n2;
        boolean bl6 = bl = !bl3 && zzbv.zzea().zza(view, this.zzavi, this.zzavj) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzaun.tryAcquire() && bl == this.zzavq) {
            return;
        }
        if (!bl && !this.zzavq && n == 1) {
            return;
        }
        zzgl zzgl2 = new zzgl(zzbv.zzeg().elapsedRealtime(), this.zzavi.isScreenOn(), view != null ? zzbv.zzec().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzawv.density, bl);
        Iterator<zzgm> iterator = this.zzawu.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgl2);
        }
        this.zzavq = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzl(rect.left), this.zzl(rect.top), this.zzl(rect.right), this.zzl(rect.bottom));
    }

    private final int zzl(int n) {
        float f = this.zzawv.density;
        return (int)((float)n / f);
    }

    private final void zzd(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzawq = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzgi zzgi2 = this;
        if (zzgi2.zzavr == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzgi2.zzavr = new zzgk(zzgi2);
            zzgi2.mApplicationContext.registerReceiver(zzgi2.zzavr, intentFilter);
        }
        if (this.zzawp != null) {
            try {
                this.zzawp.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaws);
                return;
            }
            catch (Exception exception) {
                zzafx.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzawq != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzawq.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzawq = null;
            }
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzgi zzgi2 = this;
        if (zzgi2.zzavr != null) {
            try {
                zzgi2.mApplicationContext.unregisterReceiver(zzgi2.zzavr);
            }
            catch (IllegalStateException illegalStateException) {
                zzafx.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbv.zzee().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzgi2.zzavr = null;
        }
        if (this.zzawp != null) {
            try {
                this.zzawp.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaws);
                return;
            }
            catch (Exception exception) {
                zzafx.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzgi zzgi2, int n) {
        zzgi2.zzk(3);
    }

    static {
        zzmk<Long> zzmk2 = zzmu.zzbkt;
        zzawo = zzbv.zzen().zzd(zzmk2);
    }
}

