/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzaci;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzss;
import com.google.android.gms.internal.zztw;
import com.google.android.gms.internal.zztx;
import com.google.android.gms.internal.zzty;
import com.google.android.gms.internal.zztz;
import com.google.android.gms.internal.zzub;
import com.google.android.gms.internal.zzzt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzzt
public final class zztv {
    private final Map<zztw, zztx> zzbxh = new HashMap<zztw, zztx>();
    private final LinkedList<zztw> zzbxi = new LinkedList();
    @Nullable
    private zzss zzbxj;

    final void zza(zzss zzss2) {
        if (this.zzbxj == null) {
            this.zzbxj = zzss2.zzkh();
            zztv zztv2 = this;
            if (zztv2.zzbxj != null) {
                SharedPreferences sharedPreferences = zztv2.zzbxj.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zztv zztv3 = zztv2;
                while (zztv3.zzbxi.size() > 0) {
                    zztw zztw2 = zztv3.zzbxi.remove();
                    zztx zztx2 = zztv3.zzbxh.get(zztw2);
                    zztv.zza("Flushing interstitial queue for %s.", zztw2);
                    while (zztx2.size() > 0) {
                        zztx2.zzm(null).zzbxo.zzda();
                    }
                    zztv3.zzbxh.remove(zztw2);
                }
                try {
                    zztw zztw2;
                    HashMap<String, zztw> hashMap = new HashMap<String, zztw>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzub zzub2 = zzub.zzbb((String)stringArray.getValue());
                        zztw2 = new zztw(zzub2.zzari, zzub2.zzapb, zzub2.zzbxm);
                        if (zztv2.zzbxh.containsKey(zztw2)) continue;
                        zztx zztx2 = new zztx(zzub2.zzari, zzub2.zzapb, zzub2.zzbxm);
                        zztv2.zzbxh.put(zztw2, zztx2);
                        hashMap.put(zztw2.toString(), zztw2);
                        zztv.zza("Restored interstitial queue for %s.", zztw2);
                    }
                    for (String string2 : zztv.zzay(sharedPreferences.getString("PoolKeys", ""))) {
                        zztw2 = (zztw)hashMap.get(string2);
                        if (!zztv2.zzbxh.containsKey(zztw2)) continue;
                        zztv2.zzbxi.add(zztw2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbv.zzee().zza(exception, "InterstitialAdPool.restore");
                    zzafx.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zztv2.zzbxh.clear();
                    zztv2.zzbxi.clear();
                }
            }
        }
    }

    @Nullable
    final zzty zza(zzix zzix2, String string2) {
        Object object;
        Object object2;
        zzmk<Integer> zzmk2;
        String string3;
        if (zztv.zzaz(string2)) {
            return null;
        }
        Context context = this.zzbxj.getApplicationContext();
        int n = new zzaci((Context)context).zzop().zzcur;
        zzix zzix3 = zztv.zzk(zzix2);
        zztw zztw2 = new zztw(zzix3, string3 = zztv.zzba(string2), n);
        zztx zztx2 = this.zzbxh.get(zztw2);
        if (zztx2 == null) {
            zztv.zza("Interstitial pool created at %s.", zztw2);
            zztx2 = new zztx(zzix3, string3, n);
            this.zzbxh.put(zztw2, zztx2);
        }
        this.zzbxi.remove(zztw2);
        this.zzbxi.add(zztw2);
        zztx2.zzkn();
        while (true) {
            zzmk2 = zzmu.zzbke;
            if (this.zzbxi.size() <= zzbv.zzen().zzd(zzmk2)) break;
            object2 = this.zzbxi.remove();
            object = this.zzbxh.get(object2);
            zztv.zza("Evicting interstitial queue for %s.", (zztw)object2);
            while (((zztx)object).size() > 0) {
                zzty zzty2 = ((zztx)object).zzm(null);
                if (zzty2.zzbxs) {
                    zztz.zzkp().zzkr();
                }
                zzty2.zzbxo.zzda();
            }
            this.zzbxh.remove(object2);
        }
        while (zztx2.size() > 0) {
            object2 = zztx2.zzm(zzix3);
            if (((zzty)object2).zzbxs) {
                zzmk2 = zzmu.zzbkg;
                if (zzbv.zzeg().currentTimeMillis() - ((zzty)object2).zzbxr > 1000L * (long)zzbv.zzen().zzd(zzmk2).intValue()) {
                    zztv.zza("Expired interstitial at %s.", zztw2);
                    zztz.zzkp().zzkq();
                    continue;
                }
            }
            object = ((zzty)object2).zzbxp != null ? " (inline) " : " ";
            zztv.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zztw2);
            return object2;
        }
        return null;
    }

    final void zzb(zzix zzix2, String string2) {
        String string3;
        if (this.zzbxj == null) {
            return;
        }
        Context context = this.zzbxj.getApplicationContext();
        int n = new zzaci((Context)context).zzop().zzcur;
        zzix zzix3 = zztv.zzk(zzix2);
        zztw zztw2 = new zztw(zzix3, string3 = zztv.zzba(string2), n);
        zztx zztx2 = this.zzbxh.get(zztw2);
        if (zztx2 == null) {
            zztv.zza("Interstitial pool created at %s.", zztw2);
            zztx2 = new zztx(zzix3, string3, n);
            this.zzbxh.put(zztw2, zztx2);
        }
        zztx2.zza(this.zzbxj, zzix2);
        zztx2.zzkn();
        zztv.zza("Inline entry added to the queue at %s.", zztw2);
    }

    final void zzki() {
        Object object;
        if (this.zzbxj == null) {
            return;
        }
        for (Map.Entry<zztw, zztx> entry : this.zzbxh.entrySet()) {
            int n;
            zztw zztw2 = entry.getKey();
            zztx zztx2 = entry.getValue();
            if (zzafx.zzad((int)2)) {
                n = zztx2.size();
                int n2 = zztx2.zzkl();
                if (n2 < n) {
                    zzafx.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zztw2));
                }
            }
            n = 0 + zztx2.zzkm();
            while (true) {
                object = zzmu.zzbkf;
                if (zztx2.size() >= (Integer)zzbv.zzen().zzd(object)) break;
                zztv.zza("Pooling and loading one new interstitial for %s.", zztw2);
                if (!zztx2.zzb(this.zzbxj)) continue;
                ++n;
            }
            zztz.zzkp().zzs(n);
        }
        object = this;
        if (((zztv)object).zzbxj != null) {
            SharedPreferences.Editor editor = ((zztv)object).zzbxj.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zztw, zztx> entry : ((zztv)object).zzbxh.entrySet()) {
                zztw zztw3 = entry.getKey();
                zztx zztx3 = entry.getValue();
                if (!zztx3.zzko()) continue;
                String string2 = new zzub(zztx3).zzky();
                String string3 = zztw3.toString();
                editor.putString(string3, string2);
                zztv.zza("Saved interstitial queue for %s.", zztw3);
            }
            editor.putString("PoolKeys", super.zzkj());
            editor.apply();
        }
    }

    private final String zzkj() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbxi.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zztw)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzay(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzaz(String string2) {
        try {
            zzmk<String> zzmk2 = zzmu.zzbkh;
            return Pattern.matches(zzbv.zzen().zzd(zzmk2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbv.zzee().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzi(zzix zzix2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzix2.extras.keySet());
        Bundle bundle = zzix2.zzbbv.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzix zzj(zzix zzix2) {
        zzix zzix3 = zztv.zzl(zzix2);
        String string2 = "_skipMediation";
        zzix zzix4 = zzix3;
        Bundle bundle = zzix3.zzbbv.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzix4.extras.putBoolean(string2, true);
        return zzix3;
    }

    private static zzix zzk(zzix zzix2) {
        zzix zzix3 = zztv.zzl(zzix2);
        zzmk<String> zzmk2 = zzmu.zzbkd;
        for (String string2 : zzbv.zzen().zzd(zzmk2).split(",")) {
            zztv.zzc(zzix3.zzbbv, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zztv.zzc(zzix3.extras, string4);
        }
        return zzix3;
    }

    private static String zzba(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzix zzl(zzix zzix2) {
        Parcel parcel = Parcel.obtain();
        zzix2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzix zzix3 = (zzix)zzix.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzmk<Boolean> zzmk2 = zzmu.zzbjt;
        if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
            zzix.zzh((zzix)zzix3);
        }
        return zzix3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zztw zztw2) {
        if (zzafx.zzad((int)2)) {
            zzafx.v(String.format(string2, zztw2));
        }
    }
}

