/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzzp;
import com.google.android.gms.internal.zzzq;
import com.google.android.gms.internal.zzzr;
import com.google.android.gms.internal.zzzs;
import com.google.android.gms.internal.zzzt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.WeakHashMap;

@zzzt
public final class zzzo
implements zzzr {
    private static final Object zzaqm = new Object();
    private static zzzr zzcnd = null;
    private final Object zzcne = new Object();
    private final Context mContext;
    private final String mPackageName;
    private final zzajk zzaqr;
    private final WeakHashMap<Thread, Boolean> zzcnf = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzzr zzc(Context context, zzajk zzajk2) {
        Object object = zzaqm;
        synchronized (object) {
            if (zzcnd == null) {
                zzmk<Boolean> zzmk2 = zzmu.zzbga;
                if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                    String string = "unknown";
                    try {
                        string = context.getApplicationContext().getPackageName();
                    }
                    catch (Throwable throwable) {
                        zzafx.zzcs((String)"Cannot obtain package name, proceeding.");
                    }
                    zzcnd = new zzzo(context.getApplicationContext(), string, zzajk2);
                } else {
                    zzcnd = new zzzs();
                }
            }
        }
        return zzcnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzzo(Context context, String string, zzajk zzajk2) {
        this.mContext = context;
        this.mPackageName = string;
        this.zzaqr = zzajk2;
        Thread thread = Looper.getMainLooper().getThread();
        zzzo zzzo2 = this;
        if (thread != null) {
            Object object = zzzo2.zzcne;
            synchronized (object) {
                zzzo2.zzcnf.put(thread, true);
            }
            object = thread.getUncaughtExceptionHandler();
            thread.setUncaughtExceptionHandler(new zzzq(zzzo2, (Thread.UncaughtExceptionHandler)object));
        }
        zzzo zzzo3 = this;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new zzzp(zzzo3, uncaughtExceptionHandler));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzzo zzzo2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzzo.zzbs(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzzo2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        this.zza(throwable2, "");
    }

    private static boolean zzbs(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzmk<String> zzmk2 = zzmu.zzbgc;
        if (string.startsWith(zzbv.zzen().zzd(zzmk2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzzt.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzafx.zza((String)(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        Throwable throwable2;
        Throwable throwable3;
        Throwable throwable4 = throwable;
        Object object = zzmu.zzbgb;
        if (zzbv.zzen().zzd(object).booleanValue()) {
            throwable3 = throwable4;
        } else {
            Throwable throwable5;
            LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
            for (throwable5 = throwable4; throwable5 != null; throwable5 = throwable5.getCause()) {
                linkedList.push(throwable5);
            }
            Throwable throwable6 = null;
            while (!linkedList.isEmpty()) {
                throwable5 = (Throwable)linkedList.pop();
                StackTraceElement[] stackTraceElementArray = throwable5.getStackTrace();
                ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
                arrayList.add(new StackTraceElement(throwable5.getClass().getName(), "<filtered>", "<filtered>", 1));
                boolean bl = false;
                StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                    if (zzzo.zzbs(stackTraceElement.getClassName())) {
                        bl = true;
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    object = stackTraceElement.getClassName();
                    if (!TextUtils.isEmpty((CharSequence)object) && (((String)object).startsWith("android.") || ((String)object).startsWith("java."))) {
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                    arrayList.add(stackTraceElement2);
                }
                if (!bl) continue;
                throwable6 = throwable6 == null ? new Throwable(throwable5.getMessage()) : new Throwable(throwable5.getMessage(), throwable6);
                throwable6.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
            }
            throwable3 = throwable2 = throwable6;
        }
        if (throwable3 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zza(clazz, throwable2, string));
        zzbv.zzea();
        zzahf.zza(arrayList, zzbv.zzee().zzpv());
    }

    private final String zza(Class clazz, Throwable throwable, String string) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        boolean bl = false;
        try {
            bl = zzbdp.zzcs((Context)this.mContext).zzalq();
        }
        catch (Throwable throwable2) {
            zzafx.zzb((String)"Error fetching instant app info", (Throwable)throwable2);
        }
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT));
        zzbv.zzea();
        return builder.appendQueryParameter("device", zzahf.zzqv()).appendQueryParameter("js", this.zzaqr.zzcp).appendQueryParameter("appid", this.mPackageName).appendQueryParameter("exceptiontype", clazz.getName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzmu.zzil())).appendQueryParameter("exceptionkey", string).appendQueryParameter("cl", "164654066").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzbv.zzee().getSessionId()).toString();
    }
}

