/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.js.zzl;
import com.google.android.gms.ads.internal.zzay;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzbdv;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzehy;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zznr;
import com.google.android.gms.internal.zzzt;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
public final class zzahf {
    public static final Handler zzdbo = new zzafy(Looper.getMainLooper());
    private static AtomicReference<List<String>> zzdbp = new AtomicReference<Object>(null);
    private static AtomicReference<List<String>> zzdbq = new AtomicReference<Object>(null);
    private final Object mLock = new Object();
    private boolean zzdbr = true;
    private String zzbwh;
    private boolean zzdbs = false;
    private zzl zzbzz;

    public final void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        boolean bl2 = bl;
        String string2 = string;
        Context context2 = context;
        zzahf zzahf2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(bl2);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzahf2.zzs(context2, string2));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzag(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzafx.zzcs((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzafx.zzcs((String)String.format(string, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzafx.zzcs((String)String.format(string, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzafx.zzcs((String)String.format(string, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzafx.zzcs((String)String.format(string, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzafx.zzcs((String)String.format(string, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzafx.zzcs((String)String.format(string, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzafx.zzcs((String)String.format(string, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzc(Context context, String string, String string2) {
        return zzbdv.zzcs((Context)context).checkPermission(string2, string) == 0;
    }

    public static void zza(Context context, String string, List<String> list) {
        for (String string2 : list) {
            new zzaiw(context, string, string2).zzns();
        }
    }

    public static void zzd(Context context, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        zzahf.zza(context, string, arrayList);
    }

    public static void zza(List<String> list, String string) {
        for (String string2 : list) {
            new zzaiw(string2, string).zzns();
        }
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzehy.zzex((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzafx.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zznr.zzk(context)) {
            zzafx.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zznr zznr2 = new zznr();
        zzahg zzahg2 = new zzahg(this, list, zznr2, context);
        zznr2.zza(zzahg2);
        zznr2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzah(Context context) {
        if (this.zzdbs) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzahj(this, null), intentFilter);
        this.zzdbs = true;
        return true;
    }

    private static String zzqs() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzs(Context context, String string) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbwh != null) {
                return this.zzbwh;
            }
            if (string == null) {
                return zzahf.zzqs();
            }
            try {
                this.zzbwh = zzbv.zzec().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzbwh)) {
                zzjo.zzhu();
                if (!zzaje.zzrq()) {
                    this.zzbwh = null;
                    zzdbo.post((Runnable)new zzahh(this, context));
                    while (this.zzbwh == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzbwh = zzahf.zzqs();
                            String string2 = String.valueOf(this.zzbwh);
                            zzafx.zzcs((String)(string2.length() != 0 ? "Interrupted, use default user agent: ".concat(string2) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzbwh = zzahf.zzai(context);
                }
            }
            String string3 = String.valueOf(this.zzbwh);
            this.zzbwh = new StringBuilder(10 + String.valueOf(string3).length() + String.valueOf(string).length()).append(string3).append(" (Mobile; ").append(string).toString();
            try {
                if (zzbdv.zzcs((Context)context).zzalq()) {
                    this.zzbwh = String.valueOf(this.zzbwh).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbv.zzee().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzbwh = String.valueOf(this.zzbwh).concat(")");
            return this.zzbwh;
        }
    }

    protected static String zzai(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Exception exception) {
            return zzahf.zzqs();
        }
    }

    public static boolean zza(ClassLoader classLoader, Class<?> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(string, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String zzch(String string) {
        return Uri.parse((String)string).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzk(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string : map.keySet()) {
                this.zza(jSONObject, string, map.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            throw new JSONException(string.length() != 0 ? "Could not convert map to JSON: ".concat(string) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(Bundle bundle, JSONObject jSONObject) {
        try {
            return this.zzc(bundle);
        }
        catch (JSONException jSONException) {
            zzafx.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zzc(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zza(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzk(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzahf zzahf2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzahf2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string, (Object)this.zzk(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string != null ? string : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string, object);
    }

    public static Map<String, String> zzg(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : zzbv.zzec().zzh(uri)) {
            hashMap.put(string, uri.getQueryParameter(string));
        }
        return hashMap;
    }

    public static String zzqt() {
        return UUID.randomUUID().toString();
    }

    public static String zzqu() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string;
    }

    public static int zzci(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = String.valueOf(numberFormatException);
            zzafx.zzcs((String)new StringBuilder(22 + String.valueOf(string2).length()).append("Could not parse value:").append(string2).toString());
            return 0;
        }
    }

    public static String zzqv() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        if (string.startsWith(string2)) {
            return string;
        }
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
    }

    private static int[] zzqw() {
        return new int[]{0, 0};
    }

    public static int[] zzf(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzahf.zzqw();
    }

    public final int[] zzg(Activity activity) {
        int[] nArray = zzahf.zzf(activity);
        int[] nArray2 = new int[2];
        zzjo.zzhu();
        nArray2[0] = zzaje.zzd((Context)activity, (int)nArray[0]);
        zzjo.zzhu();
        nArray2[1] = zzaje.zzd((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzh(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzahf.zzqw();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzjo.zzhu();
        nArray4[0] = zzaje.zzd((Context)activity, (int)nArray3[0]);
        zzjo.zzhu();
        nArray4[1] = zzaje.zzd((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzcj(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public static void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzaj(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzmf zzak(Context context) {
        return new zzmf(context);
    }

    public static Bitmap zzl(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzal(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zzjb zzjb2) {
        zzmk<Boolean> zzmk2 = zzmu.zzbis;
        if (!zzbv.zzen().zzd(zzmk2).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzjb2.width);
            jSONObject2.put("height", zzjb2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzahf.zzal(context));
            if (!zzjb2.zzbcr) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafx.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static String zzb(zzakk zzakk2, String string) {
        zzakk zzakk3 = zzakk2;
        if (zzakk3 == null) {
            throw null;
        }
        return zzahf.zza(zzakk2.getContext(), zzakk2.zzsd(), string, (View)zzakk3);
    }

    private static String zza(Context context, zzcv zzcv2, String string, View view) {
        if (zzcv2 == null) {
            return string;
        }
        try {
            Uri uri = Uri.parse((String)string);
            if (zzcv2.zzd(uri)) {
                uri = zzcv2.zza(uri, context, view);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static boolean zzam(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        if (bl) {
            zzbv.zzea();
            bundle.putString("device", zzahf.zzqv());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzmu.zzil()));
        }
        zzjo.zzhu();
        zzaje.zza((Context)context, (String)string, (String)string2, (Bundle)bundle, (boolean)bl, (zzajh)new zzahi(this, context, string));
    }

    public final void zzb(Context context, String string, String string2, Bundle bundle, boolean bl) {
        zzmk<Boolean> zzmk2 = zzmu.zzbkx;
        if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
            this.zza(context, string, string2, bundle, bl);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzdbo.post(runnable);
    }

    public static void zzb(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzagz.zza(runnable);
    }

    public static Bitmap zzm(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzahf.zzo(view);
        if (bitmap == null) {
            bitmap = zzahf.zzn(view);
        }
        return bitmap;
    }

    private static Bitmap zzn(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzafx.zzcs((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzafx.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzo(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzafx.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzan(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            zzmk<Boolean> zzmk2 = zzmu.zzbmj;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    bitmap = zzahf.zzo(window.getDecorView().getRootView());
                }
            } else {
                bitmap = zzahf.zzn(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzafx.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zzb(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static float zzde() {
        zzbv.zzev();
        zzay zzay2 = zzay.zzdd();
        if (zzay2 != null && zzay2.zzdf()) {
            return zzay2.zzde();
        }
        return 1.0f;
    }

    public static boolean zzdg() {
        zzbv.zzev();
        zzay zzay2 = zzay.zzdd();
        if (zzay2 != null) {
            return zzay2.zzdg();
        }
        return false;
    }

    public static AudioManager zzao(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public static float zzap(Context context) {
        AudioManager audioManager = zzahf.zzao(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        if (n == 0) {
            return 0.0f;
        }
        return (float)n2 / (float)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzl zze(Context context, zzajk zzajk2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbzz == null) {
                zzmk<String> zzmk2 = zzmu.zzbfv;
                this.zzbzz = new zzl(context.getApplicationContext() != null ? context.getApplicationContext() : context, zzajk2, zzbv.zzen().zzd(zzmk2));
            }
            return this.zzbzz;
        }
    }

    public static int zzaq(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return this.zza(view, powerManager, keyguardManager);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean zza(View var1_1, PowerManager var2_2, KeyguardManager var3_3) {
        if (zzbv.zzea().zzdbr || !((var5_4 /* !! */  = var3_3) == null ? false : var5_4 /* !! */ .inKeyguardRestrictedInputMode())) ** GOTO lbl-1000
        var5_4 /* !! */  = zzmu.zzbku;
        if (((Boolean)zzbv.zzen().zzd(var5_4 /* !! */ )).booleanValue() && (var7_8 = (var9_6 = (var6_5 = var1_1).getRootView()) != null && (var10_7 = var9_6.getContext()) instanceof Activity != false ? (Activity)var10_7 : null) != null && (var8_9 = (var9_6 = var7_8.getWindow()) == null ? null : var9_6.getAttributes()) != null && (var8_9.flags & 524288) != 0) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var4_10 = false;
        }
        if (var1_1.getVisibility() == 0 && var1_1.isShown() && ((var5_4 /* !! */  = var2_2) == null || var5_4 /* !! */ .isScreenOn() != false) && var4_10) {
            var5_4 /* !! */  = zzmu.zzbks;
            if (!((Boolean)zzbv.zzen().zzd(var5_4 /* !! */ )).booleanValue() || var1_1.getLocalVisibleRect(new Rect()) || var1_1.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static int zzp(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzar(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzafx.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbv.zzee().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzqx() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            zzmk<Boolean> zzmk2 = zzmu.zzbha;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            zzmk2 = zzmu.zzbhb;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
            bundle.putInt("web_view_count", zzbv.zzee().zzqn());
        }
        catch (Exception exception) {
            zzafx.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    public static Uri zzb(String string, String string2, String string3) throws UnsupportedOperationException {
        int n = string.indexOf("&adurl");
        if (n == -1) {
            n = string.indexOf("?adurl");
        }
        if (n != -1) {
            return Uri.parse((String)(string.substring(0, n + 1) + string2 + "=" + string3 + "&" + string.substring(n + 1)));
        }
        return Uri.parse((String)string).buildUpon().appendQueryParameter(string2, string3).build();
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzmk<Boolean> zzmk2 = zzmu.zzbot;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                zzahf.zzc(context, intent);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string = uri.toString();
            zzafx.zzcb((String)new StringBuilder(26 + String.valueOf(string).length()).append("Opening ").append(string).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafx.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzc(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (zzp.zzalg()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zze(Context context, String string, String string2) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string, 0);
            fileOutputStream.write(string2.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzt(Context context, String string) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string);
            return new String(zzm.zza((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzafx.zzcb((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zzjo.zzhu();
        int n = zzaje.zzc((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzaje.zzc((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzahf.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zzmk<Integer> zzmk2 = zzmu.zzbpd;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * zzbv.zzen().zzd(zzmk2);
        return zzahf.zzb(n3, n + n5, n7) && zzahf.zzb(n4, n2, n7);
    }

    public static boolean zzck(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (zzdbp.get() == null) {
            try {
                zzmk<String> zzmk2 = zzmu.zzbiy;
                JSONArray jSONArray = new JSONArray(zzbv.zzen().zzd(zzmk2));
                ArrayList<String> object = new ArrayList<String>(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object.add(jSONArray.getString(i));
                }
                zzdbp.compareAndSet(null, object);
            }
            catch (JSONException jSONException) {
                zzafx.zzcs((String)"Could not parse click ping schema");
                return false;
            }
        }
        for (String string2 : zzdbp.get()) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean zzcl(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (zzdbq.get() == null) {
            try {
                zzmk<String> zzmk2 = zzmu.zzbiz;
                JSONArray jSONArray = new JSONArray(zzbv.zzen().zzd(zzmk2));
                ArrayList<String> object = new ArrayList<String>(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object.add(jSONArray.getString(i));
                }
                zzdbq.compareAndSet(null, object);
            }
            catch (JSONException jSONException) {
                zzafx.zzcs((String)"Could not parse impression ping schema");
                return false;
            }
        }
        for (String string2 : zzdbq.get()) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    public static Bundle zza(zzhd zzhd2) {
        String string;
        String string2;
        if (zzhd2 == null) {
            return null;
        }
        zzmk<Boolean> zzmk2 = zzmu.zzbia;
        if (!zzbv.zzen().zzd(zzmk2).booleanValue()) {
            zzmk2 = zzmu.zzbic;
            if (!zzbv.zzen().zzd(zzmk2).booleanValue()) {
                return null;
            }
        }
        if (zzbv.zzee().zzpp() && zzbv.zzee().zzpq()) {
            return null;
        }
        if (zzhd2.zzgr()) {
            zzhd2.wakeup();
        }
        zzgx zzgx2 = zzhd2.zzgp();
        String string3 = null;
        if (zzgx2 != null) {
            string2 = zzgx2.zzge();
            string3 = zzgx2.zzgf();
            string = zzgx2.zzgg();
            if (string2 != null) {
                zzbv.zzee().zzce(string2);
            }
            if (string != null) {
                zzbv.zzee().zzcf(string);
            }
        } else {
            string2 = zzbv.zzee().zzpw();
            string = zzbv.zzee().zzpx();
        }
        Bundle bundle = new Bundle(1);
        if (string != null) {
            zzmk2 = zzmu.zzbic;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && !zzbv.zzee().zzpq()) {
                bundle.putString("v_fp_vertical", string);
            }
        }
        if (string2 != null) {
            zzmk2 = zzmu.zzbia;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && !zzbv.zzee().zzpp()) {
                bundle.putString("fingerprint", string2);
                if (!string2.equals(string3)) {
                    bundle.putString("v_fp", string3);
                }
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    public static int zzas(Context context) {
        return DynamiteModule.zzaf((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zzat(Context context) {
        return DynamiteModule.zzae((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    static /* synthetic */ boolean zza(zzahf zzahf2, boolean bl) {
        zzahf2.zzdbr = bl;
        return zzahf2.zzdbr;
    }

    static /* synthetic */ Object zza(zzahf zzahf2) {
        return zzahf2.mLock;
    }

    static /* synthetic */ String zza(zzahf zzahf2, String string) {
        zzahf2.zzbwh = string;
        return zzahf2.zzbwh;
    }
}

