/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzbvv;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzegz;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdc {
    private static final String TAG = zzdc.class.getSimpleName();
    protected Context zzaie;
    private Context zzaif;
    private ExecutorService zzaig;
    private DexClassLoader zzaih;
    private zzcx zzaii;
    private byte[] zzaij;
    private volatile AdvertisingIdClient zzaik = null;
    private volatile boolean zzahl = false;
    private Future zzail = null;
    private volatile zzax zzaim = null;
    private Future zzain = null;
    private zzco zzaio;
    protected boolean zzaip = false;
    private static Object zzaiq = new Object();
    private boolean zzair = false;
    private static zze zzais = null;
    private Map<Pair<String, String>, zzeb> zzait;
    private boolean zzaiu = false;

    public static zzdc zza(Context context, String string2, String string3, boolean bl) {
        zzdc zzdc2 = new zzdc(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdc zzdc3 = zzdc2;
            zzdc2.zzaig = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzdc3;
            zzdc3.zzahl = bl3;
            if (bl3) {
                ((zzdc)object).zzail = ((zzdc)object).zzaig.submit(new zzdd((zzdc)object));
            }
            zzdc zzdc4 = zzdc3;
            zzdc4.zzaig.execute(new zzdf(zzdc4));
            try {
                zzais = zze.zzaew();
                zzdc4.zzaip = zze.zzbx((Context)zzdc4.zzaie) > 0;
                zzdc4.zzair = zzais.isGooglePlayServicesAvailable(zzdc4.zzaie) == 0;
            }
            catch (Throwable throwable) {}
            zzdc3.zza(0, true);
            if (zzdh.zzaq()) {
                object = zzmu.zzbmb;
                if (((Boolean)com.google.android.gms.ads.internal.zzbv.zzen().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzdc4 = zzdc3;
            zzdc3.zzaii = new zzcx(null);
            try {
                zzdc4.zzaij = zzdc4.zzaii.zzl(string6);
            }
            catch (zzcy zzcy2) {
                throw new zzcz(zzcy2);
            }
            string6 = string4;
            zzdc4 = zzdc3;
            try {
                String string7;
                File file = zzdc4.zzaie.getCacheDir();
                if (file == null && (file = zzdc4.zzaie.getDir("dex", 0)) == null) {
                    throw new zzcz();
                }
                String string8 = string7 = "1493867303508";
                File file2 = file;
                String string9 = string6;
                zzdc zzdc5 = zzdc4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzdc5.zzaii.zzb(zzdc5.zzaij, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdc4.zzb(file, string7);
                try {
                    zzdc4.zzaih = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdc4.zzaie.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdc.zza(file4);
                    zzdc4.zza(file, string7);
                    zzdc.zzm(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzdc.zza(file4);
                zzdc4.zza(file, string7);
                zzdc.zzm(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcz(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcz(iOException);
            }
            catch (zzcy zzcy3) {
                throw new zzcz(zzcy3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcz(nullPointerException);
            }
            zzdc3.zzaio = new zzco(zzdc3);
            zzdc3.zzaiu = true;
        }
        catch (zzcz zzcz2) {}
        return zzdc2;
    }

    public final Context getContext() {
        return this.zzaie;
    }

    public final boolean isInitialized() {
        return this.zzaiu;
    }

    public final Context getApplicationContext() {
        return this.zzaif;
    }

    public final ExecutorService zzad() {
        return this.zzaig;
    }

    public final DexClassLoader zzae() {
        return this.zzaih;
    }

    public final zzcx zzaf() {
        return this.zzaii;
    }

    public final byte[] zzag() {
        return this.zzaij;
    }

    public final boolean zzah() {
        return this.zzaip;
    }

    public final zzco zzai() {
        return this.zzaio;
    }

    public final boolean zzaj() {
        return this.zzair;
    }

    public final zzax zzak() {
        return this.zzaim;
    }

    public final Future zzal() {
        return this.zzain;
    }

    private zzdc(Context context) {
        this.zzaie = context;
        this.zzaif = context.getApplicationContext();
        this.zzait = new HashMap<Pair<String, String>, zzeb>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdc.zza(file2);
            return;
        }
        zzbc zzbc2 = new zzbc();
        new zzbc().zzgg = Build.VERSION.SDK.getBytes();
        zzbc2.zzgf = string2.getBytes();
        byte[] byArray2 = this.zzaii.zzc(this.zzaij, byArray).getBytes();
        zzbc2.data = byArray2;
        zzbc2.zzge = zzbv.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzegz.zzc((zzegz)zzbc2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdc.zza(file2);
        return;
        catch (zzcy | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdc.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdc.zza(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdc.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbc zzbc2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdc.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdc.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbc2 = (zzbc)zzegz.zza((zzegz)new zzbc(), (byte[])byArray2);
                if (string2.equals(new String(zzbc2.zzgf)) && Arrays.equals(zzbc2.zzge, zzbv.zzb(zzbc2.data)) && Arrays.equals(zzbc2.zzgg, Build.VERSION.SDK.getBytes())) break block30;
                zzdc.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzaii.zzb(this.zzaij, new String(zzbc2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcy | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzait.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzait.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzeb(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzeb zzeb2 = this.zzait.get(new Pair((Object)string2, (Object)string3));
        if (zzeb2 == null) {
            return null;
        }
        return zzeb2.zzaw();
    }

    private final void zzam() {
        try {
            if (this.zzaik == null && this.zzaif != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaif);
                advertisingIdClient.start();
                this.zzaik = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaik = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzair) {
            return;
        }
        Future<?> future = this.zzaig.submit(new zzde(this, n, bl));
        if (n == 0) {
            this.zzain = future;
        }
    }

    @VisibleForTesting
    final zzax zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzan();
    }

    private static boolean zza(int n, zzax zzax2) {
        if (n < 4) {
            if (zzax2 == null) {
                return true;
            }
            zzmk<Boolean> zzmk2 = zzmu.zzbme;
            if (com.google.android.gms.ads.internal.zzbv.zzen().zzd(zzmk2).booleanValue() && (zzax2.zzct == null || zzax2.zzct.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzmk2 = zzmu.zzbmf;
            if (com.google.android.gms.ads.internal.zzbv.zzen().zzd(zzmk2).booleanValue() && (zzax2.zzez == null || zzax2.zzez.zzfx == null || zzax2.zzez.zzfx == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzax zzan() {
        zzax zzax2 = null;
        try {
            PackageInfo packageInfo = this.zzaie.getPackageManager().getPackageInfo(this.zzaie.getPackageName(), 0);
            zzax2 = zzbvv.zzn((Context)this.zzaie, (String)this.zzaie.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzax2;
    }

    public final AdvertisingIdClient zzao() {
        if (!this.zzahl) {
            return null;
        }
        if (this.zzaik != null) {
            return this.zzaik;
        }
        if (this.zzail != null) {
            try {
                this.zzail.get(2000L, TimeUnit.MILLISECONDS);
                this.zzail = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzail.cancel(true);
            }
        }
        return this.zzaik;
    }

    public final int zzz() {
        int n = Integer.MIN_VALUE;
        if (this.zzaio != null) {
            n = zzco.zzz();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdc zzdc2) {
        zzdc2.zzam();
    }

    static /* synthetic */ zzax zza(zzdc zzdc2, zzax zzax2) {
        zzdc2.zzaim = zzax2;
        return zzdc2.zzaim;
    }

    static /* synthetic */ boolean zzb(int n, zzax zzax2) {
        return zzdc.zza(n, zzax2);
    }
}

