/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzrt;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzzt;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
public final class zzro
implements zzrn {
    private final Context mContext;
    private final zzajk zzapc;

    public zzro(Context context, zzajk zzajk2) {
        this.mContext = context;
        this.zzapc = zzajk2;
    }

    private static zzrs zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzafx.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zzrr> arrayList = new ArrayList<zzrr>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zzrr(string5, string6));
        }
        return new zzrs(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzru zzru2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzru2.zzka());
            if (zzru2.getBody() != null) {
                jSONObject.put("body", (Object)zzru2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zzrr zzrr2 : zzru2.zzkf()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zzrr2.getKey()).put("value", (Object)zzrr2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzru2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzafx.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzrt zza(zzrs zzrs2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            Object object3;
            httpURLConnection = (HttpURLConnection)zzrs2.zzkb().openConnection();
            zzbv.zzea().zza(this.mContext, this.zzapc.zzcp, false, httpURLConnection);
            ArrayList<zzrr> arrayList = zzrs2.zzkc();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzrr zzrr2 = arrayList.get(i);
                object3 = zzrr2;
                httpURLConnection.addRequestProperty(((zzrr)object3).getKey(), ((zzrr)object3).getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzrs2.zzkd())) {
                httpURLConnection.setDoOutput(true);
                object2 = zzrs2.zzkd().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object2).length);
                object3 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object3).write((byte[])object2);
                ((FilterOutputStream)object3).close();
            }
            object2 = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry object4 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : (List)object4.getValue()) {
                        ((ArrayList)object2).add(new zzrr((String)object4.getKey(), string2));
                    }
                }
            }
            String string3 = zzrs2.zzka();
            int n2 = httpURLConnection.getResponseCode();
            zzbv.zzea();
            object3 = new zzru(string3, n2, (List<zzrr>)object2, zzahf.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            zzrt zzrt2 = new zzrt(this, true, (zzru)object3, null);
            return zzrt2;
        }
        catch (Exception exception) {
            zzrt zzrt2 = new zzrt(this, false, null, exception.toString());
            return zzrt2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public final JSONObject zzar(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzafx.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzrs zzrs2 = zzro.zzc(jSONObject);
            zzrt zzrt2 = this.zza(zzrs2);
            if (zzrt2.isSuccess()) {
                JSONObject jSONObject3 = zzro.zza(zzrt2.zzke());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzrt2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject2;
    }

    @Override
    public final void zza(zzakk zzakk2, Map<String, String> map) {
        zzagz.zza(new zzrp(this, map, zzakk2));
    }
}

