/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzaci;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zznk;
import java.util.Locale;

public final class zzacj {
    private int zzcup;
    private boolean zzcuw;
    private boolean zzcux;
    private int zzcvb;
    private int zzcvf;
    private int zzcvg;
    private String zzcus;
    private int zzcvc;
    private int zzcvd;
    private int zzcve;
    private boolean zzcvj;
    private int zzcvk;
    private double zzcvh;
    private boolean zzcvi;
    private String zzcvl;
    private String zzcvm;
    private boolean zzcuq;
    private boolean zzcur;
    private String zzcut;
    private boolean zzcuu;
    private boolean zzcuv;
    private String zzcuy;
    private String zzcuz;
    private float zzawx;
    private int zzcoo;
    private int zzcop;
    private String zzcva;
    private boolean zzcvn;

    public zzacj(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Locale locale = Locale.getDefault();
        this.zzcuq = zzacj.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcur = zzacj.zza(packageManager, "http://www.google.com") != null;
        this.zzcut = locale.getCountry();
        zzjh.zzhu();
        this.zzcuu = zzajf.zzrs();
        this.zzcuv = zzi.zzck((Context)context);
        this.zzcuy = locale.getLanguage();
        this.zzcuz = zzacj.zzb(context, packageManager);
        this.zzcva = zzacj.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzawx = displayMetrics.density;
        this.zzcoo = displayMetrics.widthPixels;
        this.zzcop = displayMetrics.heightPixels;
    }

    public zzacj(Context context, zzaci zzaci2) {
        context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Context context2 = context;
        zzacj zzacj2 = this;
        this.zzcvl = Build.FINGERPRINT;
        zzacj2.zzcvm = Build.DEVICE;
        zzacj2.zzcvn = zzp.zzale() && zznk.zzj(context2);
        this.zzcuq = zzaci2.zzcuq;
        this.zzcur = zzaci2.zzcur;
        this.zzcut = zzaci2.zzcut;
        this.zzcuu = zzaci2.zzcuu;
        this.zzcuv = zzaci2.zzcuv;
        this.zzcuy = zzaci2.zzcuy;
        this.zzcuz = zzaci2.zzcuz;
        this.zzcva = zzaci2.zzcva;
        this.zzawx = zzaci2.zzawx;
        this.zzcoo = zzaci2.zzcoo;
        this.zzcop = zzaci2.zzcop;
    }

    private final void zzl(Context context) {
        zzbv.zzea();
        AudioManager audioManager = zzahg.zzan(context);
        if (audioManager != null) {
            try {
                this.zzcup = audioManager.getMode();
                this.zzcuw = audioManager.isMusicActive();
                this.zzcux = audioManager.isSpeakerphoneOn();
                this.zzcvb = audioManager.getStreamVolume(3);
                this.zzcvf = audioManager.getRingerMode();
                this.zzcvg = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbv.zzee().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcup = -2;
        this.zzcuw = false;
        this.zzcux = false;
        this.zzcvb = 0;
        this.zzcvf = 0;
        this.zzcvg = 0;
    }

    @TargetApi(value=16)
    private final void zzm(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcus = telephonyManager.getNetworkOperator();
        this.zzcvd = telephonyManager.getNetworkType();
        this.zzcve = telephonyManager.getPhoneType();
        this.zzcvc = -2;
        this.zzcvj = false;
        this.zzcvk = -1;
        zzbv.zzea();
        if (zzahg.zzc(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcvc = networkInfo.getType();
                this.zzcvk = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcvc = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcvj = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzn(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcvh = (float)n2 / (float)n3;
            this.zzcvi = n == 2 || n == 5;
            return;
        }
        this.zzcvh = -1.0;
        this.zzcvi = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbed.zzcr((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzacj.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbed.zzcr((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbv.zzee().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaci zzos() {
        return new zzaci(this.zzcup, this.zzcuq, this.zzcur, this.zzcus, this.zzcut, this.zzcuu, this.zzcuv, this.zzcuw, this.zzcux, this.zzcuy, this.zzcuz, this.zzcva, this.zzcvb, this.zzcvc, this.zzcvd, this.zzcve, this.zzcvf, this.zzcvg, this.zzawx, this.zzcoo, this.zzcop, this.zzcvh, this.zzcvi, this.zzcvj, this.zzcvk, this.zzcvl, this.zzcvn, this.zzcvm);
    }
}

