/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzud;
import com.google.android.gms.internal.zzue;
import com.google.android.gms.internal.zzug;
import com.google.android.gms.internal.zzui;
import com.google.android.gms.internal.zzuj;
import com.google.android.gms.internal.zzuk;
import com.google.android.gms.internal.zzul;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzvc;
import com.google.android.gms.internal.zzvn;
import com.google.android.gms.internal.zzwh;
import com.google.android.gms.internal.zzzn;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzuh
implements zzul {
    private final String zzcbn;
    private final zzut zzamp;
    private final long zzcbo;
    private final zzue zzcbp;
    private final zzud zzcbq;
    private zziq zzaqy;
    private final zziu zzare;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzajl zzaor;
    private final boolean zzaup;
    private final zzom zzaon;
    private final List<String> zzaoo;
    private final List<String> zzcbr;
    private final List<String> zzcbs;
    private final boolean zzcbt;
    private zzuw zzcbu;
    private int zzcbv = -2;
    private zzvc zzcbw;

    public zzuh(Context context, String string, zzut zzut2, zzue zzue2, zzud zzud2, zziq zziq2, zziu zziu2, zzajl zzajl2, boolean bl, boolean bl2, zzom zzom2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzamp = zzut2;
        this.zzcbq = zzud2;
        this.zzcbn = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzlo() : string;
        this.zzcbp = zzue2;
        this.zzcbo = zzue2.zzcau != -1L ? zzue2.zzcau : 10000L;
        this.zzaqy = zziq2;
        this.zzare = zziu2;
        this.zzaor = zzajl2;
        this.zzaup = bl;
        this.zzcbt = bl2;
        this.zzaon = zzom2;
        this.zzaoo = list;
        this.zzcbr = list2;
        this.zzcbs = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzcbu != null) {
                    this.zzcbu.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzafy.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzcbv = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzlo() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzcbq.zzcaf)) {
                if (this.zzamp.zzbh(this.zzcbq.zzcaf)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzt(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbv = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzvc zzvc2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbv = 0;
            this.zzcbw = zzvc2;
            this.mLock.notify();
            return;
        }
    }

    private static zzuw zza(MediationAdapter mediationAdapter) {
        return new zzvn(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzuk zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzug zzug2 = new zzug();
            zzahg.zzdbz.post((Runnable)new zzui(this, zzug2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzcbo;
            zzuh zzuh2 = this;
            while (zzuh2.zzcbv == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzuh zzuh3 = zzuh2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzafy.zzcq((String)"Timed out waiting for adapter.");
                    zzuh3.zzcbv = 3;
                    continue;
                }
                try {
                    zzuh3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzuh3.zzcbv = 5;
                }
            }
            long l14 = zzbv.zzeg().elapsedRealtime() - l3;
            return new zzuk(this.zzcbq, this.zzcbu, this.zzcbn, zzug2, this.zzcbv, this.zzlp(), l14);
        }
    }

    private final zzvc zzlp() {
        if (this.zzcbv != 0 || !this.zzlr()) {
            return null;
        }
        try {
            if (this.zzu(4) && this.zzcbw != null && this.zzcbw.zzlt() != 0) {
                return this.zzcbw;
            }
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzls();
        return new zzuj(n);
    }

    private final zzuw zzlq() {
        String string = String.valueOf(this.zzcbn);
        zzafy.zzcq((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzaup && !this.zzcbq.zzln()) {
            zzmd<Boolean> zzmd2 = zzmn.zzble;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbn)) {
                return zzuh.zza((MediationAdapter)new AdMobAdapter());
            }
            zzmd2 = zzmn.zzblf;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzcbn)) {
                return zzuh.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzcbn)) {
                return new zzvn((MediationAdapter)new zzwh());
            }
        }
        try {
            return this.zzamp.zzbg(this.zzcbn);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzcbn);
            zzafy.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzug zzug2) {
        String string = this.zzbe(this.zzcbq.zzcak);
        try {
            if (this.zzaor.zzdex < 4100000) {
                if (this.zzare.zzbcw) {
                    this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzaqy, string, (zzuz)zzug2);
                    return;
                }
                this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzare, this.zzaqy, string, (zzuz)zzug2);
                return;
            }
            if (this.zzaup || this.zzcbq.zzln()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzaoo);
                if (this.zzcbr != null) {
                    for (String string2 : this.zzcbr) {
                        String string3 = ":false";
                        if (this.zzcbs != null && this.zzcbs.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzaqy, string, this.zzcbq.zzcab, (zzuz)zzug2, this.zzaon, arrayList);
                return;
            }
            if (this.zzare.zzbcw) {
                this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzaqy, string, this.zzcbq.zzcab, (zzuz)zzug2);
                return;
            }
            if (this.zzcbt) {
                if (this.zzcbq.zzcan != null) {
                    this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzaqy, string, this.zzcbq.zzcab, (zzuz)zzug2, new zzom(zzuh.zzbf(this.zzcbq.zzcar)), this.zzcbq.zzcaq);
                    return;
                }
                this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzare, this.zzaqy, string, this.zzcbq.zzcab, (zzuz)zzug2);
                return;
            }
            this.zzcbu.zza(zzn.zzw((Object)this.mContext), this.zzare, this.zzaqy, string, this.zzcbq.zzcab, (zzuz)zzug2);
            return;
        }
        catch (RemoteException remoteException) {
            zzafy.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzt(5);
            return;
        }
    }

    private final boolean zzu(int n) {
        Bundle bundle;
        try {
            bundle = this.zzaup ? this.zzcbu.zzly() : (this.zzare.zzbcw ? this.zzcbu.getInterstitialAdapterInfo() : this.zzcbu.zzlx());
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzlr() {
        return this.zzcbp.zzcbe != -1;
    }

    private final String zzbe(String string) {
        if (string == null || !this.zzlr() || this.zzu(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafy.zzcr((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzls() {
        JSONObject jSONObject;
        if (this.zzcbq.zzcak == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzcbq.zzcak);
        }
        catch (JSONException jSONException) {
            zzafy.zzcr((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbn)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzu(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbf(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzafy.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzuh zzuh2) {
        return zzuh2.mLock;
    }

    static /* synthetic */ int zzb(zzuh zzuh2) {
        return zzuh2.zzcbv;
    }

    static /* synthetic */ zzuw zza(zzuh zzuh2, zzuw zzuw2) {
        zzuh2.zzcbu = zzuw2;
        return zzuh2.zzcbu;
    }

    static /* synthetic */ zzuw zzc(zzuh zzuh2) {
        return zzuh2.zzlq();
    }

    static /* synthetic */ zzuw zzd(zzuh zzuh2) {
        return zzuh2.zzcbu;
    }

    static /* synthetic */ boolean zze(zzuh zzuh2) {
        return zzuh2.zzlr();
    }

    static /* synthetic */ boolean zza(zzuh zzuh2, int n) {
        return zzuh2.zzu(1);
    }

    static /* synthetic */ String zzf(zzuh zzuh2) {
        return zzuh2.zzcbn;
    }

    static /* synthetic */ void zza(zzuh zzuh2, zzug zzug2) {
        zzuh2.zza(zzug2);
    }
}

