/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.internal.zzwm;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzzn;
import java.util.Map;

@zzzn
public final class zzwk
extends zzwx {
    private final Map<String, String> zzbql;
    private final Context mContext;
    private String zzcdn;
    private long zzcdo;
    private long zzcdp;
    private String zzcdq;
    private String zzcdr;

    public zzwk(zzakl zzakl2, Map<String, String> map) {
        super(zzakl2, "createCalendarEvent");
        this.zzbql = map;
        this.mContext = zzakl2.zzsa();
        zzwk zzwk2 = this;
        zzwk2.zzcdn = zzwk2.zzbk("description");
        zzwk2.zzcdq = zzwk2.zzbk("summary");
        zzwk2.zzcdo = zzwk2.zzbl("start_ticks");
        zzwk2.zzcdp = zzwk2.zzbl("end_ticks");
        zzwk2.zzcdr = zzwk2.zzbk("location");
    }

    private final String zzbk(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbql.get(string2))) {
            return "";
        }
        return this.zzbql.get(string2);
    }

    private final long zzbl(String string2) {
        String string3 = this.zzbql.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbm("Activity context is not available.");
            return;
        }
        zzbv.zzea();
        if (!zzahg.zzaj(this.mContext).zzik()) {
            this.zzbm("This feature is not available on the device.");
            return;
        }
        zzbv.zzea();
        AlertDialog.Builder builder = zzahg.zzai(this.mContext);
        Resources resources = zzbv.zzee().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwl(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwm(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzcdn);
        intent.putExtra("eventLocation", this.zzcdr);
        intent.putExtra("description", this.zzcdq);
        if (this.zzcdo > -1L) {
            intent.putExtra("beginTime", this.zzcdo);
        }
        if (this.zzcdp > -1L) {
            intent.putExtra("endTime", this.zzcdp);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzwk zzwk2) {
        return zzwk2.mContext;
    }
}

