/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzab;
import com.google.android.gms.ads.internal.overlay.zzac;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzas;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zzzn;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzn
public final class zzaa
extends FrameLayout
implements zzx {
    private final zzakl zzbwa;
    private final FrameLayout zzchn;
    private final zzna zzcho;
    private final zzas zzchp;
    private final long zzchq;
    @Nullable
    private zzy zzchr;
    private boolean zzchs;
    private boolean zzcht;
    private boolean zzchu;
    private boolean zzchv;
    private long zzchw;
    private long zzchx;
    private String zzbwf;
    private Bitmap zzchy;
    private ImageView zzchz;
    private boolean zzcia;

    public static void zzg(zzakl zzakl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public static void zzc(zzakl zzakl2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzakl zzakl2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string);
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public zzaa(Context context, zzakl zzakl2, int n, boolean bl, zzna zzna2, zzaq zzaq2) {
        super(context);
        zzmd<Constable> zzmd2;
        this.zzbwa = zzakl2;
        this.zzcho = zzna2;
        this.zzchn = new FrameLayout(context);
        this.addView((View)this.zzchn, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzr((Object)zzakl2.zzbi());
        this.zzchr = zzakl2.zzbi().zzang.zza(context, zzakl2, n, bl, zzna2, zzaq2);
        if (this.zzchr != null) {
            this.zzchn.addView((View)this.zzchr, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzmd2 = zzmn.zzbgq;
            if (((Boolean)((Object)zzbv.zzen().zzd(zzmd2))).booleanValue()) {
                this.zznh();
            }
        }
        this.zzchz = new ImageView(context);
        zzmd2 = zzmn.zzbgu;
        this.zzchq = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbgs;
        this.zzchv = (Boolean)((Object)zzbv.zzen().zzd(zzmd2));
        if (this.zzcho != null) {
            this.zzcho.zzf("spinner_used", this.zzchv ? "1" : "0");
        }
        this.zzchp = new zzas(this);
        if (this.zzchr != null) {
            this.zzchr.zza(this);
        }
        if (this.zzchr == null) {
            this.zzh("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzchn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzbp(String string) {
        this.zzbwf = string;
    }

    public final void zza(float f, float f2) {
        if (this.zzchr != null) {
            this.zzchr.zza(f, f2);
        }
    }

    public final void zzne() {
        if (this.zzchr == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbwf)) {
            this.zzchr.setVideoPath(this.zzbwf);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzchr == null) {
            return;
        }
        this.zzchr.pause();
    }

    public final void play() {
        if (this.zzchr == null) {
            return;
        }
        this.zzchr.play();
    }

    public final void seekTo(int n) {
        if (this.zzchr == null) {
            return;
        }
        this.zzchr.seekTo(n);
    }

    public final void zznf() {
        if (this.zzchr == null) {
            return;
        }
        zzy zzy2 = this.zzchr;
        zzy2.zzchm.setMuted(true);
        zzy2.zzmn();
    }

    public final void zzng() {
        if (this.zzchr == null) {
            return;
        }
        zzy zzy2 = this.zzchr;
        zzy2.zzchm.setMuted(false);
        zzy2.zzmn();
    }

    public final void zzb(float f) {
        if (this.zzchr == null) {
            return;
        }
        float f2 = f;
        zzy zzy2 = this.zzchr;
        zzy2.zzchm.zzb(f2);
        zzy2.zzmn();
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzchr == null) {
            return;
        }
        this.zzchr.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zznh() {
        if (this.zzchr == null) {
            return;
        }
        Context context = this.zzchr.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzchr.zzmj());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzchn.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzchn.bringChildToFront((View)textView);
    }

    @Override
    public final void zzmy() {
        this.zzchp.resume();
        zzahg.zzdca.post((Runnable)new zzab(this));
    }

    @Override
    public final void zzmz() {
        if (this.zzchr == null) {
            return;
        }
        if (this.zzchx == 0L) {
            float f = (float)this.zzchr.getDuration() / 1000.0f;
            int n = this.zzchr.getVideoWidth();
            int n2 = this.zzchr.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzna() {
        zzaa zzaa2 = this;
        if (zzaa2.zzbwa.zzsa() != null && !zzaa2.zzcht) {
            WindowManager.LayoutParams layoutParams = zzaa2.zzbwa.zzsa().getWindow().getAttributes();
            boolean bl = zzaa2.zzchu = (layoutParams.flags & 0x80) != 0;
            if (!zzaa2.zzchu) {
                zzaa2.zzbwa.zzsa().getWindow().addFlags(128);
                zzaa2.zzcht = true;
            }
        }
        this.zzchs = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zznk();
        this.zzchs = false;
    }

    @Override
    public final void zznb() {
        this.zza("ended", new String[0]);
        this.zznk();
    }

    @Override
    public final void zzh(String string, @Nullable String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public final void zznc() {
        zzaa zzaa2 = this;
        if (zzaa2.zzcia && zzaa2.zzchy != null && !zzaa2.zznj()) {
            zzaa2.zzchz.setImageBitmap(zzaa2.zzchy);
            zzaa2.zzchz.invalidate();
            zzaa2.zzchn.addView((View)zzaa2.zzchz, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaa2.zzchn.bringChildToFront((View)zzaa2.zzchz);
        }
        this.zzchp.pause();
        this.zzchx = this.zzchw;
        zzahg.zzdca.post((Runnable)new zzac(this));
    }

    public final void destroy() {
        this.zzchp.pause();
        if (this.zzchr != null) {
            this.zzchr.stop();
        }
        this.zznk();
    }

    final void zzni() {
        if (this.zzchr == null) {
            return;
        }
        long l = this.zzchr.getCurrentPosition();
        if (this.zzchw != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzchw = l;
        }
    }

    @Override
    public final void zznd() {
        zzaa zzaa2;
        if (this.zzchs && (zzaa2 = this).zznj()) {
            zzaa2.zzchn.removeView((View)zzaa2.zzchz);
        }
        zzaa2 = this;
        if (zzaa2.zzchy != null) {
            long l = zzbv.zzeg().elapsedRealtime();
            if (zzaa2.zzchr.getBitmap(zzaa2.zzchy) != null) {
                zzaa2.zzcia = true;
            }
            long l2 = zzbv.zzeg().elapsedRealtime() - l;
            if (zzafy.zzqu()) {
                zzafy.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaa2.zzchq) {
                zzafy.zzcr((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaa2.zzchv = false;
                zzaa2.zzchy = null;
                if (zzaa2.zzcho != null) {
                    zzaa2.zzcho.zzf("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzd(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaa zzaa2 = this;
        if (zzaa2.zzchv) {
            zzmd<Integer> zzmd2 = zzmn.zzbgt;
            n4 = Math.max(n4 / zzbv.zzen().zzd(zzmd2), 1);
            zzmd2 = zzmn.zzbgt;
            n3 = Math.max(n3 / zzbv.zzen().zzd(zzmd2), 1);
            if (zzaa2.zzchy == null || zzaa2.zzchy.getWidth() != n4 || zzaa2.zzchy.getHeight() != n3) {
                zzaa2.zzchy = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaa2.zzcia = false;
            }
        }
    }

    private final boolean zznj() {
        return this.zzchz.getParent() != null;
    }

    private final void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzbwa.zza("onVideoEvent", hashMap);
    }

    private final void zznk() {
        if (this.zzbwa.zzsa() == null) {
            return;
        }
        if (this.zzcht && !this.zzchu) {
            this.zzbwa.zzsa().getWindow().clearFlags(128);
            this.zzcht = false;
        }
    }

    static /* synthetic */ void zza(zzaa zzaa2, String string, String[] stringArray) {
        zzaa2.zza(string, stringArray);
    }
}

