/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzan;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzzn;

@zzzn
final class zzam
implements SensorEventListener {
    private final SensorManager zzcii;
    private final Object zzcij;
    private final Display zzcik;
    private final float[] zzcil;
    private final float[] zzcim;
    private float[] zzcin;
    private Handler zzcio;
    private zzao zzcip;

    zzam(Context context) {
        this.zzcii = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzcik = windowManager.getDefaultDisplay();
        this.zzcil = new float[9];
        this.zzcim = new float[9];
        this.zzcij = new Object();
    }

    final void start() {
        if (this.zzcio != null) {
            return;
        }
        Sensor sensor = this.zzcii.getDefaultSensor(11);
        if (sensor == null) {
            zzafy.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzcio = new Handler(handlerThread.getLooper());
        if (!this.zzcii.registerListener((SensorEventListener)this, sensor, 0, this.zzcio)) {
            zzafy.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzcio == null) {
            return;
        }
        this.zzcii.unregisterListener((SensorEventListener)this);
        this.zzcio.post((Runnable)new zzan(this));
        this.zzcio = null;
    }

    final void zza(zzao zzao2) {
        this.zzcip = zzao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzam zzam2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzam2.zzcij;
            synchronized (object) {
                if (zzam2.zzcin == null) {
                    zzam2.zzcin = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzam2.zzcil, (float[])fArray);
            switch (zzam2.zzcik.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcil, (int)2, (int)129, (float[])zzam2.zzcim);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcil, (int)129, (int)130, (float[])zzam2.zzcim);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcil, (int)130, (int)1, (float[])zzam2.zzcim);
                    break;
                }
                default: {
                    System.arraycopy(zzam2.zzcil, 0, zzam2.zzcim, 0, 9);
                }
            }
            zzam2.zze(1, 3);
            zzam2.zze(2, 6);
            zzam2.zze(5, 7);
            Object object2 = zzam2.zzcij;
            synchronized (object2) {
                System.arraycopy(zzam2.zzcim, 0, zzam2.zzcin, 0, 9);
            }
            if (zzam2.zzcip != null) {
                zzam2.zzcip.zzmu();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzcij;
        synchronized (object) {
            if (this.zzcin == null) {
                return false;
            }
            System.arraycopy(this.zzcin, 0, fArray, 0, this.zzcin.length);
            return true;
        }
    }

    private final void zze(int n, int n2) {
        float f = this.zzcim[n];
        this.zzcim[n] = this.zzcim[n2];
        this.zzcim[n2] = f;
    }
}

