/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbvz;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzeyn;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzcz {
    private static final String TAG = zzcz.class.getSimpleName();
    protected Context zzahz;
    private Context zzaia;
    private ExecutorService zzaib;
    private DexClassLoader zzaic;
    private zzcu zzaid;
    private byte[] zzaie;
    private volatile AdvertisingIdClient zzaif = null;
    private volatile boolean zzahg = false;
    private Future zzaig = null;
    private volatile zzaw zzaih = null;
    private Future zzaii = null;
    private zzcm zzaij;
    private boolean zzaik = false;
    private static Object zzail = new Object();
    private boolean zzaim = false;
    private static zze zzain = null;
    private Map<Pair<String, String>, zzdy> zzaio;
    private boolean zzaip = false;

    public static zzcz zza(Context context, String string2, String string3, boolean bl) {
        zzcz zzcz2 = new zzcz(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzcz zzcz3 = zzcz2;
            zzcz2.zzaib = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzcz3;
            zzcz3.zzahg = bl3;
            if (bl3) {
                ((zzcz)object).zzaig = ((zzcz)object).zzaib.submit(new zzda((zzcz)object));
            }
            zzcz zzcz4 = zzcz3;
            zzcz4.zzaib.execute(new zzdc(zzcz4));
            try {
                zzain = zze.zzaex();
                zzcz4.zzaik = zze.zzbw((Context)zzcz4.zzahz) > 0;
                zzcz4.zzaim = zzain.isGooglePlayServicesAvailable(zzcz4.zzahz) == 0;
            }
            catch (Throwable throwable) {}
            zzcz3.zza(0, true);
            if (zzde.zzaq()) {
                object = zzmn.zzblx;
                if (((Boolean)zzbv.zzen().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzcz4 = zzcz3;
            zzcz3.zzaid = new zzcu(null);
            try {
                zzcz4.zzaie = zzcz4.zzaid.zzk(string6);
            }
            catch (zzcv zzcv2) {
                throw new zzcw(zzcv2);
            }
            string6 = string4;
            zzcz4 = zzcz3;
            try {
                String string7;
                File file = zzcz4.zzahz.getCacheDir();
                if (file == null && (file = zzcz4.zzahz.getDir("dex", 0)) == null) {
                    throw new zzcw();
                }
                String string8 = string7 = "1496809943795";
                File file2 = file;
                String string9 = string6;
                zzcz zzcz5 = zzcz4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzcz5.zzaid.zzb(zzcz5.zzaie, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzcz4.zzb(file, string7);
                try {
                    zzcz4.zzaic = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzcz4.zzahz.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzcz.zza(file4);
                    zzcz4.zza(file, string7);
                    zzcz.zzl(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzcz.zza(file4);
                zzcz4.zza(file, string7);
                zzcz.zzl(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcw(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcw(iOException);
            }
            catch (zzcv zzcv3) {
                throw new zzcw(zzcv3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcw(nullPointerException);
            }
            zzcz3.zzaij = new zzcm(zzcz3);
            zzcz3.zzaip = true;
        }
        catch (zzcw zzcw2) {}
        return zzcz2;
    }

    public final Context getContext() {
        return this.zzahz;
    }

    public final boolean isInitialized() {
        return this.zzaip;
    }

    public final Context getApplicationContext() {
        return this.zzaia;
    }

    public final ExecutorService zzad() {
        return this.zzaib;
    }

    public final DexClassLoader zzae() {
        return this.zzaic;
    }

    public final zzcu zzaf() {
        return this.zzaid;
    }

    public final byte[] zzag() {
        return this.zzaie;
    }

    public final boolean zzah() {
        return this.zzaik;
    }

    public final zzcm zzai() {
        return this.zzaij;
    }

    public final boolean zzaj() {
        return this.zzaim;
    }

    public final zzaw zzak() {
        return this.zzaih;
    }

    public final Future zzal() {
        return this.zzaii;
    }

    private zzcz(Context context) {
        this.zzahz = context;
        this.zzaia = context.getApplicationContext();
        this.zzaio = new HashMap<Pair<String, String>, zzdy>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            return;
        }
        zzba zzba2 = new zzba();
        new zzba().zzgc = Build.VERSION.SDK.getBytes();
        zzba2.zzgb = string2.getBytes();
        byte[] byArray2 = this.zzaid.zzc(this.zzaie, byArray).getBytes();
        zzba2.data = byArray2;
        zzba2.zzga = zzbt.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzeyn.zzc((zzeyn)zzba2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzcz.zza(file2);
        return;
        catch (zzcv | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            throw throwable;
        }
    }

    private static void zzl(String string2) {
        zzcz.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzba zzba2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzcz.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzcz.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzba2 = (zzba)zzeyn.zza((zzeyn)new zzba(), (byte[])byArray2);
                if (string2.equals(new String(zzba2.zzgb)) && Arrays.equals(zzba2.zzga, zzbt.zzb(zzba2.data)) && Arrays.equals(zzba2.zzgc, Build.VERSION.SDK.getBytes())) break block30;
                zzcz.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzaid.zzb(this.zzaie, new String(zzba2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcv | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzaio.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzaio.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzdy(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzdy zzdy2 = this.zzaio.get(new Pair((Object)string2, (Object)string3));
        if (zzdy2 == null) {
            return null;
        }
        return zzdy2.zzaw();
    }

    private final void zzam() {
        try {
            if (this.zzaif == null && this.zzaia != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaia);
                advertisingIdClient.start();
                this.zzaif = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaif = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzaim) {
            return;
        }
        Future<?> future = this.zzaib.submit(new zzdb(this, n, bl));
        if (n == 0) {
            this.zzaii = future;
        }
    }

    @VisibleForTesting
    final zzaw zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzan();
    }

    private static boolean zza(int n, zzaw zzaw2) {
        if (n < 4) {
            if (zzaw2 == null) {
                return true;
            }
            zzmd<Boolean> zzmd2 = zzmn.zzbma;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && (zzaw2.zzcr == null || zzaw2.zzcr.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzmd2 = zzmn.zzbmb;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && (zzaw2.zzex == null || zzaw2.zzex.zzfv == null || zzaw2.zzex.zzfv == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzaw zzan() {
        zzaw zzaw2 = null;
        try {
            PackageInfo packageInfo = this.zzahz.getPackageManager().getPackageInfo(this.zzahz.getPackageName(), 0);
            zzaw2 = zzbvz.zzn((Context)this.zzahz, (String)this.zzahz.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzaw2;
    }

    public final AdvertisingIdClient zzao() {
        if (!this.zzahg) {
            return null;
        }
        if (this.zzaif != null) {
            return this.zzaif;
        }
        if (this.zzaig != null) {
            try {
                this.zzaig.get(2000L, TimeUnit.MILLISECONDS);
                this.zzaig = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzaig.cancel(true);
            }
        }
        return this.zzaif;
    }

    public final int zzz() {
        int n = Integer.MIN_VALUE;
        if (this.zzaij != null) {
            n = zzcm.zzz();
        }
        return n;
    }

    static /* synthetic */ void zza(zzcz zzcz2) {
        zzcz2.zzam();
    }

    static /* synthetic */ zzaw zza(zzcz zzcz2, zzaw zzaw2) {
        zzcz2.zzaih = zzaw2;
        return zzcz2.zzaih;
    }

    static /* synthetic */ boolean zzb(int n, zzaw zzaw2) {
        return zzcz.zza(n, zzaw2);
    }
}

