/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzfa
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzafj> zzauu;
    private WeakReference<ViewTreeObserver> zzauv;
    private final zzgk zzauw;
    protected final zzey zzaux;
    private final Context mApplicationContext;
    private final WindowManager zzauy;
    private final PowerManager zzauz;
    private final KeyguardManager zzava;
    private final DisplayMetrics zzavb;
    @Nullable
    private zzfh zzavc;
    private boolean zzavd;
    private boolean zzarb = false;
    private boolean zzave = false;
    private boolean zzavf;
    private boolean zzavg;
    private boolean zzavh;
    @Nullable
    private BroadcastReceiver zzavi;
    private final HashSet<Object> zzavj = new HashSet();
    private zzaiy zzaue;
    private final HashSet<zzfv> zzavk = new HashSet();
    private final Rect zzavl = new Rect();
    private final zzfd zzavm;
    private float zzavn;

    public zzfa(Context context, zziu zziu2, zzafj zzafj2, zzajl zzajl2, zzgk zzgk2) {
        this.zzauu = new WeakReference<zzafj>(zzafj2);
        this.zzauw = zzgk2;
        this.zzauv = new WeakReference<Object>(null);
        this.zzavf = true;
        this.zzavh = false;
        this.zzaue = new zzaiy(200L);
        this.zzaux = new zzey(UUID.randomUUID().toString(), zzajl2, zziu2.zzbcw, zzafj2.zzcyo, zzafj2.zzfo(), zziu2.zzbcz);
        this.zzauy = (WindowManager)context.getSystemService("window");
        this.zzauz = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzava = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzavm = new zzfd(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzavm);
        this.zzavb = context.getResources().getDisplayMetrics();
        Display display = this.zzauy.getDefaultDisplay();
        this.zzavl.right = display.getWidth();
        this.zzavl.bottom = display.getHeight();
        this.zzfq();
    }

    public final void zzfq() {
        zzbv.zzea();
        this.zzavn = zzahg.zzao(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfr() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzavf) {
                this.zzavg = true;
                try {
                    JSONObject jSONObject = this.zzfv();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafy.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafy.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzaux.zzfn());
                zzafy.zzca((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzj(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzfv> iterator = this.zzavk.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzfz()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzavf) {
                return;
            }
            View view = this.zzauw.zzfw();
            boolean bl3 = view != null && zzbv.zzea().zza(view, this.zzauz, this.zzava);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzauw.zzfx()) {
                this.zzfr();
                return;
            }
            if (n == 1 && !this.zzaue.tryAcquire() && bl == this.zzavh) {
                return;
            }
            if (!bl && !this.zzavh && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzavh = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafy.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfa zzfa2 = this;
            View view2 = zzfa2.zzauw.zzfy().zzfw();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfa2.zzauv.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfa2.zzfu();
                    if (!zzfa2.zzavd || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfa2.zzavd = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfa2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfa2);
                    }
                    zzfa2.zzauv = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzfs();
            return;
        }
    }

    private final void zzfs() {
        if (this.zzavc != null) {
            this.zzavc.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzft() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzavf;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzc(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzaux.zzfn());
    }

    final void zzb(zzakl zzakl2, Map<String, String> map) {
        if (zzakl2 == null) {
            throw null;
        }
        this.zzj(3);
    }

    final void zza(zzfv zzfv2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzaux.zzfn());
        zzafy.zzca((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzfv2);
    }

    final void zzd(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzavj.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzfu() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzauv.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzfv() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzaux.zzfl()).put("activeViewJSON", (Object)this.zzaux.zzfm()).put("timestamp", zzbv.zzeg().elapsedRealtime()).put("adFormat", (Object)this.zzaux.zzfk()).put("hashCode", (Object)this.zzaux.zzfn()).put("isMraid", this.zzaux.zzfo()).put("isStopped", this.zzave).put("isPaused", this.zzarb).put("isNative", this.zzaux.zzfp()).put("isScreenOn", this.isScreenOn());
        zzbv.zzea();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzahg.zzdg());
        zzbv.zzea();
        jSONObject3.put("appVolume", (double)zzahg.zzde()).put("deviceVolume", (double)this.zzavn);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfa.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfa zzfa2 = this;
            ArrayList<zzfv> arrayList = new ArrayList<zzfv>(zzfa2.zzavk);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzfv zzfv2 = arrayList.get(i);
                zzfv2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafy.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfv zzfv2) {
        if (this.zzavk.isEmpty()) {
            zzfa zzfa2 = this;
            Object object = zzfa2.mLock;
            synchronized (object) {
                if (zzfa2.zzavi != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfa2.zzavi = new zzfb(zzfa2);
                    zzfa2.mApplicationContext.registerReceiver(zzfa2.zzavi, intentFilter);
                }
            }
            this.zzj(3);
        }
        this.zzavk.add(zzfv2);
        try {
            JSONObject jSONObject = zzfa.zza(this.zza(this.zzauw.zzfw(), null));
            zzfv2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafy.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzfv zzfv2) {
        this.zzavk.remove(zzfv2);
        zzfv2.zzga();
        if (this.zzavk.isEmpty()) {
            zzfa zzfa2 = this;
            Object object = zzfa2.mLock;
            synchronized (object) {
                zzfa2.zzfu();
                zzfa zzfa3 = zzfa2;
                Object object2 = zzfa3.mLock;
                synchronized (object2) {
                    if (zzfa3.zzavi != null) {
                        try {
                            zzfa3.mApplicationContext.unregisterReceiver(zzfa3.zzavi);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafy.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbv.zzee().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfa3.zzavi = null;
                    }
                }
                zzfa2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfa2.zzavm);
                zzfa2.zzavf = false;
                zzfa2.zzfs();
                zzfa3 = zzfa2;
                ArrayList<zzfv> arrayList = new ArrayList<zzfv>(zzfa3.zzavk);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzfv zzfv3 = arrayList.get(i);
                    zzfv zzfv4 = zzfv3;
                    zzfa3.zzb(zzfv4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfa zzfa2 = this;
            return zzfa2.zzfv().put("isAttachedToWindow", false).put("isScreenOn", zzfa2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbv.zzec().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzfv();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfa.zza(this.zzavl.top, this.zzavb)).put("bottom", zzfa.zza(this.zzavl.bottom, this.zzavb)).put("left", zzfa.zza(this.zzavl.left, this.zzavb)).put("right", zzfa.zza(this.zzavl.right, this.zzavb))).put("adBox", (Object)new JSONObject().put("top", zzfa.zza(rect.top, this.zzavb)).put("bottom", zzfa.zza(rect.bottom, this.zzavb)).put("left", zzfa.zza(rect.left, this.zzavb)).put("right", zzfa.zza(rect.right, this.zzavb))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfa.zza(rect2.top, this.zzavb)).put("bottom", zzfa.zza(rect2.bottom, this.zzavb)).put("left", zzfa.zza(rect2.left, this.zzavb)).put("right", zzfa.zza(rect2.right, this.zzavb))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfa.zza(rect3.top, this.zzavb)).put("bottom", zzfa.zza(rect3.bottom, this.zzavb)).put("left", zzfa.zza(rect3.left, this.zzavb)).put("right", zzfa.zza(rect3.right, this.zzavb))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfa.zza(rect4.top, this.zzavb)).put("bottom", zzfa.zza(rect4.bottom, this.zzavb)).put("left", zzfa.zza(rect4.left, this.zzavb)).put("right", zzfa.zza(rect4.right, this.zzavb))).put("screenDensity", (double)this.zzavb.density);
        if (bl == null) {
            bl = zzbv.zzea().zza(view, this.zzauz, this.zzava);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzauz.isInteractive();
        }
        return this.zzauz.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzj(1);
    }

    public final void onGlobalLayout() {
        this.zzj(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfh zzfh2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavc = zzfh2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzave = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarb = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarb = false;
            this.zzj(3);
            return;
        }
    }
}

