/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzzl;
import com.google.android.gms.internal.zzzn;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
@TargetApi(value=14)
public final class zzgr
extends Thread {
    private boolean mStarted = false;
    private boolean zzaye = false;
    private boolean zzbk = false;
    private final Object mLock;
    private final zzgm zzayf;
    private final zzzl zzayg;
    private final int zzayh;
    private final int zzaxd;
    private final int zzayi;
    private final int zzaxf;
    private final int zzayj;
    private final int zzayk;
    private final int zzayl;
    private final int zzaym;
    private final String zzayn;
    private final boolean zzayo;

    public zzgr(zzgm zzgm2, zzzl zzzl2) {
        this.zzayf = zzgm2;
        this.zzayg = zzzl2;
        this.mLock = new Object();
        zzmd<Object> zzmd2 = zzmn.zzbhr;
        this.zzaxd = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbhs;
        this.zzayi = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbht;
        this.zzaxf = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbhu;
        this.zzayj = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbhx;
        this.zzayk = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbhz;
        this.zzayl = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbia;
        this.zzaym = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbhv;
        this.zzayh = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbic;
        this.zzayn = (String)((Object)zzbv.zzen().zzd(zzmd2));
        zzmd2 = zzmn.zzbie;
        this.zzayo = (Boolean)((Object)zzbv.zzen().zzd(zzmd2));
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzafy.zzca((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgr.zzgo()) {
                    object = zzbv.zzed().getActivity();
                    if (object == null) {
                        zzafy.zzca((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgq();
                    } else {
                        Activity activity = object;
                        zzgr zzgr2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbv.zzee().zza(exception, "ContentFetchTask.extractContent");
                                zzafy.zzca((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgr zzgr3 = zzgr2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzgs(zzgr3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzafy.zzca((String)"ContentFetchTask: sleeping");
                    this.zzgq();
                }
                Thread.sleep(this.zzayh * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzafy.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzafy.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzayg.zza(exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzaye) {
                    try {
                        zzafy.zzca((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzf(View view) {
        try {
            zzgl zzgl2 = new zzgl(this.zzaxd, this.zzayi, this.zzaxf, this.zzayj, this.zzayk, this.zzayl, this.zzaym);
            zzgv zzgv2 = this.zza(view, zzgl2);
            zzgl2.zzgk();
            if (zzgv2.zzayw == 0 && zzgv2.zzayx == 0) {
                return;
            }
            if (zzgv2.zzayx == 0 && zzgl2.zzgl() == 0) {
                return;
            }
            if (zzgv2.zzayx == 0 && this.zzayf.zza(zzgl2)) {
                return;
            }
            this.zzayf.zzc(zzgl2);
            return;
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzayg.zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzgo() {
        try {
            Context context = zzbv.zzed().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbv.zzee().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzgv zza(@Nullable View view, zzgl zzgl2) {
        Object object;
        if (view == null) {
            return new zzgv(this, 0, 0);
        }
        Context context = zzbv.zzed().getContext();
        if (context != null) {
            object = zzmn.zzbib;
            int n = context.getResources().getIdentifier(zzbv.zzen().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzayn) && string2 != null && string2.equals(this.zzayn)) {
                return new zzgv(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzgl2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzgv(this, 1, 0);
            }
            return new zzgv(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzakl)) {
            boolean bl2;
            zzgl2.zzgj();
            zzgl zzgl3 = zzgl2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzq.zzalh()) {
                bl2 = false;
            } else {
                zzgl3.zzgj();
                webView.post((Runnable)new zzgt((zzgr)object, zzgl3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzgv(this, 0, 1);
            }
            return new zzgv(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzgv zzgv2 = this.zza(viewGroup.getChildAt(i), zzgl2);
                n += zzgv2.zzayw;
                n2 += zzgv2.zzayx;
            }
            return new zzgv(this, n, n2);
        }
        return new zzgv(this, 0, 0);
    }

    final void zza(zzgl zzgl2, WebView webView, String string2, boolean bl) {
        zzgl2.zzgi();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzayo && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzgl2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgl2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgl2.zzgd()) {
                this.zzayf.zzb(zzgl2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzafy.zzca((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzafy.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzayg.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgl zzgp() {
        return this.zzayf.zzgm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaye = false;
            this.mLock.notifyAll();
            zzafy.zzca((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgq() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzaye = true;
            zzafy.zzca((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzgr() {
        return this.zzaye;
    }
}

