/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzacj;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zztp;
import com.google.android.gms.internal.zztq;
import com.google.android.gms.internal.zztr;
import com.google.android.gms.internal.zzts;
import com.google.android.gms.internal.zztu;
import com.google.android.gms.internal.zzzn;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzzn
public final class zzto {
    private final Map<zztp, zztq> zzbxj = new HashMap<zztp, zztq>();
    private final LinkedList<zztp> zzbxk = new LinkedList();
    @Nullable
    private zzsl zzbxl;

    final void zza(zzsl zzsl2) {
        if (this.zzbxl == null) {
            this.zzbxl = zzsl2.zzkk();
            zzto zzto2 = this;
            if (zzto2.zzbxl != null) {
                SharedPreferences sharedPreferences = zzto2.zzbxl.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zzto zzto3 = zzto2;
                while (zzto3.zzbxk.size() > 0) {
                    zztp zztp2 = zzto3.zzbxk.remove();
                    zztq zztq2 = zzto3.zzbxj.get(zztp2);
                    zzto.zza("Flushing interstitial queue for %s.", zztp2);
                    while (zztq2.size() > 0) {
                        zztq2.zzm(null).zzbxq.zzda();
                    }
                    zzto3.zzbxj.remove(zztp2);
                }
                try {
                    zztp zztp2;
                    HashMap<String, zztp> hashMap = new HashMap<String, zztp>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zztu zztu2 = zztu.zzba((String)stringArray.getValue());
                        zztp2 = new zztp(zztu2.zzaqz, zztu2.zzaor, zztu2.zzbxo);
                        if (zzto2.zzbxj.containsKey(zztp2)) continue;
                        zztq zztq2 = new zztq(zztu2.zzaqz, zztu2.zzaor, zztu2.zzbxo);
                        zzto2.zzbxj.put(zztp2, zztq2);
                        hashMap.put(zztp2.toString(), zztp2);
                        zzto.zza("Restored interstitial queue for %s.", zztp2);
                    }
                    for (String string2 : zzto.zzax(sharedPreferences.getString("PoolKeys", ""))) {
                        zztp2 = (zztp)hashMap.get(string2);
                        if (!zzto2.zzbxj.containsKey(zztp2)) continue;
                        zzto2.zzbxk.add(zztp2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbv.zzee().zza(exception, "InterstitialAdPool.restore");
                    zzafy.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zzto2.zzbxj.clear();
                    zzto2.zzbxk.clear();
                }
            }
        }
    }

    @Nullable
    final zztr zza(zziq zziq2, String string2) {
        Object object;
        Object object2;
        zzmd<Integer> zzmd2;
        String string3;
        if (zzto.zzay(string2)) {
            return null;
        }
        Context context = this.zzbxl.getApplicationContext();
        int n = new zzacj((Context)context).zzos().zzcvd;
        zziq zziq3 = zzto.zzk(zziq2);
        zztp zztp2 = new zztp(zziq3, string3 = zzto.zzaz(string2), n);
        zztq zztq2 = this.zzbxj.get(zztp2);
        if (zztq2 == null) {
            zzto.zza("Interstitial pool created at %s.", zztp2);
            zztq2 = new zztq(zziq3, string3, n);
            this.zzbxj.put(zztp2, zztq2);
        }
        this.zzbxk.remove(zztp2);
        this.zzbxk.add(zztp2);
        zztq2.zzkq();
        while (true) {
            zzmd2 = zzmn.zzbkb;
            if (this.zzbxk.size() <= zzbv.zzen().zzd(zzmd2)) break;
            object2 = this.zzbxk.remove();
            object = this.zzbxj.get(object2);
            zzto.zza("Evicting interstitial queue for %s.", (zztp)object2);
            while (((zztq)object).size() > 0) {
                zztr zztr2 = ((zztq)object).zzm(null);
                if (zztr2.zzbxu) {
                    zzts.zzks().zzku();
                }
                zztr2.zzbxq.zzda();
            }
            this.zzbxj.remove(object2);
        }
        while (zztq2.size() > 0) {
            object2 = zztq2.zzm(zziq3);
            if (((zztr)object2).zzbxu) {
                zzmd2 = zzmn.zzbkd;
                if (zzbv.zzeg().currentTimeMillis() - ((zztr)object2).zzbxt > 1000L * (long)zzbv.zzen().zzd(zzmd2).intValue()) {
                    zzto.zza("Expired interstitial at %s.", zztp2);
                    zzts.zzks().zzkt();
                    continue;
                }
            }
            object = ((zztr)object2).zzbxr != null ? " (inline) " : " ";
            zzto.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zztp2);
            return object2;
        }
        return null;
    }

    final void zzb(zziq zziq2, String string2) {
        String string3;
        if (this.zzbxl == null) {
            return;
        }
        Context context = this.zzbxl.getApplicationContext();
        int n = new zzacj((Context)context).zzos().zzcvd;
        zziq zziq3 = zzto.zzk(zziq2);
        zztp zztp2 = new zztp(zziq3, string3 = zzto.zzaz(string2), n);
        zztq zztq2 = this.zzbxj.get(zztp2);
        if (zztq2 == null) {
            zzto.zza("Interstitial pool created at %s.", zztp2);
            zztq2 = new zztq(zziq3, string3, n);
            this.zzbxj.put(zztp2, zztq2);
        }
        zztq2.zza(this.zzbxl, zziq2);
        zztq2.zzkq();
        zzto.zza("Inline entry added to the queue at %s.", zztp2);
    }

    final void zzkl() {
        Object object;
        if (this.zzbxl == null) {
            return;
        }
        for (Map.Entry<zztp, zztq> entry : this.zzbxj.entrySet()) {
            int n;
            zztp zztp2 = entry.getKey();
            zztq zztq2 = entry.getValue();
            if (zzafy.zzad((int)2)) {
                n = zztq2.size();
                int n2 = zztq2.zzko();
                if (n2 < n) {
                    zzafy.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zztp2));
                }
            }
            n = 0 + zztq2.zzkp();
            while (true) {
                object = zzmn.zzbkc;
                if (zztq2.size() >= (Integer)zzbv.zzen().zzd(object)) break;
                zzto.zza("Pooling and loading one new interstitial for %s.", zztp2);
                if (!zztq2.zzb(this.zzbxl)) continue;
                ++n;
            }
            zzts.zzks().zzs(n);
        }
        object = this;
        if (((zzto)object).zzbxl != null) {
            SharedPreferences.Editor editor = ((zzto)object).zzbxl.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zztp, zztq> entry : ((zzto)object).zzbxj.entrySet()) {
                zztp zztp3 = entry.getKey();
                zztq zztq3 = entry.getValue();
                if (!zztq3.zzkr()) continue;
                String string2 = new zztu(zztq3).zzlb();
                String string3 = zztp3.toString();
                editor.putString(string3, string2);
                zzto.zza("Saved interstitial queue for %s.", zztp3);
            }
            editor.putString("PoolKeys", super.zzkm());
            editor.apply();
        }
    }

    private final String zzkm() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbxk.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zztp)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzax(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzay(String string2) {
        try {
            zzmd<String> zzmd2 = zzmn.zzbke;
            return Pattern.matches(zzbv.zzen().zzd(zzmd2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbv.zzee().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzi(zziq zziq2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zziq2.extras.keySet());
        Bundle bundle = zziq2.zzbcb.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zziq zzj(zziq zziq2) {
        zziq zziq3 = zzto.zzl(zziq2);
        String string2 = "_skipMediation";
        zziq zziq4 = zziq3;
        Bundle bundle = zziq3.zzbcb.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zziq4.extras.putBoolean(string2, true);
        return zziq3;
    }

    private static zziq zzk(zziq zziq2) {
        zziq zziq3 = zzto.zzl(zziq2);
        zzmd<String> zzmd2 = zzmn.zzbka;
        for (String string2 : zzbv.zzen().zzd(zzmd2).split(",")) {
            zzto.zzc(zziq3.zzbcb, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zzto.zzc(zziq3.extras, string4);
        }
        return zziq3;
    }

    private static String zzaz(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zziq zzl(zziq zziq2) {
        Parcel parcel = Parcel.obtain();
        zziq2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zziq zziq3 = (zziq)zziq.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzmd<Boolean> zzmd2 = zzmn.zzbjp;
        if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
            zziq.zzh((zziq)zziq3);
        }
        return zziq3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zztp zztp2) {
        if (zzafy.zzad((int)2)) {
            zzafy.v(String.format(string2, zztp2));
        }
    }
}

