/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzwo;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzzn;
import java.util.Map;
import java.util.Set;

@zzzn
public final class zzwn
extends zzwx {
    private static Set<String> zzcdu = zze.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzcdv = "top-right";
    private boolean zzcdw = true;
    private int zzcdx = 0;
    private int zzcdy = 0;
    private int zzakr = -1;
    private int zzcdz = 0;
    private int zzcea = 0;
    private int zzakq = -1;
    private final Object mLock = new Object();
    private final zzakl zzbwa;
    private final Activity zzcdl;
    private zziu zzarf;
    private ImageView zzceb;
    private LinearLayout zzcec;
    private zzwy zzced;
    private PopupWindow zzcee;
    private RelativeLayout zzcef;
    private ViewGroup zzceg;

    public zzwn(zzakl zzakl2, zzwy zzwy2) {
        super(zzakl2, "resize");
        this.zzbwa = zzakl2;
        this.zzcdl = zzakl2.zzsa();
        this.zzced = zzwy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzcdl == null) {
                this.zzbm("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbwa.zzbk() == null) {
                this.zzbm("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbwa.zzbk().zzbcx) {
                this.zzbm("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbwa.zzsi()) {
                this.zzbm("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwn zzwn2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbv.zzea();
                zzwn2.zzakq = zzahg.zzch(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbv.zzea();
                zzwn2.zzakr = zzahg.zzch(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbv.zzea();
                zzwn2.zzcdz = zzahg.zzch(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbv.zzea();
                zzwn2.zzcea = zzahg.zzch(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwn2.zzcdw = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwn2.zzcdv = string2;
            }
            zzwn2 = this;
            if (!(zzwn2.zzakq >= 0 && zzwn2.zzakr >= 0)) {
                this.zzbm("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzcdl.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbm("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmh();
            if (nArray == null) {
                this.zzbm("Resize location out of screen or close button is not visible.");
                return;
            }
            zzjh.zzhu();
            int n = zzajf.zzc((Context)this.zzcdl, (int)this.zzakq);
            zzjh.zzhu();
            int n2 = zzajf.zzc((Context)this.zzcdl, (int)this.zzakr);
            zzakl zzakl2 = this.zzbwa;
            if (zzakl2 == null) {
                throw null;
            }
            ViewParent viewParent = ((View)zzakl2).getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                zzakl zzakl3 = this.zzbwa;
                if (zzakl3 == null) {
                    throw null;
                }
                ((ViewGroup)viewParent).removeView((View)zzakl3);
                if (this.zzcee == null) {
                    this.zzceg = (ViewGroup)viewParent;
                    zzbv.zzea();
                    zzakl zzakl4 = this.zzbwa;
                    if (zzakl4 == null) {
                        throw null;
                    }
                    bitmap = zzahg.zzl((View)zzakl4);
                    this.zzceb = new ImageView((Context)this.zzcdl);
                    this.zzceb.setImageBitmap(bitmap);
                    this.zzarf = this.zzbwa.zzbk();
                    this.zzceg.addView((View)this.zzceb);
                } else {
                    this.zzcee.dismiss();
                }
            } else {
                this.zzbm("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzcef = new RelativeLayout((Context)this.zzcdl);
            this.zzcef.setBackgroundColor(0);
            this.zzcef.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbv.zzea();
            this.zzcee = zzahg.zza((View)this.zzcef, n, n2, false);
            this.zzcee.setOutsideTouchable(true);
            this.zzcee.setTouchable(true);
            this.zzcee.setClippingEnabled(!this.zzcdw);
            zzakl zzakl5 = this.zzbwa;
            if (zzakl5 == null) {
                throw null;
            }
            this.zzcef.addView((View)zzakl5, -1, -1);
            this.zzcec = new LinearLayout((Context)this.zzcdl);
            zzjh.zzhu();
            int n3 = zzajf.zzc((Context)this.zzcdl, (int)50);
            zzjh.zzhu();
            bitmap = new RelativeLayout.LayoutParams(n3, zzajf.zzc((Context)this.zzcdl, (int)50));
            switch (this.zzcdv) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzcec.setOnClickListener((View.OnClickListener)new zzwo(this));
            this.zzcec.setContentDescription((CharSequence)"Close button");
            this.zzcef.addView((View)this.zzcec, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzjh.zzhu();
                int n4 = zzajf.zzc((Context)this.zzcdl, (int)nArray[0]);
                zzjh.zzhu();
                this.zzcee.showAtLocation(view, 0, n4, zzajf.zzc((Context)this.zzcdl, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbm(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                zzakl zzakl6 = this.zzbwa;
                if (zzakl6 == null) {
                    throw null;
                }
                this.zzcef.removeView((View)zzakl6);
                if (this.zzceg != null) {
                    this.zzceg.removeView((View)this.zzceb);
                    zzakl zzakl7 = this.zzbwa;
                    if (zzakl7 == null) {
                        throw null;
                    }
                    this.zzceg.addView((View)zzakl7);
                    this.zzbwa.zza(this.zzarf);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwn2 = this;
            if (zzwn2.zzced != null) {
                zzwn2.zzced.zza(n6, n5, zzwn2.zzakq, zzwn2.zzakr);
            }
            this.zzbwa.zza(new zziu((Context)this.zzcdl, new AdSize(this.zzakq, this.zzakr)));
            this.zza(nArray[0], nArray[1]);
            this.zzbo("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcee != null) {
                this.zzcee.dismiss();
                zzakl zzakl2 = this.zzbwa;
                if (zzakl2 == null) {
                    throw null;
                }
                this.zzcef.removeView((View)zzakl2);
                if (this.zzceg != null) {
                    this.zzceg.removeView((View)this.zzceb);
                    zzakl zzakl3 = this.zzbwa;
                    if (zzakl3 == null) {
                        throw null;
                    }
                    this.zzceg.addView((View)zzakl3);
                    this.zzbwa.zza(this.zzarf);
                }
                if (bl) {
                    this.zzbo("default");
                    if (this.zzced != null) {
                        this.zzced.zzcm();
                    }
                }
                this.zzcee = null;
                this.zzcef = null;
                this.zzceg = null;
                this.zzcec = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzmh() {
        zzwn zzwn2 = this;
        int[] nArray = zzbv.zzea().zzg(zzwn2.zzcdl);
        int[] nArray2 = zzbv.zzea().zzh(zzwn2.zzcdl);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwn2.zzakq < 50 || zzwn2.zzakq > n) {
            zzafy.zzcr((String)"Width is too small or too large.");
            return null;
        }
        if (zzwn2.zzakr < 50 || zzwn2.zzakr > n2) {
            zzafy.zzcr((String)"Height is too small or too large.");
            return null;
        }
        if (zzwn2.zzakr == n2 && zzwn2.zzakq == n) {
            zzafy.zzcr((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwn2.zzcdw) {
            int n3;
            int n4;
            switch (zzwn2.zzcdv) {
                case "top-left": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea;
                    break;
                }
                case "top-center": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq / 2 - 25;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea;
                    break;
                }
                case "center": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq / 2 - 25;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea + zzwn2.zzakr / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea + zzwn2.zzakr - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq / 2 - 25;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea + zzwn2.zzakr - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq - 50;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea + zzwn2.zzakr - 50;
                    break;
                }
                default: {
                    n4 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq - 50;
                    n3 = zzwn2.zzcdy + zzwn2.zzcea;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcdw) {
            return new int[]{this.zzcdx + this.zzcdz, this.zzcdy + this.zzcea};
        }
        int[] nArray3 = zzbv.zzea().zzg(this.zzcdl);
        int[] nArray4 = zzbv.zzea().zzh(this.zzcdl);
        int n5 = nArray3[0];
        int n6 = this.zzcdx + this.zzcdz;
        int n7 = this.zzcdy + this.zzcea;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzakq > n5) {
            n6 = n5 - this.zzakq;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzakr <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzakr;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcdx = n;
            this.zzcdy = n2;
            if (this.zzcee != null && bl) {
                int[] nArray = this.zzmh();
                if (nArray != null) {
                    zzjh.zzhu();
                    int n3 = zzajf.zzc((Context)this.zzcdl, (int)nArray[0]);
                    zzjh.zzhu();
                    this.zzcee.update(n3, zzajf.zzc((Context)this.zzcdl, (int)nArray[1]), this.zzcee.getWidth(), this.zzcee.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzl(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbv.zzea().zzh(this.zzcdl)[0];
        this.zzb(n, n2 - n3, this.zzakq, this.zzakr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzmi() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcee != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzcdx = n;
        this.zzcdy = n2;
    }
}

