/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.gmsg;

import android.content.Context;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagl;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzzb;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
@Keep
@KeepName
public class HttpClient
implements zzt<com.google.android.gms.ads.internal.js.zza> {
    private final Context mContext;
    private final zzaiy zzaov;

    public HttpClient(Context context, zzaiy zzaiy2) {
        this.mContext = context;
        this.zzaov = zzaiy2;
    }

    private static zzb zzd(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzafj.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzkh());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzkm()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzafj.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzc zza(zzb zzb2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            Object object3;
            httpURLConnection = (HttpURLConnection)zzb2.zzki().openConnection();
            zzbs.zzec().zza(this.mContext, this.zzaov.zzcp, false, httpURLConnection);
            ArrayList<zza> arrayList = zzb2.zzkj();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zza zza2 = arrayList.get(i);
                object3 = zza2;
                httpURLConnection.addRequestProperty(((zza)object3).getKey(), ((zza)object3).getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzkk())) {
                httpURLConnection.setDoOutput(true);
                object2 = zzb2.zzkk().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object2).length);
                object3 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object3).write((byte[])object2);
                ((FilterOutputStream)object3).close();
            }
            object2 = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry object4 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : (List)object4.getValue()) {
                        ((ArrayList)object2).add(new zza((String)object4.getKey(), string2));
                    }
                }
            }
            String string3 = zzb2.zzkh();
            int n2 = httpURLConnection.getResponseCode();
            zzbs.zzec();
            object3 = new zzd(string3, n2, (List<zza>)object2, zzagr.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            zzc zzc2 = new zzc(this, true, (zzd)object3, null);
            return zzc2;
        }
        catch (Exception exception) {
            zzc zzc2 = new zzc(this, false, null, exception.toString());
            return zzc2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Keep
    @KeepName
    public JSONObject send(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = new JSONObject();
        String string2 = "";
        try {
            string2 = jSONObject2.optString("http_request_id");
            zzb zzb2 = HttpClient.zzd(jSONObject2);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject4 = HttpClient.zza(zzc2.zzkl());
                jSONObject3.put("response", (Object)jSONObject4);
                jSONObject3.put("success", true);
            } else {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Error executing http request.", (Throwable)exception);
            try {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                zzafj.zzb((String)"Error executing http request.", (Throwable)jSONException);
            }
        }
        return jSONObject3;
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Map map2 = map;
        com.google.android.gms.ads.internal.js.zza zza2 = (com.google.android.gms.ads.internal.js.zza)object;
        HttpClient httpClient = this;
        zzagl.zza(new zzu(httpClient, map2, zza2));
    }

    @zzzb
    final class zzc {
        private final zzd zzbwd;
        private final boolean zzbwe;
        private final String zzbwf;

        public zzc(HttpClient httpClient, boolean bl, zzd zzd2, String string2) {
            this.zzbwe = bl;
            this.zzbwd = zzd2;
            this.zzbwf = string2;
        }

        public final String getReason() {
            return this.zzbwf;
        }

        public final zzd zzkl() {
            return this.zzbwd;
        }

        public final boolean isSuccess() {
            return this.zzbwe;
        }
    }

    @zzzb
    static final class zzd {
        private final String zzbvz;
        private final int zzbwg;
        private final List<zza> zzbwh;
        private final String zzbrz;

        zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbvz = string2;
            this.zzbwg = n;
            this.zzbwh = list;
            this.zzbrz = string3;
        }

        public final String zzkh() {
            return this.zzbvz;
        }

        public final int getResponseCode() {
            return this.zzbwg;
        }

        public final Iterable<zza> zzkm() {
            return this.zzbwh;
        }

        public final String getBody() {
            return this.zzbrz;
        }
    }

    @zzzb
    static final class zzb {
        private final String zzbvz;
        private final URL zzbwa;
        private final ArrayList<zza> zzbwb;
        private final String zzbwc;

        zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbvz = string2;
            this.zzbwa = uRL;
            this.zzbwb = arrayList;
            this.zzbwc = string3;
        }

        public final String zzkh() {
            return this.zzbvz;
        }

        public final URL zzki() {
            return this.zzbwa;
        }

        public final ArrayList<zza> zzkj() {
            return this.zzbwb;
        }

        public final String zzkk() {
            return this.zzbwc;
        }
    }

    @zzzb
    static final class zza {
        private final String zzbfo;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzbfo = string2;
            this.mValue = string3;
        }

        public final String getKey() {
            return this.zzbfo;
        }

        public final String getValue() {
            return this.mValue;
        }
    }
}

