/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzafk;
import com.google.android.gms.internal.zzagl;
import com.google.android.gms.internal.zzags;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzagv;
import com.google.android.gms.internal.zzaik;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiv;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzfll;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzzb;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
public final class zzagr {
    public static final Handler zzczc = new zzafk(Looper.getMainLooper());
    private static AtomicReference<List<String>> zzczd = new AtomicReference<Object>(null);
    private static AtomicReference<List<String>> zzcze = new AtomicReference<Object>(null);
    private final Object mLock = new Object();
    private boolean zzczf = true;
    private String zzcxh;
    private boolean zzczg = false;
    private Pattern zzczh;
    private Pattern zzczi;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        boolean bl2 = bl;
        String string3 = string2;
        Context context2 = context;
        zzagr zzagr2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(bl2);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzagr2.zzp(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzag(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzafj.zzco((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzafj.zzco((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzafj.zzco((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzafj.zzco((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzafj.zzco((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzafj.zzco((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzafj.zzco((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzafj.zzco((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzd(Context context, String string2, String string3) {
        return zzbgc.zzcy((Context)context).checkPermission(string3, string2) == 0;
    }

    public static void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzaik(context, string2, string3).zzmx();
        }
    }

    public static void zze(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        zzagr.zza(context, string2, arrayList);
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzfll.zzfh((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzafj.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zznn.zzi(context)) {
            zzafj.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zznn zznn2 = new zznn();
        zzags zzags2 = new zzags(this, list, zznn2, context);
        zznn2.zza(zzags2);
        zznn2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzah(Context context) {
        if (this.zzczg) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzagv(this, null), intentFilter);
        this.zzczg = true;
        return true;
    }

    private static String zzpu() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzp(Context context, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcxh != null) {
                return this.zzcxh;
            }
            if (string2 == null) {
                return zzagr.zzpu();
            }
            try {
                this.zzcxh = zzbs.zzee().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzcxh)) {
                zzjk.zzhx();
                if (!zzais.zzqt()) {
                    this.zzcxh = null;
                    zzczc.post((Runnable)new zzagt(this, context));
                    while (this.zzcxh == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzcxh = zzagr.zzpu();
                            String string3 = String.valueOf(this.zzcxh);
                            zzafj.zzco((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzcxh = zzagr.zzai(context);
                }
            }
            String string4 = String.valueOf(this.zzcxh);
            this.zzcxh = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (zzbgc.zzcy((Context)context).zzamj()) {
                    this.zzcxh = String.valueOf(this.zzcxh).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbs.zzeg().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzcxh = String.valueOf(this.zzcxh).concat(")");
            return this.zzcxh;
        }
    }

    protected static String zzai(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzagr.zzpu();
        }
    }

    public static boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String zzcc(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzp(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(Bundle bundle, JSONObject jSONObject) {
        try {
            return this.zzc(bundle);
        }
        catch (JSONException jSONException) {
            zzafj.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zzc(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzp(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzagr zzagr2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzagr2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzp(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static Map<String, String> zzf(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : zzbs.zzee().zzg(uri)) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public static String zzpv() {
        return UUID.randomUUID().toString();
    }

    public static int zzcd(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzafj.zzco((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzpw() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzpx() {
        return new int[]{0, 0};
    }

    public static int[] zzf(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzagr.zzpx();
    }

    public final int[] zzg(Activity activity) {
        int[] nArray = zzagr.zzf(activity);
        int[] nArray2 = new int[2];
        zzjk.zzhx();
        nArray2[0] = zzais.zzd((Context)activity, (int)nArray[0]);
        zzjk.zzhx();
        nArray2[1] = zzais.zzd((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzh(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzagr.zzpx();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzjk.zzhx();
        nArray4[0] = zzais.zzd((Context)activity, (int)nArray3[0]);
        zzjk.zzhx();
        nArray4[1] = zzais.zzd((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzce(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public static void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzaj(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzmc zzak(Context context) {
        return new zzmc(context);
    }

    public static Bitmap zzm(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzal(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zziw zziw2) {
        zzmg<Boolean> zzmg2 = zzmq.zzbiy;
        if (!zzbs.zzep().zzd(zzmg2).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zziw2.width);
            jSONObject2.put("height", zziw2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzagr.zzal(context));
            if (!zziw2.zzbdb) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafj.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static String zza(Context context, zzcs zzcs2, String string2, View view) {
        if (zzcs2 == null) {
            return string2;
        }
        try {
            Uri uri = Uri.parse((String)string2);
            if (zzcs2.zzc(uri)) {
                uri = zzcs2.zza(uri, context, view);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static boolean zzam(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            zzbs.zzec();
            bundle.putString("device", zzagr.zzpw());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzmq.zziq()));
        }
        zzjk.zzhx();
        zzais.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)bl, (zzaiv)new zzagu(this, context, string2));
    }

    public final void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        zzmg<Boolean> zzmg2 = zzmq.zzbld;
        if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzczc.post(runnable);
    }

    public static void zzb(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzagl.zza(runnable);
    }

    public static Bitmap zzn(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzagr.zzp(view);
        if (bitmap == null) {
            bitmap = zzagr.zzo(view);
        }
        return bitmap;
    }

    private static Bitmap zzo(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzafj.zzco((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzafj.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzp(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzafj.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzan(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            zzmg<Boolean> zzmg2 = zzmq.zzbml;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    bitmap = zzagr.zzp(window.getDecorView().getRootView());
                }
            } else {
                bitmap = zzagr.zzo(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzafj.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static float zzdh() {
        return zzbs.zzfc().zzdh();
    }

    public static boolean zzdi() {
        return zzbs.zzfc().zzdi();
    }

    public static AudioManager zzao(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public static float zzap(Context context) {
        AudioManager audioManager = zzagr.zzao(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        if (n == 0) {
            return 0.0f;
        }
        return (float)n2 / (float)n;
    }

    public static int zzaq(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzagr.zzar(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzar(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean zza(View var1_1, PowerManager var2_2, KeyguardManager var3_3) {
        if (zzbs.zzec().zzczf || !((var5_4 /* !! */  = var3_3) == null ? false : var5_4 /* !! */ .inKeyguardRestrictedInputMode())) ** GOTO lbl-1000
        var5_4 /* !! */  = zzmq.zzbla;
        if (((Boolean)zzbs.zzep().zzd(var5_4 /* !! */ )).booleanValue() && zzagr.zzq(var1_1)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var4_5 = false;
        }
        if (var1_1.getVisibility() == 0 && var1_1.isShown() && ((var5_4 /* !! */  = var2_2) == null || var5_4 /* !! */ .isScreenOn() != false) && var4_5) {
            var5_4 /* !! */  = zzmq.zzbky;
            if (!((Boolean)zzbs.zzep().zzd(var5_4 /* !! */ )).booleanValue() || var1_1.getLocalVisibleRect(new Rect()) || var1_1.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzq(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzas(Context context) {
        if (context == null || !zzq.zzalx()) {
            return false;
        }
        KeyguardManager keyguardManager = zzagr.zzar(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzr(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzat(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzafj.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbs.zzeg().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzpy() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            zzmg<Boolean> zzmg2 = zzmq.zzbhf;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            zzmg2 = zzmq.zzbhg;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
            bundle.putInt("web_view_count", zzbs.zzeg().zzpp());
        }
        catch (Exception exception) {
            zzafj.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    public static Uri zzb(String string2, String string3, String string4) throws UnsupportedOperationException {
        int n = string2.indexOf("&adurl");
        if (n == -1) {
            n = string2.indexOf("?adurl");
        }
        if (n != -1) {
            return Uri.parse((String)(string2.substring(0, n + 1) + string3 + "=" + string4 + "&" + string2.substring(n + 1)));
        }
        return Uri.parse((String)string2).buildUpon().appendQueryParameter(string3, string4).build();
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzmg<Boolean> zzmg2 = zzmq.zzbow;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                zzagr.zzb(context, intent);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzafj.zzbw((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafj.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (zzq.zzalz()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzf(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzq(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(zzn.zza((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzafj.zzbw((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zzjk.zzhx();
        int n = zzais.zzc((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzais.zzc((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzagr.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zzmg<Integer> zzmg2 = zzmq.zzbpg;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * zzbs.zzep().zzd(zzmg2);
        return zzagr.zzb(n3, n + n5, n7) && zzagr.zzb(n4, n2, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcf(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzagr zzagr2 = this;
            synchronized (zzagr2) {
                block10: {
                    zzmg<String> zzmg2;
                    block9: {
                        if (this.zzczh == null) break block9;
                        zzmg2 = zzmq.zzbje;
                        if (zzbs.zzep().zzd(zzmg2).equals(this.zzczh.pattern())) break block10;
                    }
                    zzmg2 = zzmq.zzbje;
                    this.zzczh = Pattern.compile(zzbs.zzep().zzd(zzmg2));
                }
                return this.zzczh.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcg(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzagr zzagr2 = this;
            synchronized (zzagr2) {
                block10: {
                    zzmg<String> zzmg2;
                    block9: {
                        if (this.zzczi == null) break block9;
                        zzmg2 = zzmq.zzbjf;
                        if (zzbs.zzep().zzd(zzmg2).equals(this.zzczi.pattern())) break block10;
                    }
                    zzmg2 = zzmq.zzbjf;
                    this.zzczi = Pattern.compile(zzbs.zzep().zzd(zzmg2));
                }
                return this.zzczi.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    public static Bundle zza(zzgt zzgt2) {
        String string2;
        String string3;
        if (zzgt2 == null) {
            return null;
        }
        zzmg<Boolean> zzmg2 = zzmq.zzbig;
        if (!zzbs.zzep().zzd(zzmg2).booleanValue()) {
            zzmg2 = zzmq.zzbii;
            if (!zzbs.zzep().zzd(zzmg2).booleanValue()) {
                return null;
            }
        }
        if (zzbs.zzeg().zzos() && zzbs.zzeg().zzot()) {
            return null;
        }
        if (zzgt2.zzgu()) {
            zzgt2.wakeup();
        }
        zzgn zzgn2 = zzgt2.zzgs();
        String string4 = null;
        if (zzgn2 != null) {
            string3 = zzgn2.zzgh();
            string4 = zzgn2.zzgi();
            string2 = zzgn2.zzgj();
            if (string3 != null) {
                zzbs.zzeg().zzbz(string3);
            }
            if (string2 != null) {
                zzbs.zzeg().zzca(string2);
            }
        } else {
            string3 = zzbs.zzeg().zzoy();
            string2 = zzbs.zzeg().zzoz();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null) {
            zzmg2 = zzmq.zzbii;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && !zzbs.zzeg().zzot()) {
                bundle.putString("v_fp_vertical", string2);
            }
        }
        if (string3 != null) {
            zzmg2 = zzmq.zzbig;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && !zzbs.zzeg().zzos()) {
                bundle.putString("fingerprint", string3);
                if (!string3.equals(string4)) {
                    bundle.putString("v_fp", string4);
                }
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    public static int zzau(Context context) {
        return DynamiteModule.zzac((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zzav(Context context) {
        return DynamiteModule.zzab((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static void zzb(zzis zzis2, boolean bl) {
        Bundle bundle;
        Bundle bundle2 = zzis2.zzbcf != null ? zzis2.zzbcf : new Bundle();
        if (bundle2.getBundle(AdMobAdapter.class.getName()) != null) {
            bundle = bundle2.getBundle(AdMobAdapter.class.getName());
        } else {
            bundle = new Bundle();
            bundle2.putBundle(AdMobAdapter.class.getName(), bundle);
        }
        bundle.putBoolean("render_test_label", true);
    }

    public static boolean zzp(zzis zzis2) {
        Bundle bundle = zzis2.zzbcf != null ? zzis2.zzbcf : new Bundle();
        Bundle bundle2 = bundle.getBundle(AdMobAdapter.class.getName()) != null ? bundle.getBundle(AdMobAdapter.class.getName()) : new Bundle();
        return bundle2.getBoolean("render_test_label", false);
    }

    static /* synthetic */ boolean zza(zzagr zzagr2, boolean bl) {
        zzagr2.zzczf = bl;
        return zzagr2.zzczf;
    }

    static /* synthetic */ Object zza(zzagr zzagr2) {
        return zzagr2.mLock;
    }

    static /* synthetic */ String zza(zzagr zzagr2, String string2) {
        zzagr2.zzcxh = string2;
        return zzagr2.zzcxh;
    }
}

