/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzzb
public final class zzalz
extends zzalt {
    private static final Set<String> zzdhv = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzdhw = new DecimalFormat("#,###");
    private File zzdhx;
    private boolean zzdhy;

    public zzalz(zzali zzali2) {
        super(zzali2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzafj.zzco((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzdhx = new File(file, "admobVideoStreams");
        if (!this.zzdhx.isDirectory() && !this.zzdhx.mkdirs()) {
            String string2 = String.valueOf(this.zzdhx.getAbsolutePath());
            zzafj.zzco((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzdhx = null;
            return;
        }
        if (!this.zzdhx.setReadable(true, false) || !this.zzdhx.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzdhx.getAbsolutePath());
            zzafj.zzco((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzdhx = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzcr(String string2) {
        int n;
        int n2;
        Object object;
        Object object2;
        block35: {
            int n3;
            if (this.zzdhx == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzalz)object2).zzdhx == null) {
                    n4 = 0;
                } else {
                    int n5 = 0;
                    object = ((zzalz)object2).zzdhx.listFiles();
                    n2 = ((File[])object).length;
                    for (n = 0; n < n2; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n5;
                    }
                    n4 = n5;
                }
                object2 = zzmq.zzbgq;
                if (n4 <= (Integer)zzbs.zzep().zzd(object2)) break block35;
                object2 = this;
                if (((zzalz)object2).zzdhx == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzalz)object2).zzdhx.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = super.zzc(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzafj.zzco((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        object2 = string2;
        zzjk.zzhx();
        String string3 = zzais.zzcl((String)object2);
        File file = new File(this.zzdhx, string3);
        File file4 = this.zzc(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzafj.zzbw((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzdhx.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzdhv;
        synchronized (object3) {
            if (zzdhv.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzafj.zzco((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzdhv.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            zzbs.zzeq();
            object2 = zzmq.zzbgv;
            HttpURLConnection httpURLConnection = zzajz.zzb(string2, zzbs.zzep().zzd(object2));
            if (httpURLConnection instanceof HttpURLConnection && (n8 = httpURLConnection.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string11 = String.valueOf(Integer.toString(n8));
                string10 = string11.length() != 0 ? "HTTP request failed. Code: ".concat(string11) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection.getContentLength();
            if (n8 < 0) {
                String string12 = String.valueOf(string2);
                zzafj.zzco((String)(string12.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string12) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzdhv.remove(string7);
                return false;
            }
            String string13 = zzdhw.format(n8);
            object2 = zzmq.zzbgr;
            int n9 = zzbs.zzep().zzd(object2);
            if (n8 > n9) {
                zzafj.zzco((String)new StringBuilder(33 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Content length ").append(string13).append(" exceeds limit at ").append(string2).toString());
                String string14 = String.valueOf(string13);
                String string15 = string14.length() != 0 ? "File too big for full file cache. Size: ".concat(string14) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string15);
                zzdhv.remove(string7);
                return false;
            }
            zzafj.zzbw((String)new StringBuilder(20 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Caching ").append(string13).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzd zzd2 = zzbs.zzei();
            int n10 = 0;
            long l = zzd2.currentTimeMillis();
            object2 = zzmq.zzbgu;
            long l3 = (Long)((Object)zzbs.zzep().zzd(object2));
            zzail zzail2 = new zzail(l3);
            object2 = zzmq.zzbgt;
            long l4 = (Long)((Object)zzbs.zzep().zzd(object2));
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n10 += n7) > n9) {
                    string9 = "sizeExceeded";
                    String string16 = String.valueOf(Integer.toString(n10));
                    string10 = string16.length() != 0 ? "File too big for full file cache. Size: ".concat(string16) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (zzd2.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string17 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string17).length()).append("Timeout exceeded. Limit: ").append(string17).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzdhy) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzail2.tryAcquire()) continue;
                n = n8;
                n2 = n10;
                object = file.getAbsolutePath();
                String string18 = string2;
                object2 = this;
                zzais.zzdbs.post((Runnable)new zzalu((zzalt)object2, string18, (String)object, n2, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzafj.zzae((int)3)) {
                String string19 = zzdhw.format(n10);
                zzafj.zzbw((String)new StringBuilder(22 + String.valueOf(string19).length() + String.valueOf(string2).length()).append("Preloaded ").append(string19).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n10);
            zzdhv.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzbs.zzeg().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzdhy) {
                zzafj.zzcn((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzafj.zzc((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string20 = String.valueOf(file.getAbsolutePath());
                zzafj.zzco((String)(string20.length() != 0 ? "Could not delete partial cache file at ".concat(string20) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzdhv.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzdhy = true;
    }

    private final File zzc(File file) {
        return new File(this.zzdhx, String.valueOf(file.getName()).concat(".done"));
    }
}

