/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdos;
import com.google.android.gms.internal.zzdou;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdre;
import com.google.android.gms.internal.zzdrg;
import com.google.android.gms.internal.zzdri;
import com.google.android.gms.internal.zzdrk;
import com.google.android.gms.internal.zzdtc;
import com.google.android.gms.internal.zzdtd;
import com.google.android.gms.internal.zzdte;
import com.google.android.gms.internal.zzfdp;
import com.google.android.gms.internal.zzffe;
import com.google.android.gms.internal.zzffq;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

public final class zzdpn
implements zzdos<zzdou> {
    zzdpn() {
    }

    private final zzdou zzg(zzfdp zzfdp2) throws GeneralSecurityException {
        try {
            zzdtc zzdtc2;
            zzdre zzdre2;
            zzdre zzdre3;
            zzdre zzdre4 = zzdre3 = zzdre.zzw(zzfdp2);
            zzdre zzdre5 = zzdre3;
            if (!(zzdre3 instanceof zzdre)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdre zzdre6 = zzdre2 = zzdre5;
            zzdte.zzt(zzdre2.getVersion(), 0);
            if (zzdre6.zzblu().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdpn.zza(zzdre6.zzbnj());
            zzdrc zzdrc2 = zzdre2.zzbnj().zzbnp();
            byte[] byArray = zzdre2.zzblu().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzdre2.zzbnj().zzbnq();
            switch (zzdrc2) {
                case zzlsm: {
                    zzdtc2 = new zzdtc("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzlso: {
                    zzdtc2 = new zzdtc("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzlsp: {
                    zzdtc2 = new zzdtc("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdtc2;
        }
        catch (zzffe zzffe2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzffe2);
        }
    }

    @Override
    public final zzffq zzb(zzfdp zzfdp2) throws GeneralSecurityException {
        try {
            zzdrg zzdrg2 = zzdrg.zzy(zzfdp2);
            return this.zzb((zzffq)zzdrg2);
        }
        catch (zzffe zzffe2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzffe2);
        }
    }

    @Override
    public final zzffq zzb(zzffq zzffq2) throws GeneralSecurityException {
        zzdrg zzdrg2;
        if (!(zzffq2 instanceof zzdrg)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdrg zzdrg3 = zzdrg2 = (zzdrg)zzffq2;
        if (zzdrg2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdpn.zza(zzdrg3.zzbnj());
        return zzdre.zzbnk().zzfr(0).zzc(zzdrg2.zzbnj()).zzx(zzfdp.zzay((byte[])zzdtd.zzgc(zzdrg2.getKeySize()))).zzcvl();
    }

    @Override
    public final zzdrk zzc(zzfdp zzfdp2) throws GeneralSecurityException {
        zzdre zzdre2 = (zzdre)this.zzb(zzfdp2);
        return (zzdrk)zzdrk.zzbnw().zzob("type.googleapis.com/google.crypto.tink.HmacKey").zzaa(zzdre2.toByteString()).zzb(zzdrk.zzb.zzltd).zzcvl();
    }

    @Override
    public final String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacKey";
    }

    private static void zza(zzdri zzdri2) throws GeneralSecurityException {
        if (zzdri2.zzbnq() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzdri2.zzbnp()) {
            case zzlsm: {
                if (zzdri2.zzbnq() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlso: {
                if (zzdri2.zzbnq() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlsp: {
                if (zzdri2.zzbnq() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzffq zzffq2) throws GeneralSecurityException {
        zzdre zzdre2;
        zzffq zzffq3 = zzffq2;
        if (!(zzffq3 instanceof zzdre)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdre zzdre3 = zzdre2 = (zzdre)zzffq3;
        zzdte.zzt(zzdre2.getVersion(), 0);
        if (zzdre3.zzblu().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdpn.zza(zzdre3.zzbnj());
        zzdrc zzdrc2 = zzdre2.zzbnj().zzbnp();
        byte[] byArray = zzdre2.zzblu().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzdre2.zzbnj().zzbnq();
        switch (zzdrc2) {
            case zzlsm: {
                return new zzdtc("HMACSHA1", secretKeySpec, n);
            }
            case zzlso: {
                return new zzdtc("HMACSHA256", secretKeySpec, n);
            }
            case zzlsp: {
                return new zzdtc("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzfdp zzfdp2) throws GeneralSecurityException {
        return this.zzg(zzfdp2);
    }
}

