/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzyz;
import com.google.android.gms.internal.zzzb;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
@TargetApi(value=14)
public final class zzgt
extends Thread {
    private boolean mStarted = false;
    private boolean zzayj = false;
    private boolean zzbk = false;
    private final Object mLock;
    private final zzgo zzayk;
    private final zzyz zzayl;
    private final int zzaym;
    private final int zzaxi;
    private final int zzayn;
    private final int zzaxk;
    private final int zzayo;
    private final int zzayp;
    private final int zzayq;
    private final int zzayr;
    private final String zzays;
    private final boolean zzayt;

    public zzgt(zzgo zzgo2, zzyz zzyz2) {
        this.zzayk = zzgo2;
        this.zzayl = zzyz2;
        this.mLock = new Object();
        zzmg<Object> zzmg2 = zzmq.zzbib;
        this.zzaxi = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbic;
        this.zzayn = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbid;
        this.zzaxk = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbie;
        this.zzayo = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbih;
        this.zzayp = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbij;
        this.zzayq = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbik;
        this.zzayr = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbif;
        this.zzaym = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbim;
        this.zzays = (String)((Object)zzbs.zzep().zzd(zzmg2));
        zzmg2 = zzmq.zzbio;
        this.zzayt = (Boolean)((Object)zzbs.zzep().zzd(zzmg2));
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgq() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzafj.zzbw((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgt.zzgr()) {
                    object = zzbs.zzef().getActivity();
                    if (object == null) {
                        zzafj.zzbw((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgt();
                    } else {
                        Activity activity = object;
                        zzgt zzgt2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbs.zzeg().zza(exception, "ContentFetchTask.extractContent");
                                zzafj.zzbw((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgt zzgt3 = zzgt2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzgu(zzgt3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzafj.zzbw((String)"ContentFetchTask: sleeping");
                    this.zzgt();
                }
                Thread.sleep(this.zzaym * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzafj.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzayl.zza((Throwable)exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzayj) {
                    try {
                        zzafj.zzbw((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzf(View view) {
        try {
            zzgn zzgn2 = new zzgn(this.zzaxi, this.zzayn, this.zzaxk, this.zzayo, this.zzayp, this.zzayq, this.zzayr);
            zzgx zzgx2 = this.zza(view, zzgn2);
            zzgn2.zzgn();
            if (zzgx2.zzazb == 0 && zzgx2.zzazc == 0) {
                return;
            }
            if (zzgx2.zzazc == 0 && zzgn2.zzgo() == 0) {
                return;
            }
            if (zzgx2.zzazc == 0 && this.zzayk.zza(zzgn2)) {
                return;
            }
            this.zzayk.zzc(zzgn2);
            return;
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzayl.zza((Throwable)exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzgr() {
        try {
            Context context = zzbs.zzef().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbs.zzeg().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzgx zza(@Nullable View view, zzgn zzgn2) {
        Object object;
        if (view == null) {
            return new zzgx(this, 0, 0);
        }
        Context context = zzbs.zzef().getContext();
        if (context != null) {
            object = zzmq.zzbil;
            int n = context.getResources().getIdentifier(zzbs.zzep().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzays) && string2 != null && string2.equals(this.zzays)) {
                return new zzgx(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzgn2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzgx(this, 1, 0);
            }
            return new zzgx(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzama)) {
            boolean bl2;
            zzgn2.zzgm();
            zzgn zzgn3 = zzgn2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzq.zzama()) {
                bl2 = false;
            } else {
                zzgn3.zzgm();
                webView.post((Runnable)new zzgv((zzgt)object, zzgn3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzgx(this, 0, 1);
            }
            return new zzgx(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzgx zzgx2 = this.zza(viewGroup.getChildAt(i), zzgn2);
                n += zzgx2.zzazb;
                n2 += zzgx2.zzazc;
            }
            return new zzgx(this, n, n2);
        }
        return new zzgx(this, 0, 0);
    }

    final void zza(zzgn zzgn2, WebView webView, String string2, boolean bl) {
        zzgn2.zzgl();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzayt && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzgn2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgn2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgn2.zzgg()) {
                this.zzayk.zzb(zzgn2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzafj.zzbw((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzafj.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzayl.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgn zzgs() {
        return this.zzayk.zzgp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzayj = false;
            this.mLock.notifyAll();
            zzafj.zzbw((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgt() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzayj = true;
            zzafj.zzbw((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzgu() {
        return this.zzayj;
    }
}

