/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzwh;
import com.google.android.gms.internal.zzzb;
import java.util.Map;
import java.util.Set;

@zzzb
public final class zzvw
extends zzwg {
    private static Set<String> zzcev = zze.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzcew = "top-right";
    private boolean zzcex = true;
    private int zzcey = 0;
    private int zzcez = 0;
    private int zzakx = -1;
    private int zzcfa = 0;
    private int zzcfb = 0;
    private int zzakw = -1;
    private final Object mLock = new Object();
    private final zzama zzbwq;
    private final Activity zzcem;
    private zzanp zzcfc;
    private ImageView zzcfd;
    private LinearLayout zzcfe;
    private zzwh zzcff;
    private PopupWindow zzcfg;
    private RelativeLayout zzcfh;
    private ViewGroup zzcfi;

    public zzvw(zzama zzama2, zzwh zzwh2) {
        super(zzama2, "resize");
        this.zzbwq = zzama2;
        this.zzcem = zzama2.zzrz();
        this.zzcff = zzwh2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzcem == null) {
                this.zzbl("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbwq.zzso() == null) {
                this.zzbl("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbwq.zzso().zztx()) {
                this.zzbl("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbwq.zzst()) {
                this.zzbl("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzvw zzvw2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbs.zzec();
                zzvw2.zzakw = zzagr.zzcd(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbs.zzec();
                zzvw2.zzakx = zzagr.zzcd(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbs.zzec();
                zzvw2.zzcfa = zzagr.zzcd(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbs.zzec();
                zzvw2.zzcfb = zzagr.zzcd(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzvw2.zzcex = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzvw2.zzcew = string2;
            }
            zzvw2 = this;
            if (!(zzvw2.zzakw >= 0 && zzvw2.zzakx >= 0)) {
                this.zzbl("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzcem.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbl("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmk();
            if (nArray == null) {
                this.zzbl("Resize location out of screen or close button is not visible.");
                return;
            }
            zzjk.zzhx();
            int n = zzais.zzc((Context)this.zzcem, (int)this.zzakw);
            zzjk.zzhx();
            int n2 = zzais.zzc((Context)this.zzcem, (int)this.zzakx);
            zzama zzama2 = this.zzbwq;
            if (zzama2 == null) {
                throw null;
            }
            ViewParent viewParent = ((View)zzama2).getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                zzama zzama3 = this.zzbwq;
                if (zzama3 == null) {
                    throw null;
                }
                ((ViewGroup)viewParent).removeView((View)zzama3);
                if (this.zzcfg == null) {
                    this.zzcfi = (ViewGroup)viewParent;
                    zzbs.zzec();
                    zzama zzama4 = this.zzbwq;
                    if (zzama4 == null) {
                        throw null;
                    }
                    bitmap = zzagr.zzm((View)zzama4);
                    this.zzcfd = new ImageView((Context)this.zzcem);
                    this.zzcfd.setImageBitmap(bitmap);
                    this.zzcfc = this.zzbwq.zzso();
                    this.zzcfi.addView((View)this.zzcfd);
                } else {
                    this.zzcfg.dismiss();
                }
            } else {
                this.zzbl("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzcfh = new RelativeLayout((Context)this.zzcem);
            this.zzcfh.setBackgroundColor(0);
            this.zzcfh.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbs.zzec();
            this.zzcfg = zzagr.zza((View)this.zzcfh, n, n2, false);
            this.zzcfg.setOutsideTouchable(true);
            this.zzcfg.setTouchable(true);
            this.zzcfg.setClippingEnabled(!this.zzcex);
            zzama zzama5 = this.zzbwq;
            if (zzama5 == null) {
                throw null;
            }
            this.zzcfh.addView((View)zzama5, -1, -1);
            this.zzcfe = new LinearLayout((Context)this.zzcem);
            zzjk.zzhx();
            int n3 = zzais.zzc((Context)this.zzcem, (int)50);
            zzjk.zzhx();
            bitmap = new RelativeLayout.LayoutParams(n3, zzais.zzc((Context)this.zzcem, (int)50));
            switch (this.zzcew) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzcfe.setOnClickListener((View.OnClickListener)new zzvx(this));
            this.zzcfe.setContentDescription((CharSequence)"Close button");
            this.zzcfh.addView((View)this.zzcfe, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzjk.zzhx();
                int n4 = zzais.zzc((Context)this.zzcem, (int)nArray[0]);
                zzjk.zzhx();
                this.zzcfg.showAtLocation(view, 0, n4, zzais.zzc((Context)this.zzcem, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbl(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                zzama zzama6 = this.zzbwq;
                if (zzama6 == null) {
                    throw null;
                }
                this.zzcfh.removeView((View)zzama6);
                if (this.zzcfi != null) {
                    this.zzcfi.removeView((View)this.zzcfd);
                    zzama zzama7 = this.zzbwq;
                    if (zzama7 == null) {
                        throw null;
                    }
                    this.zzcfi.addView((View)zzama7);
                    this.zzbwq.zza(this.zzcfc);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzvw2 = this;
            if (zzvw2.zzcff != null) {
                zzvw2.zzcff.zza(n6, n5, zzvw2.zzakw, zzvw2.zzakx);
            }
            this.zzbwq.zza(zzanp.zzi(n, n2));
            this.zza(nArray[0], nArray[1]);
            this.zzbn("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcfg != null) {
                this.zzcfg.dismiss();
                zzama zzama2 = this.zzbwq;
                if (zzama2 == null) {
                    throw null;
                }
                this.zzcfh.removeView((View)zzama2);
                if (this.zzcfi != null) {
                    this.zzcfi.removeView((View)this.zzcfd);
                    zzama zzama3 = this.zzbwq;
                    if (zzama3 == null) {
                        throw null;
                    }
                    this.zzcfi.addView((View)zzama3);
                    this.zzbwq.zza(this.zzcfc);
                }
                if (bl) {
                    this.zzbn("default");
                    if (this.zzcff != null) {
                        this.zzcff.zzco();
                    }
                }
                this.zzcfg = null;
                this.zzcfh = null;
                this.zzcfi = null;
                this.zzcfe = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzmk() {
        zzvw zzvw2 = this;
        int[] nArray = zzbs.zzec().zzg(zzvw2.zzcem);
        int[] nArray2 = zzbs.zzec().zzh(zzvw2.zzcem);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzvw2.zzakw < 50 || zzvw2.zzakw > n) {
            zzafj.zzco((String)"Width is too small or too large.");
            return null;
        }
        if (zzvw2.zzakx < 50 || zzvw2.zzakx > n2) {
            zzafj.zzco((String)"Height is too small or too large.");
            return null;
        }
        if (zzvw2.zzakx == n2 && zzvw2.zzakw == n) {
            zzafj.zzco((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzvw2.zzcex) {
            int n3;
            int n4;
            switch (zzvw2.zzcew) {
                case "top-left": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb;
                    break;
                }
                case "top-center": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa + zzvw2.zzakw / 2 - 25;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb;
                    break;
                }
                case "center": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa + zzvw2.zzakw / 2 - 25;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb + zzvw2.zzakx / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb + zzvw2.zzakx - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa + zzvw2.zzakw / 2 - 25;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb + zzvw2.zzakx - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa + zzvw2.zzakw - 50;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb + zzvw2.zzakx - 50;
                    break;
                }
                default: {
                    n4 = zzvw2.zzcey + zzvw2.zzcfa + zzvw2.zzakw - 50;
                    n3 = zzvw2.zzcez + zzvw2.zzcfb;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcex) {
            return new int[]{this.zzcey + this.zzcfa, this.zzcez + this.zzcfb};
        }
        int[] nArray3 = zzbs.zzec().zzg(this.zzcem);
        int[] nArray4 = zzbs.zzec().zzh(this.zzcem);
        int n5 = nArray3[0];
        int n6 = this.zzcey + this.zzcfa;
        int n7 = this.zzcez + this.zzcfb;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzakw > n5) {
            n6 = n5 - this.zzakw;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzakx <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzakx;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcey = n;
            this.zzcez = n2;
            if (this.zzcfg != null && bl) {
                int[] nArray = this.zzmk();
                if (nArray != null) {
                    zzjk.zzhx();
                    int n3 = zzais.zzc((Context)this.zzcem, (int)nArray[0]);
                    zzjk.zzhx();
                    this.zzcfg.update(n3, zzais.zzc((Context)this.zzcem, (int)nArray[1]), this.zzcfg.getWidth(), this.zzcfg.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzl(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbs.zzec().zzh(this.zzcem)[0];
        this.zzb(n, n2 - n3, this.zzakw, this.zzakx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzml() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcfg != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzcey = n;
        this.zzcez = n2;
    }
}

