/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzcaj;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzfhk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzda {
    private static final String TAG = zzda.class.getSimpleName();
    protected Context zzaif;
    private Context zzaig;
    private ExecutorService zzaih;
    private DexClassLoader zzaii;
    private zzcu zzaij;
    private byte[] zzaik;
    private volatile AdvertisingIdClient zzail = null;
    private volatile boolean zzahk = false;
    private Future zzaim = null;
    private volatile zzaw zzain = null;
    private Future zzaio = null;
    private zzcm zzaip;
    private boolean zzaiq = false;
    private boolean zzair = false;
    private Map<Pair<String, String>, zzea> zzais;
    private boolean zzait = false;
    private boolean zzaiu = true;
    private boolean zzaiv = false;

    public static zzda zza(Context context, String string2, String string3, boolean bl) {
        zzda zzda2 = new zzda(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzda zzda3 = zzda2;
            zzda2.zzaih = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object2 = zzda3;
            zzda3.zzahk = bl3;
            if (bl3) {
                ((zzda)object2).zzaim = ((zzda)object2).zzaih.submit(new zzdb((zzda)object2));
            }
            zzda zzda4 = zzda3;
            zzda4.zzaih.execute(new zzdd(zzda4));
            try {
                object = zze.zzafm();
                zzda4.zzaiq = zze.zzcd((Context)zzda4.zzaif) > 0;
                zzda4.zzair = object.isGooglePlayServicesAvailable(zzda4.zzaif) == 0;
            }
            catch (Throwable throwable) {}
            zzda3.zza(0, true);
            if (zzdf.zzas()) {
                object2 = zzmq.zzbmd;
                if (((Boolean)zzbs.zzep().zzd(object2)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzda4 = zzda3;
            zzda3.zzaij = new zzcu(null);
            try {
                zzda4.zzaik = zzda4.zzaij.zzk((String)object);
            }
            catch (zzcv zzcv2) {
                throw new zzcx(zzcv2);
            }
            object = string4;
            zzda4 = zzda3;
            try {
                String string6;
                File file = zzda4.zzaif.getCacheDir();
                if (file == null && (file = zzda4.zzaif.getDir("dex", 0)) == null) {
                    throw new zzcx();
                }
                String string7 = string6 = "1501670890290";
                File file2 = file;
                Object object3 = object;
                zzda zzda5 = zzda4;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzda5.zzaij.zzb(zzda5.zzaik, (String)object3);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzda4.zzb(file, string6);
                try {
                    zzda4.zzaii = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzda4.zzaif.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzda.zzb(file4);
                    zzda4.zza(file, string6);
                    zzda.zzl(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzda.zzb(file4);
                zzda4.zza(file, string6);
                zzda.zzl(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcx(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcx(iOException);
            }
            catch (zzcv zzcv3) {
                throw new zzcx(zzcv3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcx(nullPointerException);
            }
            object2 = zzda3;
            zzmg<Boolean> zzmg2 = zzmq.zzblx;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && !((zzda)object2).zzaiv && ((zzda)object2).zzaig != null) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                ((zzda)object2).zzaig.registerReceiver((BroadcastReceiver)new zza((zzda)object2, null), intentFilter);
                ((zzda)object2).zzaiv = true;
            }
            zzda3.zzaip = new zzcm(zzda3);
            zzda3.zzait = true;
        }
        catch (zzcx zzcx2) {}
        return zzda2;
    }

    public final Context getContext() {
        return this.zzaif;
    }

    public final boolean isInitialized() {
        return this.zzait;
    }

    public final Context getApplicationContext() {
        return this.zzaig;
    }

    public final ExecutorService zzae() {
        return this.zzaih;
    }

    public final DexClassLoader zzaf() {
        return this.zzaii;
    }

    public final zzcu zzag() {
        return this.zzaij;
    }

    public final byte[] zzah() {
        return this.zzaik;
    }

    public final boolean zzai() {
        return this.zzaiq;
    }

    public final zzcm zzaj() {
        return this.zzaip;
    }

    public final boolean zzak() {
        return this.zzair;
    }

    public final boolean zzal() {
        return this.zzaiu;
    }

    public final zzaw zzam() {
        return this.zzain;
    }

    public final Future zzan() {
        return this.zzaio;
    }

    private zzda(Context context) {
        this.zzaif = context;
        this.zzaig = context.getApplicationContext();
        this.zzais = new HashMap<Pair<String, String>, zzea>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzda.zzb(file2);
            return;
        }
        zzba zzba2 = new zzba();
        new zzba().zzgg = Build.VERSION.SDK.getBytes();
        zzba2.zzgf = string2.getBytes();
        byte[] byArray2 = this.zzaij.zzc(this.zzaik, byArray).getBytes();
        zzba2.data = byArray2;
        zzba2.zzge = zzbt.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzfhk.zzc((zzfhk)zzba2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzda.zzb(file2);
        return;
        catch (zzcv | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzda.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzda.zzb(file2);
            throw throwable;
        }
    }

    private static void zzl(String string2) {
        zzda.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzba zzba2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzda.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzda.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzba2 = (zzba)zzfhk.zza((zzfhk)new zzba(), (byte[])byArray2);
                if (string2.equals(new String(zzba2.zzgf)) && Arrays.equals(zzba2.zzge, zzbt.zzb(zzba2.data)) && Arrays.equals(zzba2.zzgg, Build.VERSION.SDK.getBytes())) break block30;
                zzda.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzaij.zzb(this.zzaik, new String(zzba2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcv | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzais.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzais.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzea(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzea zzea2 = this.zzais.get(new Pair((Object)string2, (Object)string3));
        if (zzea2 == null) {
            return null;
        }
        return zzea2.zzay();
    }

    private final void zzao() {
        try {
            if (this.zzail == null && this.zzaig != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaig);
                advertisingIdClient.start();
                this.zzail = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzail = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzair) {
            return;
        }
        Future<?> future = this.zzaih.submit(new zzdc(this, n, bl));
        if (n == 0) {
            this.zzaio = future;
        }
    }

    @VisibleForTesting
    final zzaw zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzap();
    }

    private static boolean zza(int n, zzaw zzaw2) {
        if (n < 4) {
            if (zzaw2 == null) {
                return true;
            }
            zzmg<Boolean> zzmg2 = zzmq.zzbmg;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && (zzaw2.zzcq == null || zzaw2.zzcq.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzmg2 = zzmq.zzbmh;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && (zzaw2.zzfb == null || zzaw2.zzfb.zzfz == null || zzaw2.zzfb.zzfz == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzaw zzap() {
        zzaw zzaw2 = null;
        try {
            PackageInfo packageInfo = this.zzaif.getPackageManager().getPackageInfo(this.zzaif.getPackageName(), 0);
            zzaw2 = zzcaj.zzn((Context)this.zzaif, (String)this.zzaif.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzaw2;
    }

    public final AdvertisingIdClient zzaq() {
        if (!this.zzahk) {
            return null;
        }
        if (this.zzail != null) {
            return this.zzail;
        }
        if (this.zzaim != null) {
            try {
                this.zzaim.get(2000L, TimeUnit.MILLISECONDS);
                this.zzaim = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzaim.cancel(true);
            }
        }
        return this.zzail;
    }

    public final int zzaa() {
        int n = Integer.MIN_VALUE;
        if (this.zzaip != null) {
            n = zzcm.zzaa();
        }
        return n;
    }

    static /* synthetic */ void zza(zzda zzda2) {
        zzda2.zzao();
    }

    static /* synthetic */ zzaw zza(zzda zzda2, zzaw zzaw2) {
        zzda2.zzain = zzaw2;
        return zzda2.zzain;
    }

    static /* synthetic */ boolean zzb(int n, zzaw zzaw2) {
        return zzda.zza(n, zzaw2);
    }

    final class zza
    extends BroadcastReceiver {
        private /* synthetic */ zzda zzaiw;

        private zza(zzda zzda2) {
            this.zzaiw = zzda2;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                this.zzaiw.zzaiu = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                this.zzaiw.zzaiu = false;
            }
        }

        /* synthetic */ zza(zzda zzda2, zzdb zzdb2) {
            this(zzda2);
        }
    }
}

