/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzabk;
import com.google.android.gms.internal.zzabl;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbfq;
import com.google.android.gms.internal.zzzv;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzzv
public final class zzabj
extends zzbfm {
    public static final Parcelable.Creator<zzabj> CREATOR = new zzabl();
    private ParcelFileDescriptor zzcpy;
    private Parcelable zzcpz;
    private boolean zzcqa;

    public zzabj(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcpy = parcelFileDescriptor;
        this.zzcpz = null;
        this.zzcqa = true;
    }

    public zzabj(zzbfq zzbfq2) {
        this.zzcpy = null;
        this.zzcpz = zzbfq2;
        this.zzcqa = false;
    }

    public final <T extends zzbfq> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcqa) {
            byte[] byArray;
            if (this.zzcpy == null) {
                zzagf.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcpy));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzagf.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                zzn.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcpz = (zzbfq)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcqa = false;
        }
        return (T)((zzbfq)this.zzcpz);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zznn();
        Parcel parcel2 = parcel;
        zzabj zzabj2 = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)zzabj2.zzcpy, (int)n, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zznn() {
        if (this.zzcpy == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzcpz.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzcpy = this.zze(byArray);
        }
        return this.zzcpy;
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzabk zzabk2 = new zzabk(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzabk2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzagf.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbs.zzem().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzn.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

