/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.gmsg.HttpClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.gmsg.zzy;
import com.google.android.gms.ads.internal.js.zzaa;
import com.google.android.gms.ads.internal.js.zzc;
import com.google.android.gms.ads.internal.js.zzn;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzaat;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzabp;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzabt;
import com.google.android.gms.internal.zzabu;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzabw;
import com.google.android.gms.internal.zzabz;
import com.google.android.gms.internal.zzacg;
import com.google.android.gms.internal.zzaco;
import com.google.android.gms.internal.zzafp;
import com.google.android.gms.internal.zzagb;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzx;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
public final class zzabo
extends zzagb {
    private static long zzcqh = TimeUnit.SECONDS.toMillis(10L);
    private static final Object sLock = new Object();
    private static boolean zzcqi = false;
    private static zzn zzclt = null;
    private static HttpClient zzcqj = null;
    private static zzy zzcqk = null;
    private static zzt<Object> zzcql = null;
    private final zzzx zzcmm;
    private final zzaau zzcmn;
    private final Object zzcjn = new Object();
    private final Context mContext;
    private zzaa zzcqm;
    private zzix zzcmp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzabo(Context context, zzaau zzaau2, zzzx zzzx2, zzix zzix2) {
        super(true);
        this.zzcmm = zzzx2;
        this.mContext = context;
        this.zzcmn = zzaau2;
        this.zzcmp = zzix2;
        Object object = sLock;
        synchronized (object) {
            if (!zzcqi) {
                zzcqk = new zzy();
                zzcqj = new HttpClient(context.getApplicationContext(), zzaau2.zzaty);
                zzcql = new zzabw();
                zzmx zzmx2 = zznh.zzbhm;
                zzclt = new zzn(this.mContext.getApplicationContext(), this.zzcmn.zzaty, (String)zzkb.zzif().zzd(zzmx2), new zzabv(), new zzabu());
                zzcqi = true;
            }
            return;
        }
    }

    protected static void zza(zzc zzc2) {
        zzc2.zza("/loadAd", zzcqk);
        zzc2.zza("/fetchHttpRequest", zzcqj);
        zzc2.zza("/invalidRequest", zzcql);
    }

    protected static void zzb(zzc zzc2) {
        zzc2.zzb("/loadAd", zzcqk);
        zzc2.zzb("/fetchHttpRequest", zzcqj);
        zzc2.zzb("/invalidRequest", zzcql);
    }

    @Override
    public final void zzdm() {
        zzagf.zzbx((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzbs.zzfd().zzy(this.mContext);
        zzaat zzaat2 = new zzaat(this.zzcmn, -1L, zzbs.zzfd().zzw(this.mContext), zzbs.zzfd().zzx(this.mContext), string2);
        zzbs.zzfd().zzg(this.mContext, string2);
        zzaax zzaax2 = this.zzc(zzaat2);
        long l = zzbs.zzeo().elapsedRealtime();
        zzafp zzafp2 = new zzafp(zzaat2, zzaax2, null, null, zzaax2.errorCode, l, zzaax2.zzcpa, null, this.zzcmp);
        zzajr.zzajw.post((Runnable)new zzabp(this, zzafp2));
    }

    private final zzaax zzc(zzaat zzaat2) {
        JSONObject jSONObject;
        zzbs.zzei();
        String string2 = zzahn.zzqb();
        JSONObject jSONObject2 = this.zza(zzaat2, string2);
        if (jSONObject2 == null) {
            return new zzaax(0);
        }
        long l = zzbs.zzeo().elapsedRealtime();
        Future<JSONObject> future = zzcqk.zzas(string2);
        zzajr.zzajw.post((Runnable)new zzabq(this, jSONObject2, string2));
        long l2 = zzcqh - (zzbs.zzeo().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzaax(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzaax(2);
        }
        catch (ExecutionException executionException) {
            return new zzaax(0);
        }
        if (jSONObject == null) {
            return new zzaax(-1);
        }
        zzaax zzaax2 = zzacg.zza(this.mContext, zzaat2, jSONObject.toString());
        if (zzaax2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzaax2.body)) {
            return new zzaax(3);
        }
        return zzaax2;
    }

    private final JSONObject zza(zzaat zzaat2, String string2) {
        Bundle bundle = zzaat2.zzcnd.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzaco zzaco2 = null;
        try {
            zzaco2 = zzbs.zzes().zzo(this.mContext).get();
        }
        catch (Exception exception) {
            zzagf.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        Object object = zzaat2;
        zzabz zzabz2 = new zzabz();
        new zzabz().zzcqv = object;
        object = zzaco2;
        v0.zzcqw = object;
        JSONObject jSONObject = zzacg.zza(this.mContext, zzabz2);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzagf.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzbs.zzei().zzq(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzcjn;
        synchronized (object) {
            zzajr.zzajw.post((Runnable)new zzabt(this));
            return;
        }
    }

    static /* synthetic */ zzy zzno() {
        return zzcqk;
    }

    static /* synthetic */ zzzx zza(zzabo zzabo2) {
        return zzabo2.zzcmm;
    }

    static /* synthetic */ zzaa zzb(zzabo zzabo2) {
        return zzabo2.zzcqm;
    }

    static /* synthetic */ zzaa zza(zzabo zzabo2, zzaa zzaa2) {
        zzabo2.zzcqm = zzaa2;
        return zzabo2.zzcqm;
    }

    static /* synthetic */ zzn zznp() {
        return zzclt;
    }
}

