/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzamf;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzzv;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzv
public final class zzamd
extends FrameLayout
implements zzama {
    private final zzamp zzdgr;
    private final FrameLayout zzdgs;
    private final zznu zzdgt;
    private final zzamr zzdgu;
    private final long zzdgv;
    @Nullable
    private zzamb zzdgw;
    private boolean zzdgx;
    private boolean zzdgy;
    private boolean zzdgz;
    private boolean zzdha;
    private long zzdhb;
    private long zzdhc;
    private String zzdhd;
    private Bitmap zzdhe;
    private ImageView zzdhf;
    private boolean zzdhg;

    public static void zza(zzamp zzamp2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzamp2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzamp zzamp2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzamp2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzamp zzamp2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzamp2.zza("onVideoEvent", hashMap);
    }

    public zzamd(Context context, zzamp zzamp2, int n, boolean bl, zznu zznu2, zzamo zzamo2) {
        super(context);
        zzmx zzmx2;
        this.zzdgr = zzamp2;
        this.zzdgt = zznu2;
        this.zzdgs = new FrameLayout(context);
        this.addView((View)this.zzdgs, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzv((Object)zzamp2.zzbq());
        this.zzdgw = zzamp2.zzbq().zzaom.zza(context, zzamp2, n, bl, zznu2, zzamo2);
        if (this.zzdgw != null) {
            this.zzdgs.addView((View)this.zzdgw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzmx2 = zznh.zzbin;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                this.zzrw();
            }
        }
        this.zzdhf = new ImageView(context);
        zzmx2 = zznh.zzbir;
        this.zzdgv = (Long)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbip;
        this.zzdha = (Boolean)zzkb.zzif().zzd(zzmx2);
        if (this.zzdgt != null) {
            this.zzdgt.zzf("spinner_used", this.zzdha ? "1" : "0");
        }
        this.zzdgu = new zzamr(this);
        if (this.zzdgw != null) {
            this.zzdgw.zza(this);
        }
        if (this.zzdgw == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzdgs.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzcv(String string2) {
        this.zzdhd = string2;
    }

    public final void zza(float f, float f2) {
        if (this.zzdgw != null) {
            this.zzdgw.zza(f, f2);
        }
    }

    public final void zzrt() {
        if (this.zzdgw == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzdhd)) {
            this.zzdgw.setVideoPath(this.zzdhd);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzdgw == null) {
            return;
        }
        this.zzdgw.pause();
    }

    public final void play() {
        if (this.zzdgw == null) {
            return;
        }
        this.zzdgw.play();
    }

    public final void seekTo(int n) {
        if (this.zzdgw == null) {
            return;
        }
        this.zzdgw.seekTo(n);
    }

    public final void zzru() {
        if (this.zzdgw == null) {
            return;
        }
        zzamb zzamb2 = this.zzdgw;
        zzamb2.zzdgq.setMuted(true);
        zzamb2.zzrm();
    }

    public final void zzrv() {
        if (this.zzdgw == null) {
            return;
        }
        zzamb zzamb2 = this.zzdgw;
        zzamb2.zzdgq.setMuted(false);
        zzamb2.zzrm();
    }

    public final void zzb(float f) {
        if (this.zzdgw == null) {
            return;
        }
        float f2 = f;
        zzamb zzamb2 = this.zzdgw;
        zzamb2.zzdgq.zzb(f2);
        zzamb2.zzrm();
    }

    @TargetApi(value=14)
    public final void zzf(MotionEvent motionEvent) {
        if (this.zzdgw == null) {
            return;
        }
        this.zzdgw.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzrw() {
        if (this.zzdgw == null) {
            return;
        }
        Context context = this.zzdgw.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzdgw.zzri());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzdgs.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzdgs.bringChildToFront((View)textView);
    }

    @Override
    public final void zzrn() {
        this.zzdgu.resume();
        zzahn.zzdaw.post((Runnable)new zzame(this));
    }

    @Override
    public final void zzro() {
        if (this.zzdgw == null) {
            return;
        }
        if (this.zzdhc == 0L) {
            float f = (float)this.zzdgw.getDuration() / 1000.0f;
            int n = this.zzdgw.getVideoWidth();
            int n2 = this.zzdgw.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzrp() {
        zzamd zzamd2 = this;
        if (zzamd2.zzdgr.zzsi() != null && !zzamd2.zzdgy) {
            WindowManager.LayoutParams layoutParams = zzamd2.zzdgr.zzsi().getWindow().getAttributes();
            boolean bl = zzamd2.zzdgz = (layoutParams.flags & 0x80) != 0;
            if (!zzamd2.zzdgz) {
                zzamd2.zzdgr.zzsi().getWindow().addFlags(128);
                zzamd2.zzdgy = true;
            }
        }
        this.zzdgx = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzrz();
        this.zzdgx = false;
    }

    @Override
    public final void zzrq() {
        this.zza("ended", new String[0]);
        this.zzrz();
    }

    @Override
    public final void zzg(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzrr() {
        zzamd zzamd2 = this;
        if (zzamd2.zzdhg && zzamd2.zzdhe != null && !zzamd2.zzry()) {
            zzamd2.zzdhf.setImageBitmap(zzamd2.zzdhe);
            zzamd2.zzdhf.invalidate();
            zzamd2.zzdgs.addView((View)zzamd2.zzdhf, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzamd2.zzdgs.bringChildToFront((View)zzamd2.zzdhf);
        }
        this.zzdgu.pause();
        this.zzdhc = this.zzdhb;
        zzahn.zzdaw.post((Runnable)new zzamf(this));
    }

    public final void destroy() {
        this.zzdgu.pause();
        if (this.zzdgw != null) {
            this.zzdgw.stop();
        }
        this.zzrz();
    }

    final void zzrx() {
        if (this.zzdgw == null) {
            return;
        }
        long l = this.zzdgw.getCurrentPosition();
        if (this.zzdhb != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzdhb = l;
        }
    }

    @Override
    public final void zzrs() {
        zzamd zzamd2;
        if (this.zzdgx && (zzamd2 = this).zzry()) {
            zzamd2.zzdgs.removeView((View)zzamd2.zzdhf);
        }
        zzamd2 = this;
        if (zzamd2.zzdhe != null) {
            long l = zzbs.zzeo().elapsedRealtime();
            if (zzamd2.zzdgw.getBitmap(zzamd2.zzdhe) != null) {
                zzamd2.zzdhg = true;
            }
            long l2 = zzbs.zzeo().elapsedRealtime() - l;
            if (zzagf.zzpz()) {
                zzagf.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzamd2.zzdgv) {
                zzagf.zzcu((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzamd2.zzdha = false;
                zzamd2.zzdhe = null;
                if (zzamd2.zzdgt != null) {
                    zzamd2.zzdgt.zzf("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzf(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzamd zzamd2 = this;
        if (zzamd2.zzdha) {
            zzmx zzmx2 = zznh.zzbiq;
            n4 = Math.max(n4 / (Integer)zzkb.zzif().zzd(zzmx2), 1);
            zzmx2 = zznh.zzbiq;
            n3 = Math.max(n3 / (Integer)zzkb.zzif().zzd(zzmx2), 1);
            if (zzamd2.zzdhe == null || zzamd2.zzdhe.getWidth() != n4 || zzamd2.zzdhe.getHeight() != n3) {
                zzamd2.zzdhe = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzamd2.zzdhg = false;
            }
        }
    }

    private final boolean zzry() {
        return this.zzdhf.getParent() != null;
    }

    private final void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzdgr.zza("onVideoEvent", hashMap);
    }

    private final void zzrz() {
        if (this.zzdgr.zzsi() == null) {
            return;
        }
        if (this.zzdgy && !this.zzdgz) {
            this.zzdgr.zzsi().getWindow().clearFlags(128);
            this.zzdgy = false;
        }
    }

    static /* synthetic */ void zza(zzamd zzamd2, String string2, String[] stringArray) {
        zzamd2.zza(string2, stringArray);
    }
}

