/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdud;
import com.google.android.gms.internal.zzduf;
import com.google.android.gms.internal.zzdve;
import com.google.android.gms.internal.zzdvf;
import com.google.android.gms.internal.zzdvi;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public abstract class zzdub
implements zzdvf {
    private static final byte[] zzlyj = new byte[16];
    static final int[] zzlyk = zzdub.zza(ByteBuffer.wrap(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107}));
    final zzdve zzlyl;

    zzdub(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("The key length in bytes must be 32.");
        }
        this.zzlyl = zzdve.zzal(byArray);
    }

    static zzdub zzai(byte[] byArray) {
        return new zzdud(byArray, null);
    }

    static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    static int[] zza(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }

    final int[] zze(int[] nArray) {
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        this.zzf(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray2[n] = nArray2[n] + nArray[i];
        }
        return nArray2;
    }

    abstract void zzf(int[] var1);

    abstract int[] zzd(byte[] var1, int var2);

    abstract void zzg(int[] var1);

    abstract int zzbqi();

    abstract zzduf zzaj(byte[] var1);

    private static void zza(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, zzduf zzduf2) {
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer2.hasRemaining()) {
            int n = byteBuffer2.remaining() < 64 ? byteBuffer2.remaining() : 64;
            byteBuffer3.asIntBuffer().put(zzduf2.zzbqj());
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)(byteBuffer2.get() ^ byteBuffer3.get(i)));
            }
        }
    }

    @Override
    public final byte[] zzag(byte[] byArray) throws GeneralSecurityException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12 + byArray.length);
        this.zza(byteBuffer, byArray);
        return byteBuffer.array();
    }

    final void zza(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byArray.length > 0x7FFFFFF3) {
            throw new GeneralSecurityException("plaintext too long");
        }
        if (byteBuffer.remaining() < byArray.length + 12) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] byArray2 = zzdvi.zzgh(12);
        byteBuffer.put(byArray2);
        zzdub.zza(byteBuffer, ByteBuffer.wrap(byArray), this.zzaj(byArray2));
    }
}

