/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzv;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzzv
@TargetApi(value=14)
public final class zzgp
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzaxf;
    private final Context mApplicationContext;
    private Application zzaxg;
    private final WindowManager zzavx;
    private final PowerManager zzavy;
    private final KeyguardManager zzavz;
    @Nullable
    private BroadcastReceiver zzawh;
    private WeakReference<ViewTreeObserver> zzaxh;
    private WeakReference<View> zzaxi;
    private zzgu zzaxj;
    private zzaji zzavd = new zzaji(zzaxf);
    private boolean zzawg = false;
    private int zzaxk = -1;
    private HashSet<zzgt> zzaxl = new HashSet();
    private DisplayMetrics zzaxm;

    public zzgp(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzavx = (WindowManager)context.getSystemService("window");
        this.zzavy = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzavz = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzaxg = (Application)this.mApplicationContext;
            this.zzaxj = new zzgu((Application)this.mApplicationContext, this);
        }
        this.zzaxm = context.getResources().getDisplayMetrics();
        View view2 = view;
        zzgp zzgp2 = this;
        View view3 = zzgp2.zzaxi != null ? (View)zzgp2.zzaxi.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgp2);
            zzgp2.zzf(view3);
        }
        zzgp2.zzaxi = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbs.zzek().isAttachedToWindow(view2)) {
                zzgp2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgp2);
        }
    }

    public final void zza(zzgt zzgt2) {
        this.zzaxl.add(zzgt2);
        this.zzm(3);
    }

    public final void zzb(zzgt zzgt2) {
        this.zzaxl.remove(zzgt2);
    }

    private final void zzav() {
        zzbs.zzei();
        zzahn.zzdaw.post((Runnable)new zzgq(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzaxk = -1;
        this.zze(view);
        this.zzm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzaxk = -1;
        this.zzm(3);
        this.zzav();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzaxi == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzaxi.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzaxk = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzav();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzav();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzav();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzm(3);
        this.zzav();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzm(3);
        this.zzav();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzm(3);
        this.zzav();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzm(3);
        this.zzav();
    }

    public final void onGlobalLayout() {
        this.zzm(2);
        this.zzav();
    }

    public final void onScrollChanged() {
        this.zzm(1);
    }

    public final void zzgi() {
        this.zzm(4);
    }

    private final void zzm(int n) {
        boolean bl;
        if (this.zzaxl.size() == 0) {
            return;
        }
        if (this.zzaxi == null) {
            return;
        }
        View view = (View)this.zzaxi.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        new Rect().right = this.zzavx.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzavx.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzagf.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzaxk != -1 ? this.zzaxk : n2;
        boolean bl6 = bl = !bl3 && zzbs.zzei().zza(view, this.zzavy, this.zzavz) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzavd.tryAcquire() && bl == this.zzawg) {
            return;
        }
        if (!bl && !this.zzawg && n == 1) {
            return;
        }
        zzgs zzgs2 = new zzgs(zzbs.zzeo().elapsedRealtime(), this.zzavy.isScreenOn(), view != null ? zzbs.zzek().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzaxm.density, bl);
        Iterator<zzgt> iterator = this.zzaxl.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgs2);
        }
        this.zzawg = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzn(rect.left), this.zzn(rect.top), this.zzn(rect.right), this.zzn(rect.bottom));
    }

    private final int zzn(int n) {
        float f = this.zzaxm.density;
        return (int)((float)n / f);
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzaxh = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzgp zzgp2 = this;
        if (zzgp2.zzawh == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzgp2.zzawh = new zzgr(zzgp2);
            zzbs.zzfg().zza(zzgp2.mApplicationContext, zzgp2.zzawh, intentFilter);
        }
        if (this.zzaxg != null) {
            try {
                this.zzaxg.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaxj);
                return;
            }
            catch (Exception exception) {
                zzagf.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzaxh != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzaxh.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzaxh = null;
            }
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzgp zzgp2 = this;
        if (zzgp2.zzawh != null) {
            try {
                zzbs.zzfg().zza(zzgp2.mApplicationContext, zzgp2.zzawh);
            }
            catch (IllegalStateException illegalStateException) {
                zzagf.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbs.zzem().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzgp2.zzawh = null;
        }
        if (this.zzaxg != null) {
            try {
                this.zzaxg.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaxj);
                return;
            }
            catch (Exception exception) {
                zzagf.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzgp zzgp2, int n) {
        zzgp2.zzm(3);
    }

    static {
        zzmx zzmx2 = zznh.zzbmp;
        zzaxf = (Long)zzkb.zzif().zzd(zzmx2);
    }
}

