/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.internal.zzui;
import com.google.android.gms.internal.zzuk;
import com.google.android.gms.internal.zzum;
import com.google.android.gms.internal.zzun;
import com.google.android.gms.internal.zzuo;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzux;
import com.google.android.gms.internal.zzva;
import com.google.android.gms.internal.zzvd;
import com.google.android.gms.internal.zzvg;
import com.google.android.gms.internal.zzvr;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.internal.zzzv;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
public final class zzul
implements zzup {
    private final String zzced;
    private final zzux zzanw;
    private final long zzcee;
    private final zzui zzcef;
    private final zzuh zzceg;
    private zzjj zzarx;
    private final zzjn zzasd;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzakd zzapr;
    private final boolean zzavp;
    private final zzpe zzapn;
    private final List<String> zzapo;
    private final List<String> zzceh;
    private final List<String> zzcei;
    private final boolean zzcej;
    private final boolean zzcek;
    private zzva zzcel;
    private int zzcem = -2;
    private zzvg zzcen;

    public zzul(Context context, String string2, zzux zzux2, zzui zzui2, zzuh zzuh2, zzjj zzjj2, zzjn zzjn2, zzakd zzakd2, boolean bl, boolean bl2, zzpe zzpe2, List<String> list, List<String> list2, List<String> list3, boolean bl3) {
        this.mContext = context;
        this.zzanw = zzux2;
        this.zzceg = zzuh2;
        this.zzced = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzlx() : string2;
        this.zzcef = zzui2;
        this.zzcee = zzuh2.zzcdi != -1L ? zzuh2.zzcdi : (zzui2.zzcdi != -1L ? zzui2.zzcdi : 10000L);
        this.zzarx = zzjj2;
        this.zzasd = zzjn2;
        this.zzapr = zzakd2;
        this.zzavp = bl;
        this.zzcej = bl2;
        this.zzapn = zzpe2;
        this.zzapo = list;
        this.zzceh = list2;
        this.zzcei = list3;
        this.zzcek = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzcel != null) {
                    this.zzcel.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzagf.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzcem = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzlx() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzceg.zzccu)) {
                if (this.zzanw.zzbh(this.zzceg.zzccu)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzagf.zzcu((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzv(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcem = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzvg zzvg2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcem = 0;
            this.zzcen = zzvg2;
            this.mLock.notify();
            return;
        }
    }

    private static zzva zza(MediationAdapter mediationAdapter) {
        return new zzvr(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzuo zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzuk zzuk2 = new zzuk();
            zzahn.zzdaw.post((Runnable)new zzum(this, zzuk2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzcee;
            zzul zzul2 = this;
            while (zzul2.zzcem == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzul zzul3 = zzul2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzagf.zzct((String)"Timed out waiting for adapter.");
                    zzul3.zzcem = 3;
                    continue;
                }
                try {
                    zzul3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzul3.zzcem = 5;
                }
            }
            long l14 = zzbs.zzeo().elapsedRealtime() - l3;
            return new zzuo(this.zzceg, this.zzcel, this.zzced, zzuk2, this.zzcem, this.zzly(), l14);
        }
    }

    private final zzvg zzly() {
        if (this.zzcem != 0 || !this.zzma()) {
            return null;
        }
        try {
            if (this.zzw(4) && this.zzcen != null && this.zzcen.zzmc() != 0) {
                return this.zzcen;
            }
        }
        catch (RemoteException remoteException) {
            zzagf.zzcu((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzmb();
        return new zzun(n);
    }

    private final zzva zzlz() {
        String string2 = String.valueOf(this.zzced);
        zzagf.zzct((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzavp && !this.zzceg.zzlw()) {
            zzmx zzmx2 = zznh.zzbne;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzced)) {
                return zzul.zza((MediationAdapter)new AdMobAdapter());
            }
            zzmx2 = zznh.zzbnf;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzced)) {
                return zzul.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzced)) {
                return new zzvr((MediationAdapter)new zzwl());
            }
        }
        try {
            return this.zzanw.zzbg(this.zzced);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzced);
            zzagf.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzuk zzuk2) {
        String string2 = this.zzbe(this.zzceg.zzccz);
        try {
            if (this.zzapr.zzdek < 4100000) {
                if (this.zzasd.zzbel) {
                    this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, (zzvd)zzuk2);
                    return;
                }
                this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, (zzvd)zzuk2);
                return;
            }
            if (this.zzavp || this.zzceg.zzlw()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzapo);
                if (this.zzceh != null) {
                    for (String string3 : this.zzceh) {
                        String string4 = ":false";
                        if (this.zzcei != null && this.zzcei.contains(string3)) {
                            string4 = ":true";
                        }
                        String string5 = string4;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("custom:").append(string3).append(string5).toString());
                    }
                }
                this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzceg.zzccq, (zzvd)zzuk2, this.zzapn, arrayList);
                return;
            }
            if (this.zzasd.zzbel) {
                this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzceg.zzccq, (zzvd)zzuk2);
                return;
            }
            if (this.zzcej) {
                if (this.zzceg.zzcdc != null) {
                    this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzceg.zzccq, (zzvd)zzuk2, new zzpe(zzul.zzbf(this.zzceg.zzcdg)), this.zzceg.zzcdf);
                    return;
                }
                this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, this.zzceg.zzccq, (zzvd)zzuk2);
                return;
            }
            this.zzcel.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, this.zzceg.zzccq, (zzvd)zzuk2);
            return;
        }
        catch (RemoteException remoteException) {
            zzagf.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzv(5);
            return;
        }
    }

    private final boolean zzw(int n) {
        Bundle bundle;
        try {
            bundle = this.zzavp ? this.zzcel.zzmh() : (this.zzasd.zzbel ? this.zzcel.getInterstitialAdapterInfo() : this.zzcel.zzmg());
        }
        catch (RemoteException remoteException) {
            zzagf.zzcu((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzma() {
        return this.zzcef.zzcdt != -1;
    }

    private final String zzbe(String string2) {
        if (string2 == null || !this.zzma() || this.zzw(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzagf.zzcu((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private final int zzmb() {
        JSONObject jSONObject;
        if (this.zzceg.zzccz == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzceg.zzccz);
        }
        catch (JSONException jSONException) {
            zzagf.zzcu((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzced)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzw(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbf(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string4 = string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string4) ? 2 : ("portrait".equals(string4) ? 1 : ("any".equals(string4) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzagf.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzul zzul2) {
        return zzul2.mLock;
    }

    static /* synthetic */ int zzb(zzul zzul2) {
        return zzul2.zzcem;
    }

    static /* synthetic */ zzva zza(zzul zzul2, zzva zzva2) {
        zzul2.zzcel = zzva2;
        return zzul2.zzcel;
    }

    static /* synthetic */ zzva zzc(zzul zzul2) {
        return zzul2.zzlz();
    }

    static /* synthetic */ zzva zzd(zzul zzul2) {
        return zzul2.zzcel;
    }

    static /* synthetic */ boolean zze(zzul zzul2) {
        return zzul2.zzma();
    }

    static /* synthetic */ boolean zza(zzul zzul2, int n) {
        return zzul2.zzw(1);
    }

    static /* synthetic */ String zzf(zzul zzul2) {
        return zzul2.zzced;
    }

    static /* synthetic */ void zza(zzul zzul2, zzuk zzuk2) {
        zzul2.zza(zzuk2);
    }
}

