/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzws;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzxc;
import com.google.android.gms.internal.zzzv;
import java.util.Map;
import java.util.Set;

@zzzv
public final class zzwr
extends zzxb {
    private static Set<String> zzcgk = zze.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzcgl = "top-right";
    private boolean zzcgm = true;
    private int zzcgn = 0;
    private int zzcgo = 0;
    private int zzalw = -1;
    private int zzcgp = 0;
    private int zzcgq = 0;
    private int zzalv = -1;
    private final Object mLock = new Object();
    private final zzanh zzbyk;
    private final Activity zzcgb;
    private zzapa zzcgr;
    private ImageView zzcgs;
    private LinearLayout zzcgt;
    private zzxc zzcgu;
    private PopupWindow zzcgv;
    private RelativeLayout zzcgw;
    private ViewGroup zzcgx;

    public zzwr(zzanh zzanh2, zzxc zzxc2) {
        super(zzanh2, "resize");
        this.zzbyk = zzanh2;
        this.zzcgb = zzanh2.zzsi();
        this.zzcgu = zzxc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzcgb == null) {
                this.zzbm("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbyk.zzsx() == null) {
                this.zzbm("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbyk.zzsx().zzuh()) {
                this.zzbm("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbyk.zztc()) {
                this.zzbm("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwr zzwr2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbs.zzei();
                zzwr2.zzalv = zzahn.zzce(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbs.zzei();
                zzwr2.zzalw = zzahn.zzce(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbs.zzei();
                zzwr2.zzcgp = zzahn.zzce(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbs.zzei();
                zzwr2.zzcgq = zzahn.zzce(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwr2.zzcgm = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwr2.zzcgl = string2;
            }
            zzwr2 = this;
            if (!(zzwr2.zzalv >= 0 && zzwr2.zzalw >= 0)) {
                this.zzbm("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzcgb.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbm("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmq();
            if (nArray == null) {
                this.zzbm("Resize location out of screen or close button is not visible.");
                return;
            }
            zzkb.zzia();
            int n = zzajr.zzc((Context)this.zzcgb, (int)this.zzalv);
            zzkb.zzia();
            int n2 = zzajr.zzc((Context)this.zzcgb, (int)this.zzalw);
            zzanh zzanh2 = this.zzbyk;
            if (zzanh2 == null) {
                throw null;
            }
            ViewParent viewParent = ((View)zzanh2).getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                zzanh zzanh3 = this.zzbyk;
                if (zzanh3 == null) {
                    throw null;
                }
                ((ViewGroup)viewParent).removeView((View)zzanh3);
                if (this.zzcgv == null) {
                    this.zzcgx = (ViewGroup)viewParent;
                    zzbs.zzei();
                    zzanh zzanh4 = this.zzbyk;
                    if (zzanh4 == null) {
                        throw null;
                    }
                    bitmap = zzahn.zzr((View)zzanh4);
                    this.zzcgs = new ImageView((Context)this.zzcgb);
                    this.zzcgs.setImageBitmap(bitmap);
                    this.zzcgr = this.zzbyk.zzsx();
                    this.zzcgx.addView((View)this.zzcgs);
                } else {
                    this.zzcgv.dismiss();
                }
            } else {
                this.zzbm("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzcgw = new RelativeLayout((Context)this.zzcgb);
            this.zzcgw.setBackgroundColor(0);
            this.zzcgw.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbs.zzei();
            this.zzcgv = zzahn.zza((View)this.zzcgw, n, n2, false);
            this.zzcgv.setOutsideTouchable(true);
            this.zzcgv.setTouchable(true);
            this.zzcgv.setClippingEnabled(!this.zzcgm);
            zzanh zzanh5 = this.zzbyk;
            if (zzanh5 == null) {
                throw null;
            }
            this.zzcgw.addView((View)zzanh5, -1, -1);
            this.zzcgt = new LinearLayout((Context)this.zzcgb);
            zzkb.zzia();
            int n3 = zzajr.zzc((Context)this.zzcgb, (int)50);
            zzkb.zzia();
            bitmap = new RelativeLayout.LayoutParams(n3, zzajr.zzc((Context)this.zzcgb, (int)50));
            switch (this.zzcgl) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzcgt.setOnClickListener((View.OnClickListener)new zzws(this));
            this.zzcgt.setContentDescription((CharSequence)"Close button");
            this.zzcgw.addView((View)this.zzcgt, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzkb.zzia();
                int n4 = zzajr.zzc((Context)this.zzcgb, (int)nArray[0]);
                zzkb.zzia();
                this.zzcgv.showAtLocation(view, 0, n4, zzajr.zzc((Context)this.zzcgb, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbm(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                zzanh zzanh6 = this.zzbyk;
                if (zzanh6 == null) {
                    throw null;
                }
                this.zzcgw.removeView((View)zzanh6);
                if (this.zzcgx != null) {
                    this.zzcgx.removeView((View)this.zzcgs);
                    zzanh zzanh7 = this.zzbyk;
                    if (zzanh7 == null) {
                        throw null;
                    }
                    this.zzcgx.addView((View)zzanh7);
                    this.zzbyk.zza(this.zzcgr);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwr2 = this;
            if (zzwr2.zzcgu != null) {
                zzwr2.zzcgu.zza(n6, n5, zzwr2.zzalv, zzwr2.zzalw);
            }
            this.zzbyk.zza(zzapa.zzi(n, n2));
            this.zza(nArray[0], nArray[1]);
            this.zzbo("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcgv != null) {
                this.zzcgv.dismiss();
                zzanh zzanh2 = this.zzbyk;
                if (zzanh2 == null) {
                    throw null;
                }
                this.zzcgw.removeView((View)zzanh2);
                if (this.zzcgx != null) {
                    this.zzcgx.removeView((View)this.zzcgs);
                    zzanh zzanh3 = this.zzbyk;
                    if (zzanh3 == null) {
                        throw null;
                    }
                    this.zzcgx.addView((View)zzanh3);
                    this.zzbyk.zza(this.zzcgr);
                }
                if (bl) {
                    this.zzbo("default");
                    if (this.zzcgu != null) {
                        this.zzcgu.zzcu();
                    }
                }
                this.zzcgv = null;
                this.zzcgw = null;
                this.zzcgx = null;
                this.zzcgt = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzmq() {
        zzwr zzwr2 = this;
        int[] nArray = zzbs.zzei().zzg(zzwr2.zzcgb);
        int[] nArray2 = zzbs.zzei().zzh(zzwr2.zzcgb);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwr2.zzalv < 50 || zzwr2.zzalv > n) {
            zzagf.zzcu((String)"Width is too small or too large.");
            return null;
        }
        if (zzwr2.zzalw < 50 || zzwr2.zzalw > n2) {
            zzagf.zzcu((String)"Height is too small or too large.");
            return null;
        }
        if (zzwr2.zzalw == n2 && zzwr2.zzalv == n) {
            zzagf.zzcu((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwr2.zzcgm) {
            int n3;
            int n4;
            switch (zzwr2.zzcgl) {
                case "top-left": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq;
                    break;
                }
                case "top-center": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp + zzwr2.zzalv / 2 - 25;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq;
                    break;
                }
                case "center": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp + zzwr2.zzalv / 2 - 25;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq + zzwr2.zzalw / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq + zzwr2.zzalw - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp + zzwr2.zzalv / 2 - 25;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq + zzwr2.zzalw - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp + zzwr2.zzalv - 50;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq + zzwr2.zzalw - 50;
                    break;
                }
                default: {
                    n4 = zzwr2.zzcgn + zzwr2.zzcgp + zzwr2.zzalv - 50;
                    n3 = zzwr2.zzcgo + zzwr2.zzcgq;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcgm) {
            return new int[]{this.zzcgn + this.zzcgp, this.zzcgo + this.zzcgq};
        }
        int[] nArray3 = zzbs.zzei().zzg(this.zzcgb);
        int[] nArray4 = zzbs.zzei().zzh(this.zzcgb);
        int n5 = nArray3[0];
        int n6 = this.zzcgn + this.zzcgp;
        int n7 = this.zzcgo + this.zzcgq;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzalv > n5) {
            n6 = n5 - this.zzalv;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzalw <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzalw;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcgn = n;
            this.zzcgo = n2;
            if (this.zzcgv != null && bl) {
                int[] nArray = this.zzmq();
                if (nArray != null) {
                    zzkb.zzia();
                    int n3 = zzajr.zzc((Context)this.zzcgb, (int)nArray[0]);
                    zzkb.zzia();
                    this.zzcgv.update(n3, zzajr.zzc((Context)this.zzcgb, (int)nArray[1]), this.zzcgv.getWidth(), this.zzcgv.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzl(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbs.zzei().zzh(this.zzcgb)[0];
        this.zzb(n, n2 - n3, this.zzalv, this.zzalw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzmr() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcgv != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzcgn = n;
        this.zzcgo = n2;
    }
}

