/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzamq;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzamp
extends zzamz
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzc = new HashMap<Integer, String>();
    private final zzano zzd;
    private final boolean zze;
    private int zzf = 0;
    private int zzg = 0;
    private MediaPlayer zzh;
    private Uri zzi;
    private int zzj;
    private int zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private zzanl zzo;
    private boolean zzp;
    private int zzq;
    private zzamy zzr;

    public zzamp(Context context, boolean bl, boolean bl2, zzanm zzanm2, zzano zzano2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzd = zzano2;
        this.zzp = bl;
        this.zze = bl2;
        this.zzd.zza(this);
    }

    @Override
    public final String zza() {
        String string2 = String.valueOf(this.zzp ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzamy zzamy2) {
        this.zzr = zzamy2;
    }

    @Override
    public final void zza(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzamp zzamp2 = this;
        zzin zzin2 = zzin.zza(uri);
        zzamp2.zzi = zzin2 == null ? uri : Uri.parse((String)zzin2.zza);
        zzamp2.zzq = 0;
        zzamp2.zzj();
        zzamp2.requestLayout();
        zzamp2.invalidate();
    }

    @Override
    public final void zzb() {
        zzahw.zza("AdMediaPlayerView stop");
        if (this.zzh != null) {
            this.zzh.stop();
            this.zzh.release();
            this.zzh = null;
            this.zzb(0);
            this.zzg = 0;
        }
        this.zzd.zzb();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzahw.zza(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzj = mediaPlayer.getVideoWidth();
        this.zzk = mediaPlayer.getVideoHeight();
        if (this.zzj != 0 && this.zzk != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzahw.zza("AdMediaPlayerView prepared");
        this.zzb(2);
        this.zzd.zza();
        zzaij.zza.post((Runnable)new zzamq(this));
        this.zzj = mediaPlayer.getVideoWidth();
        this.zzk = mediaPlayer.getVideoHeight();
        if (this.zzq != 0) {
            ((zzamz)this).zza(this.zzq);
        }
        this.zzk();
        int n = this.zzj;
        int n2 = this.zzk;
        zzahw.zzd((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzg == 3) {
            ((zzamz)this).zzc();
        }
        ((zzamz)this).zzi();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzahw.zza("AdMediaPlayerView completion");
        this.zzb(5);
        this.zzg = 5;
        zzaij.zza.post((Runnable)new zzamr(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzc.get(n);
        String string3 = zzc.get(n2);
        zzahw.zza(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzc.get(n);
        String string3 = zzc.get(n2);
        zzahw.zze((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzb(-1);
        this.zzg = -1;
        zzaij.zza.post((Runnable)new zzams(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzl = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzahw.zza("AdMediaPlayerView surface created");
        this.zzj();
        zzaij.zza.post((Runnable)new zzamt(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzahw.zza("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzg == 3;
        boolean bl3 = bl = this.zzj == n && this.zzk == n2;
        if (this.zzh != null && bl2 && bl) {
            if (this.zzq != 0) {
                ((zzamz)this).zza(this.zzq);
            }
            ((zzamz)this).zzc();
        }
        if (this.zzo != null) {
            this.zzo.zza(n, n2);
        }
        zzaij.zza.post((Runnable)new zzamu(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzahw.zza("AdMediaPlayerView surface destroyed");
        if (this.zzh != null && this.zzq == 0) {
            this.zzq = this.zzh.getCurrentPosition();
        }
        if (this.zzo != null) {
            this.zzo.zzb();
        }
        zzaij.zza.post((Runnable)new zzamv(this));
        this.zza(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzd.zzb(this);
        this.zza.zza(surfaceTexture, this.zzr);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzamp.getDefaultSize((int)this.zzj, (int)n);
        int n4 = zzamp.getDefaultSize((int)this.zzk, (int)n2);
        if (this.zzj > 0 && this.zzk > 0 && this.zzo == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzj * n4 < n3 * this.zzk) {
                    n3 = n4 * this.zzj / this.zzk;
                } else if (this.zzj * n4 > n3 * this.zzk) {
                    n4 = n3 * this.zzk / this.zzj;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzk / this.zzj;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzj / this.zzk;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzj;
                n4 = this.zzk;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzj / this.zzk;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzk / this.zzj;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzo != null) {
            this.zzo.zza(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzm > 0 && this.zzm != n3 || this.zzn > 0 && this.zzn != n4) {
                this.zzk();
            }
            this.zzm = n3;
            this.zzn = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzj() {
        zzahw.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzi == null || surfaceTexture == null) {
            return;
        }
        this.zza(false);
        try {
            Surface surface;
            zzbt.zzu();
            this.zzh = new MediaPlayer();
            this.zzh.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzh.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzh.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzh.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzh.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzh.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzl = 0;
            if (this.zzp) {
                this.zzo = new zzanl(this.getContext());
                this.zzo.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzo.start();
                surface = this.zzo.zzc();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzo.zzb();
                    this.zzo = null;
                }
            }
            this.zzh.setDataSource(this.getContext(), this.zzi);
            zzbt.zzv();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzh.setSurface(surface);
            this.zzh.setAudioStreamType(3);
            this.zzh.setScreenOnWhilePlaying(true);
            this.zzh.prepareAsync();
            this.zzb(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzi);
            zzahw.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzh, 1, 0);
            return;
        }
    }

    private final void zzk() {
        if (!this.zze) {
            return;
        }
        if (this.zzl() && this.zzh.getCurrentPosition() > 0 && this.zzg != 3) {
            zzahw.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzh.start();
            int n = this.zzh.getCurrentPosition();
            long l = zzbt.zzl().zza();
            while (this.zzl() && this.zzh.getCurrentPosition() == n && zzbt.zzl().zza() - l <= 250L) {
            }
            this.zzh.pause();
            ((zzamz)this).zzi();
        }
    }

    private final void zza(boolean bl) {
        zzahw.zza("AdMediaPlayerView release");
        if (this.zzo != null) {
            this.zzo.zzb();
            this.zzo = null;
        }
        if (this.zzh != null) {
            this.zzh.reset();
            this.zzh.release();
            this.zzh = null;
            this.zzb(0);
            if (bl) {
                this.zzg = 0;
                this.zzg = 0;
            }
        }
    }

    @Override
    public final void zzc() {
        zzahw.zza("AdMediaPlayerView play");
        if (this.zzl()) {
            this.zzh.start();
            this.zzb(3);
            this.zza.zza();
            zzaij.zza.post((Runnable)new zzamw(this));
        }
        this.zzg = 3;
    }

    @Override
    public final void zzd() {
        zzahw.zza("AdMediaPlayerView pause");
        if (this.zzl() && this.zzh.isPlaying()) {
            this.zzh.pause();
            this.zzb(4);
            zzaij.zza.post((Runnable)new zzamx(this));
        }
        this.zzg = 4;
    }

    @Override
    public final int zze() {
        if (this.zzl()) {
            return this.zzh.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzf() {
        if (this.zzl()) {
            return this.zzh.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void zza(int n) {
        zzahw.zza(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzl()) {
            this.zzh.seekTo(n);
            this.zzq = 0;
            return;
        }
        this.zzq = n;
    }

    private final boolean zzl() {
        return this.zzh != null && this.zzf != -1 && this.zzf != 0 && this.zzf != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzo != null) {
            this.zzo.zza(f, f2);
        }
    }

    @Override
    public final int zzg() {
        if (this.zzh != null) {
            return this.zzh.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int zzh() {
        if (this.zzh != null) {
            return this.zzh.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzi() {
        this.zza(this.zzb.zza());
    }

    private final void zza(float f) {
        if (this.zzh != null) {
            try {
                this.zzh.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzahw.zze((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzb(int n) {
        if (n == 3) {
            this.zzd.zzc();
            this.zzb.zzb();
        } else if (this.zzf == 3) {
            this.zzd.zzd();
            this.zzb.zzc();
        }
        this.zzf = n;
    }

    static /* synthetic */ zzamy zza(zzamp zzamp2) {
        return zzamp2.zzr;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzc.put(-1004, "MEDIA_ERROR_IO");
            zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzc.put(1, "MEDIA_ERROR_UNKNOWN");
        zzc.put(1, "MEDIA_INFO_UNKNOWN");
        zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzc.put(701, "MEDIA_INFO_BUFFERING_START");
        zzc.put(702, "MEDIA_INFO_BUFFERING_END");
        zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

