/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzfls;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdm {
    private static final String zzb = zzdm.class.getSimpleName();
    protected Context zza;
    private ExecutorService zzc;
    private DexClassLoader zzd;
    private zzcx zze;
    private byte[] zzf;
    private volatile AdvertisingIdClient zzg = null;
    private volatile boolean zzh = false;
    private Future zzi = null;
    private boolean zzj;
    private volatile zzba zzk = null;
    private Future zzl = null;
    private zzcp zzm;
    private boolean zzn = false;
    private boolean zzo = false;
    private Map<Pair<String, String>, zzes> zzp;
    private boolean zzq = false;
    private boolean zzr = true;
    private boolean zzs = false;

    public static zzdm zza(Context context, String string2, String string3, boolean bl) {
        zzdm zzdm2 = new zzdm(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdm zzdm3 = zzdm2;
            zzdm2.zzc = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            zzdm zzdm4 = zzdm3;
            zzdm3.zzh = bl3;
            if (bl3) {
                zzdm4.zzi = zzdm4.zzc.submit(new zzdn(zzdm4));
            }
            zzdm zzdm5 = zzdm3;
            zzdm5.zzc.execute(new zzdp(zzdm5));
            try {
                object = com.google.android.gms.common.zzf.zza();
                zzdm5.zzn = com.google.android.gms.common.zzf.zzd((Context)zzdm5.zza) > 0;
                zzdm5.zzo = object.isGooglePlayServicesAvailable(zzdm5.zza) == 0;
            }
            catch (Throwable throwable) {}
            zzdm3.zza(0, true);
            if (zzds.zza()) {
                zzdm4 = zzoi.zzef;
                if (((Boolean)zzlc.zzf().zza((zzny)zzdm4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdm5 = zzdm3;
            zzdm3.zze = new zzcx(null);
            try {
                zzdm5.zzf = zzdm5.zze.zza((String)object);
            }
            catch (zzcy zzcy2) {
                throw new zzdj(zzcy2);
            }
            object = string4;
            zzdm5 = zzdm3;
            try {
                String string6;
                File file = zzdm5.zza.getCacheDir();
                if (file == null && (file = zzdm5.zza.getDir("dex", 0)) == null) {
                    throw new zzdj();
                }
                String string7 = string6 = "1510898742191";
                File file2 = file;
                Object object2 = object;
                zzdm zzdm6 = zzdm5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdm6.zze.zza(zzdm6.zzf, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdm5.zzb(file, string6);
                try {
                    zzdm5.zzd = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdm5.zza.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdm.zza(file4);
                    zzdm5.zza(file, string6);
                    zzdm.zza(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdm.zza(file4);
                zzdm5.zza(file, string6);
                zzdm.zza(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzdj(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzdj(iOException);
            }
            catch (zzcy zzcy3) {
                throw new zzdj(zzcy3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzdj(nullPointerException);
            }
            zzdm4 = zzdm3;
            zzny zzny2 = zzoi.zzdx;
            if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue() && !zzdm4.zzs) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdm4.zza.registerReceiver((BroadcastReceiver)new zza(zzdm4, null), intentFilter);
                zzdm4.zzs = true;
            }
            zzdm3.zzm = new zzcp(zzdm3);
            zzdm3.zzq = true;
        }
        catch (zzdj zzdj2) {}
        return zzdm2;
    }

    public final Context zza() {
        return this.zza;
    }

    public final boolean zzb() {
        return this.zzq;
    }

    public final ExecutorService zzc() {
        return this.zzc;
    }

    public final DexClassLoader zzd() {
        return this.zzd;
    }

    public final zzcx zze() {
        return this.zze;
    }

    public final byte[] zzf() {
        return this.zzf;
    }

    public final boolean zzg() {
        return this.zzn;
    }

    public final zzcp zzh() {
        return this.zzm;
    }

    public final boolean zzi() {
        return this.zzo;
    }

    public final boolean zzj() {
        return this.zzr;
    }

    public final zzba zzk() {
        return this.zzk;
    }

    public final Future zzl() {
        return this.zzl;
    }

    private zzdm(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzj = context2 != null;
        this.zza = this.zzj ? context2 : context;
        this.zzp = new HashMap<Pair<String, String>, zzes>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdm.zza(file2);
            return;
        }
        zzbe zzbe2 = new zzbe();
        new zzbe().zzd = Build.VERSION.SDK.getBytes();
        zzbe2.zzc = string2.getBytes();
        byte[] byArray2 = this.zze.zza(this.zzf, byArray).getBytes();
        zzbe2.zza = byArray2;
        zzbe2.zzb = zzbx.zza(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzfls.zza((zzfls)zzbe2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdm.zza(file2);
        return;
        catch (zzcy | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zza(file2);
            throw throwable;
        }
    }

    private static void zza(String string2) {
        zzdm.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)zzb, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbe zzbe2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdm.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)zzb, (String)"Cannot read the cache data.");
                    zzdm.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbe2 = (zzbe)zzfls.zza((zzfls)new zzbe(), (byte[])byArray2);
                if (string2.equals(new String(zzbe2.zzc)) && Arrays.equals(zzbe2.zzb, zzbx.zza(zzbe2.zza)) && Arrays.equals(zzbe2.zzd, Build.VERSION.SDK.getBytes())) break block30;
                zzdm.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zze.zza(this.zzf, new String(zzbe2.zza));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcy | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzp.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzp.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzes(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzes zzes2 = this.zzp.get(new Pair((Object)string2, (Object)string3));
        if (zzes2 == null) {
            return null;
        }
        return zzes2.zza();
    }

    private final void zzo() {
        try {
            if (this.zzg == null && this.zzj) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zza);
                advertisingIdClient.start();
                this.zzg = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzg = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzo) {
            return;
        }
        Future<?> future = this.zzc.submit(new zzdo(this, n, bl));
        if (n == 0) {
            this.zzl = future;
        }
    }

    @VisibleForTesting
    final zzba zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzp();
    }

    private static boolean zzb(int n, zzba zzba2) {
        if (n < 4) {
            if (zzba2 == null) {
                return true;
            }
            zzny zzny2 = zzoi.zzei;
            if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue() && (zzba2.zzn == null || zzba2.zzn.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzny2 = zzoi.zzej;
            if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue() && (zzba2.zzaw == null || zzba2.zzaw.zza == null || zzba2.zzaw.zza == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzba zzp() {
        zzba zzba2 = null;
        try {
            PackageInfo packageInfo = this.zza.getPackageManager().getPackageInfo(this.zza.getPackageName(), 0);
            zzba2 = zzcda.zza((Context)this.zza, (String)this.zza.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzba2;
    }

    public final AdvertisingIdClient zzm() {
        if (!this.zzh) {
            return null;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        if (this.zzi != null) {
            try {
                this.zzi.get(2000L, TimeUnit.MILLISECONDS);
                this.zzi = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzi.cancel(true);
            }
        }
        return this.zzg;
    }

    public final int zzn() {
        int n = Integer.MIN_VALUE;
        if (this.zzm != null) {
            n = zzcp.zza();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdm zzdm2) {
        zzdm2.zzo();
    }

    static /* synthetic */ zzba zza(zzdm zzdm2, zzba zzba2) {
        zzdm2.zzk = zzba2;
        return zzdm2.zzk;
    }

    static /* synthetic */ boolean zza(int n, zzba zzba2) {
        return zzdm.zzb(n, zzba2);
    }

    final class zza
    extends BroadcastReceiver {
        private /* synthetic */ zzdm zza;

        private zza(zzdm zzdm2) {
            this.zza = zzdm2;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                this.zza.zzr = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                this.zza.zzr = false;
            }
        }

        /* synthetic */ zza(zzdm zzdm2, zzdn zzdn2) {
            this(zzdm2);
        }
    }
}

