/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzyb;
import com.google.android.gms.internal.zzyc;
import com.google.android.gms.internal.zzyn;
import java.util.Map;

@zzabh
@Hide
public final class zzya
extends zzyn {
    private final Map<String, String> zza;
    private final Context zzb;
    private String zzc;
    private long zzd;
    private long zze;
    private String zzf;
    private String zzg;

    public zzya(zzaof zzaof2, Map<String, String> map) {
        super(zzaof2, "createCalendarEvent");
        this.zza = map;
        this.zzb = zzaof2.zzd();
        zzya zzya2 = this;
        zzya2.zzc = zzya2.zzd("description");
        zzya2.zzf = zzya2.zzd("summary");
        zzya2.zzd = zzya2.zze("start_ticks");
        zzya2.zze = zzya2.zze("end_ticks");
        zzya2.zzg = zzya2.zzd("location");
    }

    private final String zzd(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zza.get(string2))) {
            return "";
        }
        return this.zza.get(string2);
    }

    private final long zze(String string2) {
        String string3 = this.zza.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void zza() {
        if (this.zzb == null) {
            this.zza("Activity context is not available.");
            return;
        }
        zzbt.zze();
        if (!zzaij.zzf(this.zzb).zzd()) {
            this.zza("This feature is not available on the device.");
            return;
        }
        zzbt.zze();
        AlertDialog.Builder builder = zzaij.zze(this.zzb);
        Resources resources = zzbt.zzi().zzh();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzyb(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzyc(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent zzb() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzc);
        intent.putExtra("eventLocation", this.zzg);
        intent.putExtra("description", this.zzf);
        if (this.zzd > -1L) {
            intent.putExtra("beginTime", this.zzd);
        }
        if (this.zze > -1L) {
            intent.putExtra("endTime", this.zze);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzya zzya2) {
        return zzya2.zzb;
    }
}

