/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaip;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyr;
import java.util.Collections;

@zzabh
@Hide
public class zzd
extends zzyr
implements zzw {
    private static int zzcmk = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity mActivity;
    AdOverlayInfoParcel zzcml;
    private zzaof zzcct;
    private zzi zzcmm;
    private zzo zzcmn;
    private boolean zzcmo = false;
    private FrameLayout zzcmp;
    private WebChromeClient.CustomViewCallback zzcmq;
    private boolean zzcmr = false;
    private boolean zzcms = false;
    private zzh zzcmt;
    private boolean zzcmu = false;
    int zzcmv = 0;
    private final Object zzcmw = new Object();
    private Runnable zzcmx;
    private boolean zzcmy;
    private boolean zzcmz;
    private boolean zzcna = false;
    private boolean zzcnb = false;
    private boolean zzcnc = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzcmv = 2;
        this.mActivity.finish();
    }

    public final void zzng() {
        if (this.zzcml != null && this.zzcmo) {
            this.setRequestedOrientation(this.zzcml.orientation);
        }
        if (this.zzcmp != null) {
            this.mActivity.setContentView((View)this.zzcmt);
            this.zzcmz = true;
            this.zzcmp.removeAllViews();
            this.zzcmp = null;
        }
        if (this.zzcmq != null) {
            this.zzcmq.onCustomViewHidden();
            this.zzcmq = null;
        }
        this.zzcmo = false;
    }

    @Override
    public final void zznh() {
        this.zzcmv = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzcmv = 0;
    }

    public final boolean zzni() {
        this.zzcmv = 0;
        if (this.zzcct == null) {
            return true;
        }
        boolean bl = this.zzcct.zzuf();
        if (!bl) {
            this.zzcct.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcmr = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcml = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzcml == null) {
                throw new zzg("Could not get info for ad overlay.");
            }
            if (this.zzcml.zzatz.zzdja > 7500000) {
                this.zzcmv = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcnc = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcms = this.zzcml.zzcnu != null ? this.zzcml.zzcnu.zzaqp : false;
            zzny zzny2 = zzoi.zzbrz;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && this.zzcms && this.zzcml.zzcnu.zzaqu != -1) {
                new zzj(this, null).zzqj();
            }
            if (bundle == null) {
                if (this.zzcml.zzcnl != null && this.zzcnc) {
                    this.zzcml.zzcnl.zzcg();
                }
                if (this.zzcml.zzcns != 1 && this.zzcml.zzcnk != null) {
                    this.zzcml.zzcnk.onAdClicked();
                }
            }
            this.zzcmt = new zzh((Context)this.mActivity, this.zzcml.zzcnt, this.zzcml.zzatz.zzcu);
            this.zzcmt.setId(1000);
            switch (this.zzcml.zzcns) {
                case 1: {
                    this.zzt(false);
                    return;
                }
                case 2: {
                    this.zzcmm = new zzi(this.zzcml.zzcnm);
                    this.zzt(false);
                    return;
                }
                case 3: {
                    this.zzt(true);
                    return;
                }
            }
            throw new zzg("Could not determine ad overlay type.");
        }
        catch (zzg zzg2) {
            zzahw.zzcz((String)zzg2.getMessage());
            this.zzcmv = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzny zzny2 = zzoi.zzbva;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            if (this.zzcct != null && !this.zzcct.isDestroyed()) {
                zzbt.zzen();
                zzaip.zzi(this.zzcct);
                return;
            }
            zzahw.zzcz((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzcml.zzcnl != null) {
            this.zzcml.zzcnl.onResume();
        }
        zzny zzny2 = zzoi.zzbva;
        if (!((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            if (this.zzcct != null && !this.zzcct.isDestroyed()) {
                zzbt.zzen();
                zzaip.zzi(this.zzcct);
                return;
            }
            zzahw.zzcz((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzng();
        if (this.zzcml.zzcnl != null) {
            this.zzcml.zzcnl.onPause();
        }
        zzny zzny2 = zzoi.zzbva;
        if (!(((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() || this.zzcct == null || this.mActivity.isFinishing() && this.zzcmm != null)) {
            zzbt.zzen();
            zzaip.zzh(this.zzcct);
        }
        this.zznk();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzk(IObjectWrapper iObjectWrapper) {
        zzny zzny2 = zzoi.zzbuz;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && zzs.isAtLeastN()) {
            Configuration configuration = (Configuration)zzn.zzy((IObjectWrapper)iObjectWrapper);
            zzbt.zzel();
            if (zzaij.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcmr);
    }

    public final void onStop() {
        zzny zzny2 = zzoi.zzbva;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && this.zzcct != null && (!this.mActivity.isFinishing() || this.zzcmm == null)) {
            zzbt.zzen();
            zzaip.zzh(this.zzcct);
        }
        this.zznk();
    }

    public final void onDestroy() {
        if (this.zzcct != null) {
            this.zzcmt.removeView(this.zzcct.getView());
        }
        this.zznk();
    }

    private final void zzs(boolean bl) {
        zzny zzny2 = zzoi.zzbvb;
        int n = (Integer)zzlc.zzio().zzd(zzny2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        this.zzcmn = new zzo((Context)this.mActivity, zzp2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzcml.zzcnp);
        this.zzcmt.addView((View)this.zzcmn, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzbd() {
        this.zzcmz = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzny zzny2 = zzoi.zzbpm;
        boolean bl4 = bl3 = (Boolean)zzlc.zzio().zzd(zzny2) != false && this.zzcml != null && this.zzcml.zzcnu != null && this.zzcml.zzcnu.zzaqw;
        if (bl && bl2 && bl3) {
            new zzyn(this.zzcct, "useCustomClose").zzbm("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzcmn != null) {
            this.zzcmn.zza(bl, bl2 && !bl3);
        }
    }

    public final void zznj() {
        this.zzcmt.removeView((View)this.zzcmn);
        this.zzs(true);
    }

    public final void setRequestedOrientation(int n) {
        zzny zzny2 = zzoi.zzbvx;
        if (this.mActivity.getApplicationInfo().targetSdkVersion >= (Integer)zzlc.zzio().zzd(zzny2)) {
            zzny2 = zzoi.zzbvy;
            if (this.mActivity.getApplicationInfo().targetSdkVersion <= (Integer)zzlc.zzio().zzd(zzny2)) {
                zzny2 = zzoi.zzbvz;
                if (Build.VERSION.SDK_INT >= (Integer)zzlc.zzio().zzd(zzny2)) {
                    zzny2 = zzoi.zzbwa;
                    if (Build.VERSION.SDK_INT <= (Integer)zzlc.zzio().zzd(zzny2)) {
                        return;
                    }
                }
            }
        }
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcmp = new FrameLayout((Context)this.mActivity);
        this.zzcmp.setBackgroundColor(-16777216);
        this.zzcmp.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcmp);
        this.zzcmz = true;
        this.zzcmq = customViewCallback;
        this.zzcmo = true;
    }

    private final void zzt(boolean bl) throws zzg {
        boolean bl2;
        zzny zzny2;
        Window window;
        if (!this.zzcmz) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzg("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (zzs.isAtLeastN()) {
            zzny2 = zzoi.zzbuz;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                zzbt.zzel();
                bl3 = zzaij.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzcml.zzcnu != null && this.zzcml.zzcnu.zzaqq;
        if ((!this.zzcms || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzny2 = zzoi.zzbpl;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && zzs.zzanv() && this.zzcml.zzcnu != null && this.zzcml.zzcnu.zzaqv) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        zzapu zzapu2 = this.zzcml.zzcnm != null ? this.zzcml.zzcnm.zzua() : null;
        boolean bl5 = zzapu2 != null ? zzapu2.zzfz() : false;
        this.zzcmu = false;
        if (bl5) {
            if (this.zzcml.orientation == zzbt.zzen().zzrg()) {
                this.zzcmu = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcml.orientation == zzbt.zzen().zzrh()) {
                this.zzcmu = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcmu;
        zzahw.zzby((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcml.orientation);
        if (zzbt.zzen().zza(window)) {
            zzahw.zzby((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcms) {
            this.zzcmt.setBackgroundColor(-16777216);
        } else {
            this.zzcmt.setBackgroundColor(zzcmk);
        }
        this.mActivity.setContentView((View)this.zzcmt);
        this.zzcmz = true;
        if (bl) {
            try {
                this.zzcct = zzbt.zzem().zza((Context)this.mActivity, this.zzcml.zzcnm != null ? this.zzcml.zzcnm.zzty() : null, this.zzcml.zzcnm != null ? this.zzcml.zzcnm.zztz() : null, true, bl5, null, this.zzcml.zzatz, null, null, this.zzcml.zzcnm != null ? this.zzcml.zzcnm.zzbo() : null, zziu.zzhp());
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzg("Could not obtain webview for the overlay.");
            }
            this.zzcct.zzua().zza(null, null, this.zzcml.zzcnn, this.zzcml.zzcnr, true, null, this.zzcml.zzcnm != null ? this.zzcml.zzcnm.zzua().zzun() : null, null, null);
            this.zzcct.zzua().zza(zze.zzcnd);
            if (this.zzcml.url != null) {
                this.zzcct.loadUrl(this.zzcml.url);
            } else if (this.zzcml.zzcnq != null) {
                this.zzcct.loadDataWithBaseURL(this.zzcml.zzcno, this.zzcml.zzcnq, "text/html", "UTF-8", null);
            } else {
                throw new zzg("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcml.zzcnm != null) {
                this.zzcml.zzcnm.zzb(this);
            }
        } else {
            this.zzcct = this.zzcml.zzcnm;
            this.zzcct.setContext((Context)this.mActivity);
        }
        this.zzcct.zza(this);
        ViewParent viewParent = this.zzcct.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzcct.getView());
        }
        if (this.zzcms) {
            this.zzcct.zzul();
        }
        this.zzcmt.addView(this.zzcct.getView(), -1, -1);
        if (!bl && !this.zzcmu) {
            this.zznn();
        }
        this.zzs(bl5);
        if (this.zzcct.zzub()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zznk() {
        if (!this.mActivity.isFinishing() || this.zzcna) {
            return;
        }
        this.zzcna = true;
        if (this.zzcct != null) {
            int n = this.zzcmv;
            this.zzcct.zzag(n);
            Object object = this.zzcmw;
            synchronized (object) {
                if (!this.zzcmy && this.zzcct.zzuh()) {
                    this.zzcmx = new zzf(this);
                    zzny zzny2 = zzoi.zzbpk;
                    zzaij.zzdfn.postDelayed(this.zzcmx, ((Long)zzlc.zzio().zzd(zzny2)).longValue());
                    return;
                }
            }
        }
        this.zznl();
    }

    final void zznl() {
        if (this.zzcnb) {
            return;
        }
        this.zzcnb = true;
        if (this.zzcct != null) {
            this.zzcmt.removeView(this.zzcct.getView());
            if (this.zzcmm != null) {
                this.zzcct.setContext(this.zzcmm.zzaiq);
                this.zzcct.zzah(false);
                this.zzcmm.parent.addView(this.zzcct.getView(), this.zzcmm.index, this.zzcmm.zzcng);
                this.zzcmm = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzcct.setContext(this.mActivity.getApplicationContext());
            }
            this.zzcct = null;
        }
        if (this.zzcml != null && this.zzcml.zzcnl != null) {
            this.zzcml.zzcnl.zzcf();
        }
    }

    public final void zznm() {
        if (this.zzcmu) {
            this.zzcmu = false;
            this.zznn();
        }
    }

    private final void zznn() {
        this.zzcct.zznn();
    }

    public final void zzno() {
        this.zzcmt.zzcnf = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zznp() {
        Object object = this.zzcmw;
        synchronized (object) {
            this.zzcmy = true;
            if (this.zzcmx != null) {
                zzaij.zzdfn.removeCallbacks(this.zzcmx);
                zzaij.zzdfn.post(this.zzcmx);
            }
            return;
        }
    }

    static final /* synthetic */ void zzb(zzaof zzaof2, boolean bl) {
        zzaof2.zznn();
    }
}

