/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzamq;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzamp
extends zzamz
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzdkj = new HashMap<Integer, String>();
    private final zzano zzdkk;
    private final boolean zzdkl;
    private int zzdkm = 0;
    private int zzdkn = 0;
    private MediaPlayer zzdko;
    private Uri zzdkp;
    private int zzdkq;
    private int zzdkr;
    private int zzdks;
    private int zzdkt;
    private int zzdku;
    private zzanl zzdkv;
    private boolean zzdkw;
    private int zzdkx;
    private zzamy zzdky;

    public zzamp(Context context, boolean bl, boolean bl2, zzanm zzanm2, zzano zzano2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzdkk = zzano2;
        this.zzdkw = bl;
        this.zzdkl = bl2;
        this.zzdkk.zza(this);
    }

    @Override
    public final String zzsj() {
        String string2 = String.valueOf(this.zzdkw ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzamy zzamy2) {
        this.zzdky = zzamy2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzamp zzamp2 = this;
        zzin zzin2 = zzin.zzd(uri);
        zzamp2.zzdkp = zzin2 == null ? uri : Uri.parse((String)zzin2.url);
        zzamp2.zzdkx = 0;
        zzamp2.zzsk();
        zzamp2.requestLayout();
        zzamp2.invalidate();
    }

    @Override
    public final void stop() {
        zzahw.v("AdMediaPlayerView stop");
        if (this.zzdko != null) {
            this.zzdko.stop();
            this.zzdko.release();
            this.zzdko = null;
            this.zzaf(0);
            this.zzdkn = 0;
        }
        this.zzdkk.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzahw.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzdkq = mediaPlayer.getVideoWidth();
        this.zzdkr = mediaPlayer.getVideoHeight();
        if (this.zzdkq != 0 && this.zzdkr != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzahw.v("AdMediaPlayerView prepared");
        this.zzaf(2);
        this.zzdkk.zzsp();
        zzaij.zzdfn.post((Runnable)new zzamq(this));
        this.zzdkq = mediaPlayer.getVideoWidth();
        this.zzdkr = mediaPlayer.getVideoHeight();
        if (this.zzdkx != 0) {
            ((zzamz)this).seekTo(this.zzdkx);
        }
        this.zzsl();
        int n = this.zzdkq;
        int n2 = this.zzdkr;
        zzahw.zzcy((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzdkn == 3) {
            ((zzamz)this).play();
        }
        ((zzamz)this).zzsn();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzahw.v("AdMediaPlayerView completion");
        this.zzaf(5);
        this.zzdkn = 5;
        zzaij.zzdfn.post((Runnable)new zzamr(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdkj.get(n);
        String string3 = zzdkj.get(n2);
        zzahw.v(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdkj.get(n);
        String string3 = zzdkj.get(n2);
        zzahw.zzcz((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzaf(-1);
        this.zzdkn = -1;
        zzaij.zzdfn.post((Runnable)new zzams(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzdks = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzahw.v("AdMediaPlayerView surface created");
        this.zzsk();
        zzaij.zzdfn.post((Runnable)new zzamt(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzahw.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzdkn == 3;
        boolean bl3 = bl = this.zzdkq == n && this.zzdkr == n2;
        if (this.zzdko != null && bl2 && bl) {
            if (this.zzdkx != 0) {
                ((zzamz)this).seekTo(this.zzdkx);
            }
            ((zzamz)this).play();
        }
        if (this.zzdkv != null) {
            this.zzdkv.zzh(n, n2);
        }
        zzaij.zzdfn.post((Runnable)new zzamu(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzahw.v("AdMediaPlayerView surface destroyed");
        if (this.zzdko != null && this.zzdkx == 0) {
            this.zzdkx = this.zzdko.getCurrentPosition();
        }
        if (this.zzdkv != null) {
            this.zzdkv.zztc();
        }
        zzaij.zzdfn.post((Runnable)new zzamv(this));
        this.zzaf(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzdkk.zzb(this);
        this.zzdle.zza(surfaceTexture, this.zzdky);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzamp.getDefaultSize((int)this.zzdkq, (int)n);
        int n4 = zzamp.getDefaultSize((int)this.zzdkr, (int)n2);
        if (this.zzdkq > 0 && this.zzdkr > 0 && this.zzdkv == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzdkq * n4 < n3 * this.zzdkr) {
                    n3 = n4 * this.zzdkq / this.zzdkr;
                } else if (this.zzdkq * n4 > n3 * this.zzdkr) {
                    n4 = n3 * this.zzdkr / this.zzdkq;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzdkr / this.zzdkq;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzdkq / this.zzdkr;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzdkq;
                n4 = this.zzdkr;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzdkq / this.zzdkr;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzdkr / this.zzdkq;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzdkv != null) {
            this.zzdkv.zzh(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdkt > 0 && this.zzdkt != n3 || this.zzdku > 0 && this.zzdku != n4) {
                this.zzsl();
            }
            this.zzdkt = n3;
            this.zzdku = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzsk() {
        zzahw.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzdkp == null || surfaceTexture == null) {
            return;
        }
        this.zzaf(false);
        try {
            Surface surface;
            zzbt.zzfb();
            this.zzdko = new MediaPlayer();
            this.zzdko.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzdko.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzdko.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzdko.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzdko.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzdko.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzdks = 0;
            if (this.zzdkw) {
                this.zzdkv = new zzanl(this.getContext());
                this.zzdkv.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzdkv.start();
                surface = this.zzdkv.zztd();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzdkv.zztc();
                    this.zzdkv = null;
                }
            }
            this.zzdko.setDataSource(this.getContext(), this.zzdkp);
            zzbt.zzfc();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzdko.setSurface(surface);
            this.zzdko.setAudioStreamType(3);
            this.zzdko.setScreenOnWhilePlaying(true);
            this.zzdko.prepareAsync();
            this.zzaf(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzdkp);
            zzahw.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzdko, 1, 0);
            return;
        }
    }

    private final void zzsl() {
        if (!this.zzdkl) {
            return;
        }
        if (this.zzsm() && this.zzdko.getCurrentPosition() > 0 && this.zzdkn != 3) {
            zzahw.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzdko.start();
            int n = this.zzdko.getCurrentPosition();
            long l = zzbt.zzes().currentTimeMillis();
            while (this.zzsm() && this.zzdko.getCurrentPosition() == n && zzbt.zzes().currentTimeMillis() - l <= 250L) {
            }
            this.zzdko.pause();
            ((zzamz)this).zzsn();
        }
    }

    private final void zzaf(boolean bl) {
        zzahw.v("AdMediaPlayerView release");
        if (this.zzdkv != null) {
            this.zzdkv.zztc();
            this.zzdkv = null;
        }
        if (this.zzdko != null) {
            this.zzdko.reset();
            this.zzdko.release();
            this.zzdko = null;
            this.zzaf(0);
            if (bl) {
                this.zzdkn = 0;
                this.zzdkn = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzahw.v("AdMediaPlayerView play");
        if (this.zzsm()) {
            this.zzdko.start();
            this.zzaf(3);
            this.zzdle.zzsq();
            zzaij.zzdfn.post((Runnable)new zzamw(this));
        }
        this.zzdkn = 3;
    }

    @Override
    public final void pause() {
        zzahw.v("AdMediaPlayerView pause");
        if (this.zzsm() && this.zzdko.isPlaying()) {
            this.zzdko.pause();
            this.zzaf(4);
            zzaij.zzdfn.post((Runnable)new zzamx(this));
        }
        this.zzdkn = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzsm()) {
            return this.zzdko.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzsm()) {
            return this.zzdko.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzahw.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzsm()) {
            this.zzdko.seekTo(n);
            this.zzdkx = 0;
            return;
        }
        this.zzdkx = n;
    }

    private final boolean zzsm() {
        return this.zzdko != null && this.zzdkm != -1 && this.zzdkm != 0 && this.zzdkm != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzdkv != null) {
            this.zzdkv.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzdko != null) {
            return this.zzdko.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzdko != null) {
            return this.zzdko.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzsn() {
        this.zza(this.zzdlf.getVolume());
    }

    private final void zza(float f) {
        if (this.zzdko != null) {
            try {
                this.zzdko.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzahw.zzcz((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzaf(int n) {
        if (n == 3) {
            this.zzdkk.zzto();
            this.zzdlf.zzto();
        } else if (this.zzdkm == 3) {
            this.zzdkk.zztp();
            this.zzdlf.zztp();
        }
        this.zzdkm = n;
    }

    static /* synthetic */ zzamy zza(zzamp zzamp2) {
        return zzamp2.zzdky;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzdkj.put(-1004, "MEDIA_ERROR_IO");
            zzdkj.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzdkj.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzdkj.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzdkj.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzdkj.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzdkj.put(1, "MEDIA_ERROR_UNKNOWN");
        zzdkj.put(1, "MEDIA_INFO_UNKNOWN");
        zzdkj.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzdkj.put(701, "MEDIA_INFO_BUFFERING_START");
        zzdkj.put(702, "MEDIA_INFO_BUFFERING_END");
        zzdkj.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzdkj.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzdkj.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzdkj.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzdkj.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

