/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzanl
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzank {
    private static final float[] zzdmn = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzani zzdmo;
    private final float[] zzdmk;
    private final float[] zzdmp;
    private final float[] zzdmq;
    private final float[] zzdmr;
    private final float[] zzdms;
    private final float[] zzdmt;
    private final float[] zzdmu;
    private float zzdmv;
    private float zzdmw;
    private float zzdmx;
    private int zzalu;
    private int zzalt;
    private SurfaceTexture zzdmy;
    private SurfaceTexture zzdmz;
    private int zzdna;
    private int zzdnb;
    private int zzdnc;
    private FloatBuffer zzdnd = ByteBuffer.allocateDirect(zzdmn.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzdne;
    private final Object zzdnf;
    private EGL10 zzdng;
    private EGLDisplay zzdnh;
    private EGLContext zzdni;
    private EGLSurface zzdnj;
    private volatile boolean zzdnk;
    private volatile boolean zzdnl;

    public zzanl(Context context) {
        super("SphericalVideoProcessor");
        this.zzdnd.put(zzdmn).position(0);
        this.zzdmk = new float[9];
        this.zzdmp = new float[9];
        this.zzdmq = new float[9];
        this.zzdmr = new float[9];
        this.zzdms = new float[9];
        this.zzdmt = new float[9];
        this.zzdmu = new float[9];
        this.zzdmv = Float.NaN;
        this.zzdmo = new zzani(context);
        this.zzdmo.zza(this);
        this.zzdne = new CountDownLatch(1);
        this.zzdnf = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzalt = n;
        this.zzalu = n2;
        this.zzdmz = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(int n, int n2) {
        Object object = this.zzdnf;
        synchronized (object) {
            this.zzalt = n;
            this.zzalu = n2;
            this.zzdnk = true;
            this.zzdnf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zztc() {
        Object object = this.zzdnf;
        synchronized (object) {
            this.zzdnl = true;
            this.zzdmz = null;
            this.zzdnf.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zztd() {
        if (this.zzdmz == null) {
            return null;
        }
        try {
            this.zzdne.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzdmy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzdnc;
        Object object = this.zzdnf;
        synchronized (object) {
            this.zzdnf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zznm() {
        Object object = this.zzdnf;
        synchronized (object) {
            this.zzdnf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzny zzny2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzdmz == null) {
            zzahw.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzdne.countDown();
            return;
        }
        zzanl zzanl2 = this;
        this.zzdng = (EGL10)EGLContext.getEGL();
        zzanl2.zzdnh = zzanl2.zzdng.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzanl2.zzdnh == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzanl2.zzdng.eglInitialize(zzanl2.zzdnh, nArray)) {
                bl2 = false;
            } else {
                object2 = zzanl2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzanl)object2).zzdng.eglChooseConfig(((zzanl)object2).zzdnh, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzanl2.zzdni = zzanl2.zzdng.eglCreateContext(zzanl2.zzdnh, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzanl2.zzdni == null || zzanl2.zzdni == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzanl2.zzdnj = zzanl2.zzdng.eglCreateWindowSurface(zzanl2.zzdnh, (EGLConfig)object, (Object)zzanl2.zzdmz, null);
                        bl2 = zzanl2.zzdnj == null || zzanl2.zzdnj == EGL10.EGL_NO_SURFACE ? false : zzanl2.zzdng.eglMakeCurrent(zzanl2.zzdnh, zzanl2.zzdnj, zzanl2.zzdnj, zzanl2.zzdni);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzanl2 = this;
        zzny zzny3 = zzny2 = zzoi.zzbqi;
        if (!((String)zzlc.zzio().zzd(zzny3)).equals(zzny2.zzje())) {
            zzny3 = zzny2;
            string2 = (String)zzlc.zzio().zzd(zzny3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzanl.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzny3 = zzny2 = zzoi.zzbqj;
            if (!((String)zzlc.zzio().zzd(zzny3)).equals(zzny2.zzje())) {
                zzny3 = zzny2;
                string3 = (String)zzlc.zzio().zzd(zzny3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzanl.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzanl.zzdb("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzanl.zzdb("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzanl.zzdb("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzanl.zzdb("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzanl.zzdb("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzanl.zzdb("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzanl.zzdb("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzdna = n;
        GLES20.glUseProgram((int)zzanl2.zzdna);
        zzanl.zzdb("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzanl2.zzdna, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzanl2.zzdnd);
        zzanl.zzdb("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzanl.zzdb("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzanl.zzdb("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzanl.zzdb("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzanl.zzdb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzanl.zzdb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzanl.zzdb("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzanl.zzdb("texParameteri");
        zzanl2.zzdnb = GLES20.glGetUniformLocation((int)zzanl2.zzdna, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzanl2.zzdnb, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzdna != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzdng.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzahw.e((String)string6);
            zzbt.zzep().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zztf();
            this.zzdne.countDown();
            return;
        }
        this.zzdmy = new SurfaceTexture(n7);
        this.zzdmy.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzdne.countDown();
        this.zzdmo.start();
        try {
            this.zzdnk = true;
            while (!this.zzdnl) {
                this.zzte();
                if (this.zzdnk) {
                    zzanl2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzanl2.zzalt, (int)zzanl2.zzalu);
                    zzanl.zzdb("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzanl2.zzdna, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzanl2.zzdna, (String)"uFOVy");
                    if (zzanl2.zzalt > zzanl2.zzalu) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzanl2.zzalu / (float)zzanl2.zzalt));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzanl2.zzalt / (float)zzanl2.zzalu));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzdnk = false;
                }
                try {
                    Object object3 = this.zzdnf;
                    synchronized (object3) {
                        if (!this.zzdnl && !this.zzdnk && this.zzdnc == 0) {
                            this.zzdnf.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzahw.zzcz((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzahw.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbt.zzep().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzdmo.stop();
            this.zzdmy.setOnFrameAvailableListener(null);
            this.zzdmy = null;
            this.zztf();
        }
    }

    private final void zzte() {
        while (this.zzdnc > 0) {
            this.zzdmy.updateTexImage();
            --this.zzdnc;
        }
        if (this.zzdmo.zza(this.zzdmk)) {
            if (Float.isNaN(this.zzdmv)) {
                float[] fArray = this.zzdmk;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzdmk;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzdmv = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzanl.zzb(this.zzdmt, this.zzdmv + this.zzdmw);
        } else {
            zzanl.zza(this.zzdmk, -1.5707964f);
            zzanl.zzb(this.zzdmt, this.zzdmw);
        }
        zzanl.zza(this.zzdmp, 1.5707964f);
        zzanl.zza(this.zzdmq, this.zzdmt, this.zzdmp);
        zzanl.zza(this.zzdmr, this.zzdmk, this.zzdmq);
        zzanl.zza(this.zzdms, this.zzdmx);
        zzanl.zza(this.zzdmu, this.zzdms, this.zzdmr);
        GLES20.glUniformMatrix3fv((int)this.zzdnb, (int)1, (boolean)false, (float[])this.zzdmu, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzanl.zzdb("drawArrays");
        GLES20.glFinish();
        this.zzdng.eglSwapBuffers(this.zzdnh, this.zzdnj);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzalt > this.zzalu) {
            f4 = 1.7453293f * f / (float)this.zzalt;
            f3 = 1.7453293f * f2 / (float)this.zzalt;
        } else {
            f4 = 1.7453293f * f / (float)this.zzalu;
            f3 = 1.7453293f * f2 / (float)this.zzalu;
        }
        this.zzdmw -= f4;
        this.zzdmx -= f3;
        if (this.zzdmx < -1.5707964f) {
            this.zzdmx = -1.5707964f;
        }
        if (this.zzdmx > 1.5707964f) {
            this.zzdmx = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzanl.zzdb("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzanl.zzdb("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzanl.zzdb("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzanl.zzdb("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzanl.zzdb("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zztf() {
        boolean bl = false;
        if (this.zzdnj != null && this.zzdnj != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzdng.eglMakeCurrent(this.zzdnh, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzdng.eglDestroySurface(this.zzdnh, this.zzdnj);
            this.zzdnj = null;
        }
        if (this.zzdni != null) {
            bl |= this.zzdng.eglDestroyContext(this.zzdnh, this.zzdni);
            this.zzdni = null;
        }
        if (this.zzdnh != null) {
            bl |= this.zzdng.eglTerminate(this.zzdnh);
            this.zzdnh = null;
        }
        return bl;
    }

    private static void zzdb(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

