/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzfls;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdm {
    private static final String TAG = zzdm.class.getSimpleName();
    protected Context zzaiq;
    private ExecutorService zzair;
    private DexClassLoader zzais;
    private zzcx zzait;
    private byte[] zzaiu;
    private volatile AdvertisingIdClient zzaiv = null;
    private volatile boolean zzahq = false;
    private Future zzaiw = null;
    private boolean zzaix;
    private volatile zzba zzaiy = null;
    private Future zzaiz = null;
    private zzcp zzaja;
    private boolean zzajb = false;
    private boolean zzajc = false;
    private Map<Pair<String, String>, zzes> zzajd;
    private boolean zzaje = false;
    private boolean zzajf = true;
    private boolean zzajg = false;

    public static zzdm zza(Context context, String string2, String string3, boolean bl) {
        zzdm zzdm2 = new zzdm(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdm zzdm3 = zzdm2;
            zzdm2.zzair = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            zzdm zzdm4 = zzdm3;
            zzdm3.zzahq = bl3;
            if (bl3) {
                zzdm4.zzaiw = zzdm4.zzair.submit(new zzdn(zzdm4));
            }
            zzdm zzdm5 = zzdm3;
            zzdm5.zzair.execute(new zzdp(zzdm5));
            try {
                object = zzf.zzahf();
                zzdm5.zzajb = zzf.zzcg((Context)zzdm5.zzaiq) > 0;
                zzdm5.zzajc = object.isGooglePlayServicesAvailable(zzdm5.zzaiq) == 0;
            }
            catch (Throwable throwable) {}
            zzdm3.zza(0, true);
            if (zzds.zzas()) {
                zzdm4 = zzoi.zzbrs;
                if (((Boolean)zzlc.zzio().zzd((zzny)zzdm4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdm5 = zzdm3;
            zzdm3.zzait = new zzcx(null);
            try {
                zzdm5.zzaiu = zzdm5.zzait.zzl((String)object);
            }
            catch (zzcy zzcy2) {
                throw new zzdj(zzcy2);
            }
            object = string4;
            zzdm5 = zzdm3;
            try {
                String string6;
                File file = zzdm5.zzaiq.getCacheDir();
                if (file == null && (file = zzdm5.zzaiq.getDir("dex", 0)) == null) {
                    throw new zzdj();
                }
                String string7 = string6 = "1510898742191";
                File file2 = file;
                Object object2 = object;
                zzdm zzdm6 = zzdm5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdm6.zzait.zzb(zzdm6.zzaiu, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdm5.zzb(file, string6);
                try {
                    zzdm5.zzais = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdm5.zzaiq.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdm.zzb(file4);
                    zzdm5.zza(file, string6);
                    zzdm.zzm(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdm.zzb(file4);
                zzdm5.zza(file, string6);
                zzdm.zzm(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzdj(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzdj(iOException);
            }
            catch (zzcy zzcy3) {
                throw new zzdj(zzcy3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzdj(nullPointerException);
            }
            zzdm4 = zzdm3;
            zzny zzny2 = zzoi.zzbrk;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && !zzdm4.zzajg) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdm4.zzaiq.registerReceiver((BroadcastReceiver)new zza(zzdm4, null), intentFilter);
                zzdm4.zzajg = true;
            }
            zzdm3.zzaja = new zzcp(zzdm3);
            zzdm3.zzaje = true;
        }
        catch (zzdj zzdj2) {}
        return zzdm2;
    }

    public final Context getContext() {
        return this.zzaiq;
    }

    public final boolean isInitialized() {
        return this.zzaje;
    }

    public final ExecutorService getExecutorService() {
        return this.zzair;
    }

    public final DexClassLoader zzaf() {
        return this.zzais;
    }

    public final zzcx zzag() {
        return this.zzait;
    }

    public final byte[] zzah() {
        return this.zzaiu;
    }

    public final boolean zzai() {
        return this.zzajb;
    }

    public final zzcp zzaj() {
        return this.zzaja;
    }

    public final boolean zzak() {
        return this.zzajc;
    }

    public final boolean zzal() {
        return this.zzajf;
    }

    public final zzba zzam() {
        return this.zzaiy;
    }

    public final Future zzan() {
        return this.zzaiz;
    }

    private zzdm(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzaix = context2 != null;
        this.zzaiq = this.zzaix ? context2 : context;
        this.zzajd = new HashMap<Pair<String, String>, zzes>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            return;
        }
        zzbe zzbe2 = new zzbe();
        new zzbe().zzgm = Build.VERSION.SDK.getBytes();
        zzbe2.zzgl = string2.getBytes();
        byte[] byArray2 = this.zzait.zzc(this.zzaiu, byArray).getBytes();
        zzbe2.data = byArray2;
        zzbe2.zzgk = zzbx.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzfls.zzc((zzfls)zzbe2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdm.zzb(file2);
        return;
        catch (zzcy | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdm.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbe zzbe2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdm.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdm.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbe2 = (zzbe)zzfls.zza((zzfls)new zzbe(), (byte[])byArray2);
                if (string2.equals(new String(zzbe2.zzgl)) && Arrays.equals(zzbe2.zzgk, zzbx.zzb(zzbe2.data)) && Arrays.equals(zzbe2.zzgm, Build.VERSION.SDK.getBytes())) break block30;
                zzdm.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzait.zzb(this.zzaiu, new String(zzbe2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcy | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzajd.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzajd.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzes(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzes zzes2 = this.zzajd.get(new Pair((Object)string2, (Object)string3));
        if (zzes2 == null) {
            return null;
        }
        return zzes2.zzbb();
    }

    private final void zzao() {
        try {
            if (this.zzaiv == null && this.zzaix) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaiq);
                advertisingIdClient.start();
                this.zzaiv = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaiv = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzajc) {
            return;
        }
        Future<?> future = this.zzair.submit(new zzdo(this, n, bl));
        if (n == 0) {
            this.zzaiz = future;
        }
    }

    @VisibleForTesting
    final zzba zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzap();
    }

    private static boolean zza(int n, zzba zzba2) {
        if (n < 4) {
            if (zzba2 == null) {
                return true;
            }
            zzny zzny2 = zzoi.zzbrv;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && (zzba2.zzcv == null || zzba2.zzcv.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzny2 = zzoi.zzbrw;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && (zzba2.zzfh == null || zzba2.zzfh.zzgf == null || zzba2.zzfh.zzgf == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzba zzap() {
        zzba zzba2 = null;
        try {
            PackageInfo packageInfo = this.zzaiq.getPackageManager().getPackageInfo(this.zzaiq.getPackageName(), 0);
            zzba2 = zzcda.zzm((Context)this.zzaiq, (String)this.zzaiq.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzba2;
    }

    public final AdvertisingIdClient zzaq() {
        if (!this.zzahq) {
            return null;
        }
        if (this.zzaiv != null) {
            return this.zzaiv;
        }
        if (this.zzaiw != null) {
            try {
                this.zzaiw.get(2000L, TimeUnit.MILLISECONDS);
                this.zzaiw = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzaiw.cancel(true);
            }
        }
        return this.zzaiv;
    }

    public final int zzab() {
        int n = Integer.MIN_VALUE;
        if (this.zzaja != null) {
            n = zzcp.zzab();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdm zzdm2) {
        zzdm2.zzao();
    }

    static /* synthetic */ zzba zza(zzdm zzdm2, zzba zzba2) {
        zzdm2.zzaiy = zzba2;
        return zzdm2.zzaiy;
    }

    static /* synthetic */ boolean zzb(int n, zzba zzba2) {
        return zzdm.zza(n, zzba2);
    }

    final class zza
    extends BroadcastReceiver {
        private /* synthetic */ zzdm zzajh;

        private zza(zzdm zzdm2) {
            this.zzajh = zzdm2;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                this.zzajh.zzajf = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                this.zzajh.zzajf = false;
            }
        }

        /* synthetic */ zza(zzdm zzdm2, zzdn zzdn2) {
            this(zzdm2);
        }
    }
}

