/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzae;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakq;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzaov;
import com.google.android.gms.internal.ads.zzaox;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzxc;
import com.google.android.gms.internal.ads.zzxh;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
public final class zzad {
    private final Object mLock = new Object();
    private Context mContext;
    private long zzxy = 0L;

    public final void zza(Context context, zzaop zzaop2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzaop2, true, null, string2, null, runnable);
    }

    @VisibleForTesting
    final void zza(Context context, zzaop zzaop2, boolean bl, @Nullable zzakq zzakq2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzbv.zzer().elapsedRealtime() - this.zzxy < 5000L) {
            zzalg.zzdp((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzxy = zzbv.zzer().elapsedRealtime();
        zzakq zzakq3 = zzakq2;
        if (zzakq3 == null) {
            bl2 = true;
        } else {
            long l = zzakq3.zzrg();
            zznl zznl2 = zznw.zzbff;
            bl2 = zzbv.zzer().currentTimeMillis() - l > (Long)zzkd.zzjd().zzd(zznl2) || !zzakq3.zzrh();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzalg.zzdp((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzalg.zzdp((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.mContext = context2 != null ? context2 : context;
        zzxc<JSONObject, JSONObject> zzxc2 = zzbv.zzez().zzb(this.mContext, zzaop2).zza("google.afma.config.fetchAppSettings", zzxh.zzbuf, zzxh.zzbuf);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzapi<JSONObject> zzapi2 = zzxc2.zzg(jSONObject);
            zzapi zzapi3 = zzaox.zza(zzapi2, zzae.zzxz, zzapn.zzczx);
            if (runnable != null) {
                zzapi2.zza(runnable, zzapn.zzczx);
            }
            zzaov.zza(zzapi3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

