/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.internal.ads.zzabi;
import com.google.android.gms.internal.ads.zzabr;
import com.google.android.gms.internal.ads.zzabs;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzatt;
import com.google.android.gms.internal.ads.zzkd;
import java.util.Map;
import java.util.Set;

@zzaer
public final class zzabh
extends zzabr {
    private static final Set<String> zzbzj = CollectionUtils.setOf((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbzk = "top-right";
    private boolean zzbzl = true;
    private int zzbzm = 0;
    private int zzbzn = 0;
    private int zzvc = -1;
    private int zzbzo = 0;
    private int zzbzp = 0;
    private int zzvb = -1;
    private final Object mLock = new Object();
    private final zzasg zzbss;
    private final Activity zzbza;
    private zzatt zzbzq;
    private ImageView zzbzr;
    private LinearLayout zzbzs;
    private zzabs zzbqh;
    private PopupWindow zzbzt;
    private RelativeLayout zzbzu;
    private ViewGroup zzbzv;

    public zzabh(zzasg zzasg2, zzabs zzabs2) {
        super(zzasg2, "resize");
        this.zzbss = zzasg2;
        this.zzbza = zzasg2.zzvc();
        this.zzbqh = zzabs2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzbza == null) {
                this.zzcb("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbss.zzvt() == null) {
                this.zzcb("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbss.zzvt().zzxl()) {
                this.zzcb("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbss.zzwa()) {
                this.zzcb("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzabh zzabh2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbv.zzek();
                zzabh2.zzvb = zzalo.zzcz(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbv.zzek();
                zzabh2.zzvc = zzalo.zzcz(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbv.zzek();
                zzabh2.zzbzo = zzalo.zzcz(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbv.zzek();
                zzabh2.zzbzp = zzalo.zzcz(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzabh2.zzbzl = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzabh2.zzbzk = string2;
            }
            zzabh2 = this;
            if (!(zzabh2.zzvb >= 0 && zzabh2.zzvc >= 0)) {
                this.zzcb("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbza.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzcb("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzop();
            if (nArray == null) {
                this.zzcb("Resize location out of screen or close button is not visible.");
                return;
            }
            zzkd.zziz();
            int n = zzaoa.zza((Context)this.zzbza, (int)this.zzvb);
            zzkd.zziz();
            int n2 = zzaoa.zza((Context)this.zzbza, (int)this.zzvc);
            ViewParent viewParent = this.zzbss.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbss.getView());
                if (this.zzbzt == null) {
                    this.zzbzv = (ViewGroup)viewParent;
                    zzbv.zzek();
                    bitmap = zzalo.zzt(this.zzbss.getView());
                    this.zzbzr = new ImageView((Context)this.zzbza);
                    this.zzbzr.setImageBitmap(bitmap);
                    this.zzbzq = this.zzbss.zzvt();
                    this.zzbzv.addView((View)this.zzbzr);
                } else {
                    this.zzbzt.dismiss();
                }
            } else {
                this.zzcb("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbzu = new RelativeLayout((Context)this.zzbza);
            this.zzbzu.setBackgroundColor(0);
            this.zzbzu.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbv.zzek();
            this.zzbzt = zzalo.zza((View)this.zzbzu, n, n2, false);
            this.zzbzt.setOutsideTouchable(true);
            this.zzbzt.setTouchable(true);
            this.zzbzt.setClippingEnabled(!this.zzbzl);
            this.zzbzu.addView(this.zzbss.getView(), -1, -1);
            this.zzbzs = new LinearLayout((Context)this.zzbza);
            zzkd.zziz();
            int n3 = zzaoa.zza((Context)this.zzbza, (int)50);
            zzkd.zziz();
            bitmap = new RelativeLayout.LayoutParams(n3, zzaoa.zza((Context)this.zzbza, (int)50));
            switch (this.zzbzk) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbzs.setOnClickListener((View.OnClickListener)new zzabi(this));
            this.zzbzs.setContentDescription((CharSequence)"Close button");
            this.zzbzu.addView((View)this.zzbzs, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzkd.zziz();
                int n4 = zzaoa.zza((Context)this.zzbza, (int)nArray[0]);
                zzkd.zziz();
                this.zzbzt.showAtLocation(view, 0, n4, zzaoa.zza((Context)this.zzbza, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzcb(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzbzu.removeView(this.zzbss.getView());
                if (this.zzbzv != null) {
                    this.zzbzv.removeView((View)this.zzbzr);
                    this.zzbzv.addView(this.zzbss.getView());
                    this.zzbss.zza(this.zzbzq);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzabh2 = this;
            if (zzabh2.zzbqh != null) {
                zzabh2.zzbqh.zza(n6, n5, zzabh2.zzvb, zzabh2.zzvc);
            }
            this.zzbss.zza(zzatt.zzi(n, n2));
            this.zza(nArray[0], nArray[1]);
            this.zzcd("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbzt != null) {
                this.zzbzt.dismiss();
                this.zzbzu.removeView(this.zzbss.getView());
                if (this.zzbzv != null) {
                    this.zzbzv.removeView((View)this.zzbzr);
                    this.zzbzv.addView(this.zzbss.getView());
                    this.zzbss.zza(this.zzbzq);
                }
                if (bl) {
                    this.zzcd("default");
                    if (this.zzbqh != null) {
                        this.zzbqh.zzcp();
                    }
                }
                this.zzbzt = null;
                this.zzbzu = null;
                this.zzbzv = null;
                this.zzbzs = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzop() {
        zzabh zzabh2 = this;
        int[] nArray = zzbv.zzek().zzh(zzabh2.zzbza);
        int[] nArray2 = zzbv.zzek().zzi(zzabh2.zzbza);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzabh2.zzvb < 50 || zzabh2.zzvb > n) {
            zzalg.zzdp((String)"Width is too small or too large.");
            return null;
        }
        if (zzabh2.zzvc < 50 || zzabh2.zzvc > n2) {
            zzalg.zzdp((String)"Height is too small or too large.");
            return null;
        }
        if (zzabh2.zzvc == n2 && zzabh2.zzvb == n) {
            zzalg.zzdp((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzabh2.zzbzl) {
            int n3;
            int n4;
            switch (zzabh2.zzbzk) {
                case "top-left": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp;
                    break;
                }
                case "top-center": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo + zzabh2.zzvb / 2 - 25;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp;
                    break;
                }
                case "center": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo + zzabh2.zzvb / 2 - 25;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp + zzabh2.zzvc / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp + zzabh2.zzvc - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo + zzabh2.zzvb / 2 - 25;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp + zzabh2.zzvc - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo + zzabh2.zzvb - 50;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp + zzabh2.zzvc - 50;
                    break;
                }
                default: {
                    n4 = zzabh2.zzbzm + zzabh2.zzbzo + zzabh2.zzvb - 50;
                    n3 = zzabh2.zzbzn + zzabh2.zzbzp;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzbzl) {
            return new int[]{this.zzbzm + this.zzbzo, this.zzbzn + this.zzbzp};
        }
        int[] nArray3 = zzbv.zzek().zzh(this.zzbza);
        int[] nArray4 = zzbv.zzek().zzi(this.zzbza);
        int n5 = nArray3[0];
        int n6 = this.zzbzm + this.zzbzo;
        int n7 = this.zzbzn + this.zzbzp;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzvb > n5) {
            n6 = n5 - this.zzvb;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzvc <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzvc;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbzm = n;
            this.zzbzn = n2;
            if (this.zzbzt != null && bl) {
                int[] nArray = this.zzop();
                if (nArray != null) {
                    zzkd.zziz();
                    int n3 = zzaoa.zza((Context)this.zzbza, (int)nArray[0]);
                    zzkd.zziz();
                    this.zzbzt.update(n3, zzaoa.zza((Context)this.zzbza, (int)nArray[1]), this.zzbzt.getWidth(), this.zzbzt.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzm(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbv.zzek().zzi(this.zzbza)[0];
        this.zzb(n, n2 - n3, this.zzvb, this.zzvc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzoq() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbzt != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzbzm = n;
        this.zzbzn = n2;
    }
}

